
/* $Id: ExCAction.cpp,v 1.4 2002/12/13 11:45:02 data Exp $ */

#include "ExCAction.h"

ExCAction::ExCAction()
{
Guard(ExCAction::ExCAction())
	m_NextAction=NULL;
	m_Action=0;
	m_ActionNumber=0;
	m_executed=false;
	m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
	m_ExecutingLife=-1;
	m_NumberOfExecution=1;
	m_Param="NULL";
	m_Param1="NULL";
	m_Param2="NULL";
UnGuard
}

ExCAction::~ExCAction()
{
Guard(ExCAction::~ExCAction())
UnGuard
}

ExCAction::ExCAction(const ExCAction& Action)
{
Guard(ExCAction::ExCAction(const ExCAction& Action))
	m_NextAction=Action.m_NextAction;
	m_Action=Action.m_Action;
	m_ActionNumber=0;
	m_NumberOfExecution=Action.m_NumberOfExecution;
	m_executed=Action.m_executed;
	m_StartingLife=Action.m_StartingLife;
	m_ExecutingLife=Action.m_ExecutingLife;
	m_Param=Action.m_Param;
	m_Param1=Action.m_Param1;
	m_Param2=Action.m_Param2;
UnGuard
}

ExCAction::ExCAction(int Action)
{
Guard(ExCAction::ExCAction(int Action))
	m_NumberOfExecution=1;
	m_NextAction=NULL;
	m_Action=Action;
	m_ActionNumber=0;
	m_executed=false;
	m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
	m_ExecutingLife=-1;
	m_Param="NULL";
	m_Param1="NULL";
	m_Param2="NULL";
UnGuard
}

ExCAction::ExCAction(int Action,std::string Param)
{
Guard(ExCAction::ExCAction(int Action,std::string Param))	
	m_NumberOfExecution=1;
	m_NextAction=NULL;
	m_Action=Action;
	m_ActionNumber=0;
	m_executed=false;
	m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
	m_ExecutingLife=-1;
	m_Param=Param;
UnGuard
}

// Friends
std::ostream& operator<<(std::ostream& s,const ExCAction &action)
{
	s<<" Action :"<<action.m_Action<<" Param :"<<action.m_Param;
	s<<" Param1 :"<<action.m_Param1<<" Param2 :"<<action.m_Param2<<std::endl;
	return s;
}
std::ostrstream& operator<<(std::ostrstream& s,const ExCAction &action)
{
	s<<" Action :"<<action.m_Action<<" Param :"<<action.m_Param;
	s<<" Param1 :"<<action.m_Param1<<" Param2 :"<<action.m_Param2<<std::endl;
	return s;
}



void ExCAction::SetParam(int ParamNumber,std::string Param)
{
	Guard(void ExCAction::SetParam(int ParamNumber,std::string Param))
	if(GetNumberParam()<ParamNumber)throw ExCExpParameterBadNumberParam();
	m_VecParam.at(ParamNumber)=Param;
UnGuard
}

int ExCAction::GetParamAsInt(int ParamNumber)
{
Guard(int ExCAction::GetParamAsInt(int ParamNumber))
	switch(ParamNumber) 
	{
	case 0:return atoi(m_Param.data());
	case 1:return atoi(m_Param1.data());
	case 2:return atoi(m_Param2.data());
	default:return -1;
	}
/*	if(GetNumberParam()<ParamNumber)throw ExCExpParameterBadNumberParam();
	try
	{
		return atoi(m_VecParam.at(ParamNumber).data());
	}catch (...) 
	{
		throw ExCExpParameterConversionError();
	}
	return true;*/
UnGuard
}



bool ExCAction::AllActionDone()
{
Guard(bool ExCAction::AllActionDone())
	while(this->m_NextAction!=NULL)
	{
		if(this->m_executed==false)
		{
			return false;//one action is not done return false to keep action
		}
	}
	return true;
UnGuard
}
