/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCAction.h										*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :                                                        */


#ifndef __EXCACTION_H__
#define __EXCACTION_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
//--------------------------------
class ExCAction 
{
protected:
//--------------------------------
// Variable
//--------------------------------
public:
	int							m_Action;			//action id
	int							m_ActionNumber;		//action number if there is more than one action chained

	std::vector<std::string>	m_VecParam;			//vecteur of param

	std::string					m_Param;			//action parameter
	std::string					m_Param1;			//action parameter
	std::string					m_Param2;			//action parameter
		
	double						m_StartingLife;		//time when action is create
	double						m_ExecutingLife;	//time when action will be executed
	bool						m_executed;			//flag if action is executed 
	
	int							m_NumberOfExecution;//-1 if inf 
	ExCAction					*m_NextAction;  // to next action to chain action

//--------------------------------
// Constructor // Destructor
//--------------------------------
   ExCAction();
   ExCAction(const ExCAction& Action);
   ExCAction(int Action);
   ExCAction(int Action, std::string Param);
   ExCAction(int Action, std::string Param, std::string Param1);
   ExCAction(int Action, std::string Param, std::string Param1, std::string Param2);
   ~ExCAction();
//--------------------------------
// Methode
//--------------------------------
   inline void SetParam(std::string Param){m_Param=Param;}
   inline void SetParam1(std::string Param){m_Param1=Param;}
   inline void SetParam2(std::string Param){m_Param2=Param;}
   inline std::string GetParam(void){return m_Param;}
   inline std::string GetParam1(void){return m_Param1;}
   inline std::string GetParam2(void){return m_Param2;}

   void SetParam(int ParamNumber,std::string Param);

   int  GetParamAsInt(int ParamNumber);
   float GetParamAsFloat(int ParamNumber);
   std::string GetParam(int ParamNumber);
   double  GetParamAsDouble(int ParamNumber);
   bool GetParamAsBool(int ParamNumber);
   inline int GetNumberParam(void){return (int) m_VecParam.size();}
   
   bool AllActionDone();
   //--------------------------------
// friends
//--------------------------------	
	friend std::ostream& operator<<(std::ostream& s,const ExCAction &action);
	friend std::ostrstream& operator<<(std::ostrstream& s,const ExCAction &action);
};
//--------------------------------------------------------------
//Action list for manager
//--------------------------------------------------------------
#define START_BASIC_ACTION_MAP						30000
	#define NOTHING									0
	#define QUIT									30001
	#define RESET									30002
	#define RELOAD									30003
#define END_BASIC_ACTION_MAP						30098
//-----------------------------
//Cammera Action start at 30100
//-----------------------------
#define START_CAMERA_ACTION_MAP						30099
	#define CAMERA_CURRENT_START_ROTATEX_UP			30100
	#define CAMERA_CURRENT_STOP_ROTATEX_UP			30101
	#define CAMERA_CURRENT_ROTATEX_UP				30102

	#define CAMERA_CURRENT_START_ROTATEX_DOWN		30103
	#define CAMERA_CURRENT_STOP_ROTATEX_DOWN		30104
	#define CAMERA_CURRENT_ROTATEX_DOWN				30105

	#define CAMERA_CURRENT_START_ROTATEY_UP			30106
	#define CAMERA_CURRENT_STOP_ROTATEY_UP			30107
	#define CAMERA_CURRENT_ROTATEY_UP				30108

	#define CAMERA_CURRENT_START_ROTATEY_DOWN		30109
	#define CAMERA_CURRENT_STOP_ROTATEY_DOWN		30110
	#define CAMERA_CURRENT_ROTATEY_DOWN				30111

	#define CAMERA_CURRENT_START_ROTATEZ_UP			30112
	#define CAMERA_CURRENT_STOP_ROTATEZ_UP			30113
	#define CAMERA_CURRENT_ROTATEZ_UP				30114

	#define CAMERA_CURRENT_START_ROTATEZ_DOWN		30115
	#define CAMERA_CURRENT_STOP_ROTATEZ_DOWN		30116
	#define CAMERA_CURRENT_ROTATEZ_DOWN				30117

	#define CAMERA_CURRENT_START_INCREASE_SPEED		30121
	#define CAMERA_CURRENT_STOP_INCREASE_SPEED		30122
	#define CAMERA_CURRENT_INCREASE_SPEED			30123

	#define CAMERA_CURRENT_START_DECREASE_SPEED		30124
	#define CAMERA_CURRENT_STOP_DECREASE_SPEED		30125
	#define CAMERA_CURRENT_DECREASE_SPEED			30126

	#define CAMERA_CURRENT_FULL_STOP				30127

	#define CAMERA_NEXT_CAM							30128
	#define CAMERA_PREV_CAM							30129
	
	#define CAMERA_CURRENT_START_INCREASE_ZOOM		30130	
	#define CAMERA_CURRENT_STOP_INCREASE_ZOOM		30131
	#define CAMERA_CURRENT_INCREASE_ZOOM			30132
	
	#define CAMERA_CURRENT_START_DECREASE_ZOOM		30133
	#define CAMERA_CURRENT_STOP_DECREASE_ZOOM		30134
	#define CAMERA_CURRENT_DECREASE_ZOOM			30135

	#define CAMERA_SET_POS_X						30136
	#define CAMERA_SET_POS_Y						30137
	#define CAMERA_SET_POS_Z						30138
	#define CAMERA_SET_TARGET_POS_X					30139
	#define CAMERA_SET_TARGET_POS_Y					30140
	#define CAMERA_SET_TARGET_POS_Z					30141
	#define CAMERA_SET_ANGLE_X						30142
	#define CAMERA_SET_ANGLE_Y						30143
	#define CAMERA_SET_ANGLE_Z						30144
	//for chase cam 
	#define CAMERA_CURRENT_START_INCREASE_AROUND	30145	
	#define CAMERA_CURRENT_STOP_INCREASE_AROUND		30146
	#define CAMERA_CURRENT_START_DECREASE_AROUND	30147
	#define CAMERA_CURRENT_STOP_DECREASE_AROUND		30148
	#define CAMERA_CURRENT_SET_AROUND				30149

	#define CAMERA_CURRENT_START_INCREASE_DISTANCE	30150	
	#define CAMERA_CURRENT_STOP_INCREASE_DISTANCE	30151
	#define CAMERA_CURRENT_START_DECREASE_DISTANCE	30152
	#define CAMERA_CURRENT_STOP_DECREASE_DISTANCE	30153
	#define CAMERA_CURRENT_SET_DISTANCE				30154
	
	#define CAMERA_CURRENT_START_INCREASE_HEIGHT	30155	
	#define CAMERA_CURRENT_STOP_INCREASE_HEIGHT		30156
	#define CAMERA_CURRENT_START_DECREASE_HEIGHT	30157
	#define CAMERA_CURRENT_STOP_DECREASE_HEIGHT		30158
	#define CAMERA_CURRENT_SET_HEIGHT				30159	
	
	#define RELOAD_MANAGER_CAMERA					30160	

	#define CAMERA_CURRENT_SHOW_INFO				30161
	#define CAMERA_CURRENT_HIDE_INFO				30162

#define END_CAMERA_ACTION_MAP						30198
//-----------------------------
//Sound Action start at 30300	
//-----------------------------
#define START_SOUND_ACTION_MAP						30299
	#define LIST_SOUND								30300
	#define REMOVE_SOUND							30301
	#define PLAY_SOUND								30302
	#define STOP_SOUND								30303
	#define SET_REPEATS_SOUND						30304
	#define GET_REPEATS_SOUND						30305
	#define ADD_SOUND								30306
	#define PAUSE_SOUND								30307
	#define RELOAD_MANAGER_SOUND					30308
#define END_SOUND_ACTION_MAP						30398
//-------------------------------
//Interface Action start at 30400	
//-------------------------------
#define START_INTERFACE_ACTION_MAP					30399
	#define SHOW_INTERFACE_REGION					30400
	#define HIDE_INTERFACE_REGION					30401
	#define LIST_INTERFACE							30402
	#define ENABLE_INTERFACE						30403
	#define DISABLE_INTERFACE						30404
	#define ADD_INTERFACE							30405
	#define ENABLE_ALL_INTERFACE					30406
	#define DISABLE_ALL_INTERFACE					30407
	#define RELOAD_MANAGER_INTERFACE				30408
#define END_INTERFACE_ACTION_MAP					30498
//-------------------------------
//Map Action start at 30500	
//-------------------------------
#define START_MAP_ACTION_MAP						30499
	#define SHOW_MAP_SKY_BOX						30500
	#define HIDE_MAP_SKY_BOX						30501
	#define SHOW_MAP_MESH							30502
	#define HIDE_MAP_MESH							30503
	#define ENABLE_MAP_OCTREE						30504
	#define DISABLE_MAP_OCTREE						30505
	#define SHOW_MAP_OCTREE_SUBDIVISON				30506
	#define HIDE_MAP_OCTREE_SUBDIVISON				30507
	#define HEIGHTMAP_INCREASE_DETAIL_LEVEL			30508
	#define HEIGHTMAP_DECREASE_DETAIL_LEVEL			30509
	#define HEIGHTMAP_ENABLE_FOG					30510
	#define HEIGHTMAP_DISABLE_FOG					30511
	#define HEIGHTMAP_SWITCH_FOG					30512
	#define HEIGHTMAP_INCREASE_FOG_DEPHT_LEVEL		30513
	#define HEIGHTMAP_DECREASE_FOG_DEPHT_LEVEL		30514
	#define HEIGHTMAP_INCREASE_TEXTURE_2_REPETITION	30515
	#define HEIGHTMAP_DECREASE_TEXTURE_2_REPETITION	30516
	#define RELOAD_MANAGER_MAP						30517
#define END_MAP_ACTION_MAP							30594

//-------------------------------
//fog Action start at 30600	
//-------------------------------
#define START_FOG_ACTION_MAP						30599
	#define ENABLE_FOG								30600
	#define DISABEL_FOG								30601
	#define SET_FOG_COLOR_R							30602
	#define SET_FOG_COLOR_G							30603
	#define SET_FOG_COLOR_B							30604
	#define SET_FOG_START_POINT						30605
	#define SET_FOG_END_POINT						30606
	#define SET_FOG_DENSITY							30607
	#define SET_FOG_ALGO_LINEAR						30608
	#define SET_FOG_ALGO_EXP2						30609
	#define SET_FOG_ALGO_EXP						30610
	#define RELOAD_MANAGER_FOG						30611
#define END_FOG_ACTION_MAP							30698
//---------------------------------------
//Particule systeme Action start at 30700	
//---------------------------------------
#define START_PARTICULESYSTEME_ACTION_MAP			30699
	#define LOAD_PARTICULESYSTEME					30700
	#define STAR_PARTICULESYSTEME					30701
	#define STOP_PARTICULESYSTEME					30702
	#define PAUSE_PARTICULESYSTEME					30703
	#define STAR_ALL_PARTICULESYSTEME				30704
	#define STOP_ALL_PARTICULESYSTEME				30705
	#define PAUSE_ALL_PARTICULESYSTEME				30706
	#define LIST_PARTICULESYSTEME					30707
	#define RELOAD_MANAGER_PARTICULESYSTEME			30708
#define END_PARTICULESYSTEME_ACTION_MAP				30799

//-----------------------------
//Consol Action start at 30800
//-----------------------------
#define START_CONSOL_ACTION_MAP						30800
	#define ENABLE_CONSOL_BACKGROUND_TEXTURE		30801
	#define DISABLE_CONSOL_BACKGROUND_TEXTURE		30802
 	#define SET_CONSOL_BACKGROUND_TEXURE			30803
	#define SET_CONSOL_BACKGROUND_COLOR				30804
	#define SET_CONSOL_BACKGROUND_COLOR_BLUE		30805
	#define SET_CONSOL_BACKGROUND_COLOR_GREEN		30806
	#define SET_CONSOL_BACKGROUND_COLOR_RED			30807
	#define ENABLE_CONSOL_BACKGROUND_BLENDING		30809
	#define DISABLE_CONSOL_BACKGROUND_BLENDING		30810
	#define SET_CONSOL_BACKGROUND_BLENDING			30811
	#define SHOW_FULL_CONSOL						30812
	#define SHOW_HALF_CONSOL						30813
	#define HIDE_CONSOL								30814
	#define CONSOL_NEXT_AVIABLE_STATE				30815
	#define CONSOL_LINE_UP							30816
	#define CONSOL_LINE_DOWN						30817
	#define RELOAD_MANAGER_CONSOL					30818
#define END_CONSOL_ACTION_MAP						30899
//-----------------------------
//Model Action start at 30900
//-----------------------------
#define START_MODEL_ACTION_MAP						30900
	//MANAGER ACTION
	#define LIST									30901
	#define SET_CURRENT_OBJECT_BY_ID				30902
	#define SET_CURRENT_OBJECT_BY_NAME				30903
	//MODEL ACTION
	#define NEXT_FRAME								30904
	#define PREVIOUS_FRAME							30905
	#define SET_CURENT_FRAME						30906
	//---------------------------------------------------
	#define TURN_LEFT								30940
	#define TURN_RIGHT								30941
	#define LOOK_UP  								30942
	#define LOOK_DOWN								30943
	#define START_RUN								30950
	#define STOP_RUN								30951
	#define START_ACTION							30952
	#define STOP_ACTION								30953
	//---------------------------------------------------
	#define MODEL_SET_POS_X							30954
	#define MODEL_SET_POS_Y							30955
	#define MODEL_SET_POS_Z							30956
	#define MODEL_SET_ANGLE_X						30957
	#define MODEL_SET_ANGLE_Y						30958
	#define MODEL_SET_ANGLE_Z						30959
	#define MODEL_SET_ACTION						30960
	#define MODEL_LOAD_WITH_NAME					30961
	#define MODEL_LOAD								30962
	//-----------
	#define MODEL_START_ROTATE_Y_DOWN				30963
	#define MODEL_STOP_ROTATE_Y_DOWN				30964
	#define MODEL_START_ROTATE_Y_UP					30965
	#define MODEL_STOP_ROTATE_Y_UP					30966
		
	#define MODEL_START_ROTATE_Z_DOWN				30967
	#define MODEL_STOP_ROTATE_Z_DOWN				30968
	#define MODEL_START_ROTATE_Z_UP					30969
	#define MODEL_STOP_ROTATE_Z_UP					30970
	
	#define MODEL_START_ROTATE_X_DOWN				30971
	#define MODEL_STOP_ROTATE_X_DOWN				30972
	#define MODEL_START_ROTATE_X_UP					30973
	#define MODEL_STOP_ROTATE_X_UP					30974

	#define MODEL_START_MOVE_FORWARD				30975
	#define MODEL_STOP_MOVE_FORWARD					30976
	#define MODEL_JUMP								30977
	#define MODEL_NEXT_MODEL						30978
	#define MODEL_PREV_MODEL						30979
	#define MODEL_STOP_ALL							30980
	#define MODEL_SHOW_COLLISION_SPHERE				30981
	#define MODEL_START_STRAFE_LEFT					30982
	#define MODEL_STOP_STRAFE_LEFT					30983
	#define MODEL_START_STRAFE_RIGHT				30984
	#define MODEL_STOP_STREFA_RIGHT					30985
	#define MANAGER_MODEL_RELOAD					30986
	#define MODEL_TOGGLE_VISIBLESTATE				30987
	#define MODEL_HIDE								30988
	#define MODEL_SHOW								30989
	#define MODEL_TOGGLE_ALWAYS_DRAW				30990
	#define MODEL_ALWAYS_DRAW_ON					30991
	#define MODEL_ALWAYS_DRAW_OFF					30992

	#define MODEL_SET_RENDER_MODE					30993
#define END_MODEL_ACTION_MAP						30999
//-----------------------------
//Main Window Action start at 31100
//-----------------------------
#define START_WINDOW_ACTION_MAP						31100
	#define SHOW_FPS_STAT							31101
	#define	HIDE_FPS_STAT							31102
	#define ENABLE_GRIDE							31103
	#define DISABLE_GRIDE							31104
	#define SWITCH_GRIDE							31105
	#define SET_RESOLUTION_800_600_16				31106
	#define SET_RESOLUTION_800_600_24				31107
	#define SET_RESOLUTION_800_600_32				31108
	#define SET_RESOLUTION_1024_768_16				31109
	#define SET_RESOLUTION_1024_768_24				31110
	#define SET_RESOLUTION_1024_768_32				31111
	#define SET_RESOLUTION_1600_1200_16				31112
	#define SET_RESOLUTION_1600_1200_24				31113
	#define SET_RESOLUTION_1600_1200_32				31114
	#define SET_POLYGONMODE_POINTS					31115
	#define SET_POLYGONMODE_LINES					31116
	#define SET_POLYGONMODE_FILL					31117
	#define MANAGER_WINDOW_RELOAD					31118
#define END_WINDOW_ACTION_MAP						31199

//-----------------------------
//Command Action start at 31200
//-----------------------------
#define START_COMMAND_ACTION_MAP					31200
	#define CHECK_DEVICE							31201	
	#define LOAD_EXEC_CONFIG_FILE					31202
	#define MANAGERCOMMAND_RELOAD					31203
#define END_COMMAND_ACTION_MAP						31299

//-----------------------------
//NetWork Action start at 31300
//-----------------------------
#define START_NETWORK_ACTION_MAP					31300
	#define SHOW_NET_STAT							31301
	#define HIDE_NET_STAT							31302
	#define CONNECT									31303
	#define DISCONNECT								31304
	#define SHOW_CHAT								31305
	#define HIDE_CHAT								31306
	#define SAY										31307
	#define MANAGER_NETWORK_RELOAD					31308
#define END_NETWORK_ACTION_MAP						31399

//-----------------------------
//Texture Action start at 31400
//-----------------------------
#define START_TEXTURE_ACTION_MAP					31400
	#define LIST_TEXTURE							31401
	#define LOAD_TEXTURE							31402
	#define UNLOAD_TEXTURE							31403
	#define SAVE_TEXTURE							31404
	#define MANAGER_TEXTURE_RELOAD					31405
#define END_TEXTURE_ACTION_MAP						31499

//-----------------------------
//ID Action start at 31500
//-----------------------------
#define START_ID_ACTION_MAP							31500
	#define ID_LIST									31501
	#define MANAGER_ID_RELOAD						31502
#define END_ID_ACTION_MAP							31599

//-----------------------------
//Object window Action start at 31600
//-----------------------------
#define START_OBJECT_WINDOW_ACTION_MAP				31600
	#define LIST_OBJECT_WINDOW						31601
	#define CLOSE_OBJECT_WINDOW						31602
	#define MINIMIZE_OBJECT_WINDOW					31603
	#define MAXIMIZE_OBJECT_WINDOW					31604
	#define MINIMIZE_TO_BAR_OBJECT_WINDOW			31605
	#define MOUVE_OBJECT_WINDOW						31606
	#define REQUEST_FOCUS_OBJECT_WINDOW				31607
	#define RELEASE_FOCUS_OBJECT_WINDOW				31608
	#define MESSAGE_BOX								31609
	#define MESSAGE_BOX_QUESTION					31610
	#define LOAD_OBJECT_WINDOW						31611
	#define ENABLE_WINDOW							31612
	#define DISABLE_WINDOW							31613
	#define	TOGGLE_WINDOW							31614
	#define	MANAGER_OBJECT_WINDOW_RELOAD			31615
#define END_OBJECT_WINDOW_ACTION_MAP				31699



//-----------------------------
//Special Effect Action start at 31700
//-----------------------------
#define START_SPECIALEFFECT_ACTION_MAP					31700
	#define START_FADE_TO_WHITE							31701
	#define STOP_FADE_TO_WHITE							31702
	#define START_WITHE_TO_FADE							31703
	#define STOP_WITHE_TO_FADE							31704
	#define START_FADE_TO_BLACK							31705
	#define STOP_FADE_TO_BLACK							31706
	#define START_BLACK_TO_FADE							31707
	#define STOP_BLACK_TO_FADE							31708
	#define START_MOTION_BLUR							31709
	#define STOP_MOTION_BLUR							31710
	#define ENABLE_ANTIALLIASING						31711
	#define DISABLE_ANTIALLIASING						31712
	#define MANAGER_SPECIALEFFECT_RELOAD				31713
#define END_SPECIALEFFECT_ACTION_MAP					31799

//-----------------------------
//Manager Mesh Action start at 31800
//-----------------------------
#define START_MESH_ACTION_MAP							31800
	#define MANAGER_MESH_RELOAD							31801
	#define MANAGER_MESH_RESET							31802
#define END_MESH_ACTION_MAP								31899
//-----------------------------
//Manager Load Action start at 31900
//-----------------------------
#define START_LOAD_ACTION_MAP							31900
	#define LOAD_COMMAND_CONFIG_FILE					31901
	#define LOAD_FILE									31902
	#define LOAD_SET_OF_FILE							31903
	#define LOAD_ENTITY_FILE							31904
	#define LOAD_MODELE_FILE							31905
	#define LOAD_MAP_FILE								31906
	#define LOAD_INTERFACE_FILE							31907
	#define LOAD_SOUND_FILE								31908
	#define LOAD_CONSOLE_CONFIG_FILE					31909
	#define LOAD_PART_CONFIG_FILE						31910
	#define NEXT_ANIMATION_FRAME						31911
	#define PREV_ANIMATION_FRAME						31912
	#define LAST_ANIMATION_FRAME						31913
	#define FIRST_ANIMATION_FRAME						31914
	#define ENABLE_LOADING_ANIMATION					31915
	#define DISABLE_LOADING_ANIMATION					31916
	#define MANAGER_LOADING_RELOAD						31917
#define END_LOAD_ACTION_MAP								31999
//-----------------------------
//Manager PVS Action start at 32000
//-----------------------------
#define START_PVS_ACTION_MAP						32000
	#define MANAGER_PVS_RELOAD						32001
#define END_PVS_ACTION_MAP							32099

//-----------------------------
//Manager PVS Action start at 32000
//-----------------------------
#define START_ANIMATION_ACTION_MAP							32100
	#define MANAGER_ANIMATION_RELOAD						32101
	#define MANAGER_ANIMATION_PAUSE_ALL_ANIMATION   		32102
	#define MANAGER_ANIMATION_UNPAUSE_ALL_ANIMATION   		32103
	#define MANAGER_ANIMATION_TOGGLE_PAUSE_ALL_ANIMATION   	32104
	#define MANAGER_ANIMATION_PAUSE_ANIMATION				32105
	#define MANAGER_ANIMATION_UNPAUSE_ANIMATION				32106
	#define MANAGER_ANIMATION_TOGGLE_ANIMATION				32107
	#define MANAGER_ANIMATION_SET_CURRENT_OBJECT_BY_ID		32108
	#define MANAGER_ANIMATION_SET_CURRENT_OBJECT_BY_NAME	32109
#define END_ANIMATION_ACTION_MAP							32199

//-----------------------------
//Manager ENTITY Action start at 32100
//-----------------------------
#define START_ENTITY_ACTION_MAP							32200
	#define MANAGER_ENTITY_RELOAD						32201
	#define MANAGER_ENTITY_SET_CURRENT_OBJECT_BY_ID		32202
	#define MANAGER_ENTITY_SET_CURRENT_OBJECT_BY_NAME	32203
	#define ENTITY_TOGGLE_VISIBLESTATE					32204
	#define ENTITY_HIDE									32205
	#define ENTITY_SHOW									32206
	#define MANAGER_ENTITY_RESET						32207
#define END_ENTITY_ACTION_MAP							32299

//-----------------------------
//CUSTOM Action start at 50000
//-----------------------------
#define START_CUSTOM_ACTION_ACTION_MAP					50000
	#define CUSTOM_ACTION_1								50001
	#define CUSTOM_ACTION_2								50002
	#define CUSTOM_ACTION_3								50003
	#define CUSTOM_ACTION_4								50004
#define END_CUSTOM_ACTION_ACTION_MAP					60000

//--------------------------------------------------------------
//Action list for object
//--------------------------------------------------------------
#define ROTATE_Z_UP									60000
#define ROTATE_Y_UP									60001
#define ROTATE_X_UP									60002
#define ROTATE_Z_DOWN								60003
#define ROTATE_Y_DOWN								60004
#define ROTATE_X_DOWN								60005
#define ZOOM_UP										60006
#define ZOOM_DOWN									60007
#define SPEED_UP									60008
#define SPEED_DOWN									60009
#define ANGLE_AROUND_TARGET_UP						60010
#define ANGLE_AROUND_TARGET_DOWN					60011
#define DISTANCE_FROM_TARGET_UP						60012
#define DISTANCE_FROM_TARGET_DOWN					60013
#define HEIGHT_FROM_TARGET_UP						60014
#define HEIGHT_FROM_TARGET_DOWN						60015
#endif //__EXCACTION_H__
