/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExDefine.h												*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :   
 * $Id: ExDefine.h,v 1.35 2002/12/13 11:44:58 data Exp $
 *
 */

#ifndef __EXDEFINE_H__
#define __EXDEFINE_H__

//------------------------------------------------------------------------
//lib to link
//------------------------------------------------------------------------
#if _WIN32
	#pragma comment(lib, "opengl32.lib")
	#pragma comment(lib, "glu32.lib")
	#pragma comment(lib, "glaux.lib")
	#pragma comment(lib, "OpenAL32.lib")
	#pragma comment(lib, "ws2_32.lib")
	#pragma comment(lib, "alut.lib")
	#pragma comment(lib, "openal32.lib")
	#pragma warning (disable : 4995)
#endif

#ifndef VERSION
	#define VERSION	"0.4"
#endif

#ifndef PREFIX
	#define PREFIX "/usr/local/share"
#endif

//------------------------------------------------------------------------
// Includes OpenGL
//------------------------------------------------------------------------
#if _WIN32
	#include <GL/glut.h>	//Header Glut Library
	#include <GL/gl.h>		//Header OpenGl
	#include <GL/glu.h>		//Header Glu toolkit OpenGl
	#include <GL/glext.h>
	#include <GL/glaux.h>	//header Glaux Library
	#include <GL/wglext.h>
#endif
#ifdef UNIX_SRC
	//#include <GL/glxext.h>	
#endif
//------------------------------------------------------------------------
// opengl extensions function
//------------------------------------------------------------------------
#if _WIN32
	extern	PFNGLLOCKARRAYSEXTPROC glLockArraysEXT ;
	extern PFNGLUNLOCKARRAYSEXTPROC glUnlockArraysEXT ;
#endif
//------------------------------------------------------------------------
// Includes OpenAL
//------------------------------------------------------------------------
#if _WIN32
	#include <AL/al.h>
	#include <AL/alc.h>
	#include <AL/alut.h>
#endif
//------------------------------------------------------------------------
// Includes C++ 
//------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
//#ifndef GCC_295
//	#include <ostream>
//#endif
#include <string.h>
#include <time.h>
#include <iostream>
#include <strstream>
#include <sys/stat.h>
#ifdef UNIX_SRC
	#include <typeinfo>
#endif
#if _WIN32
	#include <typeinfo.h>
#endif
//------------------------------------------------------------------------
// Includes STL
//------------------------------------------------------------------------
#include <string>
#include <algorithm>
#include <set>
#include <map>
#include <vector>
#include <list>
#include <stack>

#ifndef UNIX_SRC
	#define PI							3.1415926535897932384626433832795
#else
	#include <math.h>
	#define PI M_PI
#endif
//------------------------------------------------------------------------
// Define for rzo
//------------------------------------------------------------------------
//------------------------------------------------------------------------
// Define for Thread
//------------------------------------------------------------------------

//------------------------------------------------------------------------
// typedef
//------------------------------------------------------------------------
typedef unsigned int uint;
typedef unsigned char uchar;
typedef unsigned char byte;
//------------------------------------------------------------------------
// consol redirection
//------------------------------------------------------------------------
static std::ostrstream *Consol;
static std::ostrstream *ActionFlux;
#define CLEARCONSOL Consol.flush();

#include "Tools/ExCTrace.h"
#include "ExNihiloExecption.h"
#endif //_EXDEFINE_H__


