/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExNihiloNameSpace.h,v 1.5 2002/12/13 11:44:59 data Exp $ 
 *
 */

#ifndef __EXNIHILONAMESPACE_H__
#define __EXNIHILONAMESPACE_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "ExCCommand.h"	
#include "ExCAction.h"
//--------------------------------
namespace ExNihilo
{
	typedef long ExId;
	typedef std::pair<ExId,std::string> IdName;
	struct ExObjectInfo
	{
		ExId		 m_Id;
		std::string  m_Name;
		std::string  m_Type;
	};
	
	static unsigned int GRILLE;

	void InitBasicObjectList(void);
	void DrawGrid(int size);
	void InitString(void);
	void RenderBitmapString(float x, float y, void *font,std::string string);
	void EnterOrthoMode(void);
	void LeaveOrthoMode(void);
	std::string ExtracValueFromSring(std::string buffstring, std::string start,std::string end);
	int ExtractIntValueFromSring(std::string buffstring, std::string start,std::string end);
	float ExtractFloatValueFromSring(std::string buffstring, std::string start,std::string end);

	std::string ExtracStringValueFromFile(std::string FileName, std::string start,std::string end);
	int ExtractIntValueFromFile(std::string FileName, std::string start,std::string end);
	float ExtractFloatValueFromFile(std::string FileName, std::string start,std::string end);

	int ExtracStringCommandFromString(std::string FileName,std::string command,std::string &TargetString);
	int ExtracStringCommandFromFile(std::string FileName,std::string command,std::string &TargetString);

	ExCAction ExtractActionFromString(std::string FileName,std::string command,std::string &TargetString);

	void WriteToScreen(float x,float y,std::string String);
	void WriteToScreen(float x,float y,float r,float g,float b,std::string String);
	void WriteToScreen24(float x,float y,float r,float g,float b,std::string String);
	void DrawCadre(float x,float y,float lx,float ly,float r,float g,float b,float blend);

	void AddKeyToBuffer(int key,std::string &buffer);
	void ShowGlError(void);

	int GetResolutionX();
	int GetResolutionY();

	std::string GetFileExtension(std::string FileName);
}


#endif //__EXNIHILONAMESPACE_H__
