/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: Main.cpp,v 1.43 2002/12/13 11:44:59 data Exp $
 *
 */

#include "Main.h"

int fen;
int main(int argc, char* argv[])
{
Guard(int main(...))
	InitFlux();
	glutInit(&argc,argv);
	//glutInitDisplayMode(GLUT_RGBA|GLUT_SINGLE);
	//glutInitDisplayMode(GLUT_RGB|GLUT_DEPTH|GLUT_DOUBLE);
	//glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGBA|GLUT_DEPTH|GLUT_ACCUM|GLUT_STENCIL);
	//glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGBA|GLUT_ALPHA|GLUT_ACCUM);
	//glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGBA|GLUT_ALPHA|GLUT_STENCIL );
	//glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGBA|GLUT_DEPTH|GLUT_STENCIL);
	glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGBA|GLUT_DEPTH);

	CreateManager();
	SetManagerLink();
		
	*Consol<<"****************************************"<<std::endl;
	*Consol<<"*Starting ExNihilo Engine              *"<<std::endl;
	*Consol<<"****************************************"<<std::endl;
	//ManagerWindow->CreateNewWindow (options->getWindowResolutionX(), options->getWindowResolutionY (), 200, 200, argv[0]);
	//ManagerWindow->CreateNewWindow (640,480,argv[0]);
	//Check argument to load
	
	try
	{
		
		int x=1024,y=768;
		for(int i = 1; i < argc; i++) 
		{
			if(argv[i]) 
			{
				std::cout<<argv[i]<<std::endl;
				
			}
		}
		if(argc>2)
		{
			ManagerWindow->CreateNewWindow (atoi(argv[1]),atoi(argv[2]),argv[0]);
		}else	ManagerWindow->CreateNewWindow (x,y,argv[0]);

		if(atoi(argv[3])==1)m_FullScreen=true;
		else m_FullScreen=false;
			
		ManagerWindow->SetFullScreen(m_FullScreen);
		
		/*ManagerWindow->CreateNewWindow(1024,768,argv[0]);
		m_FullScreen=false;
		ManagerWindow->SetFullScreen(m_FullScreen);*/
	}catch (...) 
	{
		std::cout<<"Full screen fail start in window mode"<<std::endl;
	}
	PreInitManager();
	SetGlutCallBack();
	PostInitManager();

	*Consol<<"****************************************"<<std::endl;
	*Consol<<"*Lauching Engine                       *"<<std::endl;
	*Consol<<"****************************************"<<std::endl;
	//Check argument to load	
	for(int i = 1; i < argc; i++) {
		if(argv[i]) {
			//std::cout<<argv[i]<<std::endl;
			ManagerCommand->LoadFile(argv[i]);
		}
	}
	glutMainLoop();
	return 0;
UnGuard
}
void InitFlux(void)
{
Guard(void InitFlux(void))
	Consol = new std::ostrstream;
	FluxAction = new ExCFluxAction;
UnGuard
}


void CreateManager(void)
{
Guard(void CreateManager(void))
	//--------------------------------------------------
	//They can be have only one version of each manager 
	//--------------------------------------------------
	ManagerInputGLUT		= ExManagerInputGLUT::CreateSingleton();
	ManagerWindow			= ExManagerWindow::CreateSingleton();
	ManagerOutPut			= ExManagerOutput::CreateSingleton();
	ManagerCommand			= ExManagerCommand::CreateSingleton();
	ManagerId				= ExManagerId::CreateSingleton();
	ManagerCamera			= ExManagerCamera::CreateSingleton();
	ManagerConsole			= ExManagerConsole::CreateSingleton();
	ManagerTexture			= ExManagerTexture::CreateSingleton();
	ManagerCollision		= ExManagerCollision::CreateSingleton();
	ManagerInterface		= ExManagerInterface::CreateSingleton();
	ManagerMap				= ExManagerMap::CreateSingleton();
	ManagerParticuleSystem	= ExManagerParticuleSystem::CreateSingleton();
	ManagerGizmo			= ExManagerGizmo::CreateSingleton();
	ManagerLight			= ExManagerLight::CreateSingleton();
	ManagerFog				= ExManagerFog::CreateSingleton();
	ManagerAnimation		= ExManagerAnimation::CreateSingleton();
	ManagerSound			= ExManagerSound::CreateSingleton();
	ManagerSpirit			= ExManagerSpirit::CreateSingleton();
	ManagerNetwork			= ExManagerNetwork::CreateSingleton();
	ManagerModele			= ExManagerModel::CreateSingleton();
	ManagerFont				= ExManagerFont::CreateSingleton();
	ManagerSpecialEffect	= ExManagerSpecialEffect::CreateSingleton();
	ManagerVertexArrays     = ExManagerVertexArrays::CreateSingleton();
	ManagerVertexProgram	= ExManagerVertexProgram::CreateSingleton();
	ManagerObjectWindow		= ExManagerObjectWindow::CreateSingleton(); 
	ManagerMesh			    = ExManagerMesh::CreateSingleton();
	ManagerLoad				= ExManagerLoad::CreateSingleton();
	ManagerPVS				= ExManagerPVS::CreateSingleton(); 
	ManagerEntity			= ExManagerEntity::CreateSingleton(); 
UnGuard
}

void SetManagerLink(void)
{
Guard(void SetManagerLink(void))
	//-------------------------------------------------------------------------------
	//Set consol flux to all manager (after that tehy can write on the engine consol
	//-------------------------------------------------------------------------------
	ManagerWindow->SetFlux(Consol,FluxAction);
	ManagerOutPut->SetFlux(Consol,FluxAction);
	ManagerId->SetFlux(Consol,FluxAction);
	ManagerCommand->SetFlux(Consol,FluxAction);
	ManagerInputGLUT->SetFlux(Consol,FluxAction);
	ManagerCamera->SetFlux(Consol,FluxAction);
	ManagerConsole->SetFlux(Consol,FluxAction);
	ManagerTexture->SetFlux(Consol,FluxAction);
	ManagerCollision->SetFlux(Consol,FluxAction);
	ManagerInterface->SetFlux(Consol,FluxAction);
	ManagerMap->SetFlux(Consol,FluxAction);
    ManagerParticuleSystem->SetFlux(Consol,FluxAction);
	ManagerGizmo->SetFlux(Consol,FluxAction);
	ManagerLight->SetFlux(Consol,FluxAction);
	ManagerFog->SetFlux(Consol,FluxAction);
	ManagerAnimation->SetFlux(Consol,FluxAction);
	ManagerSpirit->SetFlux(Consol,FluxAction);
	ManagerSound->SetFlux(Consol,FluxAction);
	ManagerModele->SetFlux(Consol,FluxAction);
	ManagerFont->SetFlux(Consol,FluxAction);
	ManagerSpecialEffect->SetFlux(Consol,FluxAction);
	ManagerVertexArrays->SetFlux(Consol,FluxAction);
	ManagerVertexProgram->SetFlux(Consol,FluxAction);
	ManagerObjectWindow->SetFlux(Consol,FluxAction);
	ManagerPVS->SetFlux(Consol,FluxAction);
	ManagerLoad->SetFlux(Consol,FluxAction);
	ManagerMesh->SetFlux(Consol,FluxAction);
	ManagerEntity->SetFlux(Consol,FluxAction);
	//----------------------------------------------------------------------------------
	//Set ManagerId All Object Manager need a link to ManagerId . Each object has his id 
	//----------------------------------------------------------------------------------
	ManagerCommand->SetManagerId	(ManagerId	);
	ManagerCamera->SetManagerId(ManagerId);
	ManagerTexture->SetManagerId	(ManagerId	);
	ManagerCollision->SetManagerId	(ManagerId	);
	ManagerInterface->SetManagerId	(ManagerId	);
	ManagerMap->SetManagerId	(ManagerId	);
	ManagerGizmo->SetManagerId	(ManagerId	);
	ManagerLight->SetManagerId	(ManagerId	);
	ManagerAnimation->SetManagerId	(ManagerId	);
	ManagerSpirit->SetManagerId	(ManagerId	);
	ManagerSound->SetManagerId	(ManagerId	);
	ManagerParticuleSystem->SetManagerId	(ManagerId	);
	ManagerFont->SetManagerId	(ManagerId	);
	ManagerObjectWindow->SetManagerId(ManagerId);
	ManagerModele->SetManagerId(ManagerId);
	ManagerMesh->SetManagerId(ManagerId);
	ManagerLoad->SetManagerId(ManagerId);
	ManagerEntity->SetManagerId(ManagerId);
	//-----------------------------------------------------------------
	ManagerCamera->SetManagerModel(ManagerModele);
	//------------------------------------------------------------------
	ManagerModele->SetManagerTexture(ManagerTexture);
	ManagerModele->SetManagerVertexArrays(ManagerVertexArrays);
	//------------------------------------------------------------------
	ManagerCollision->SetManagerModel(ManagerModele);
	//------------------------------------------------------------------
	ManagerInputGLUT->SetManagerCommand(ManagerCommand);
	//-----------------------------------------------------------------------
	//To route command the ManagerCommand need a link to this list of manager
	//-----------------------------------------------------------------------
	ManagerCommand->SetManagerAnim(ManagerAnimation);
	ManagerCommand->SetManagerCollision(ManagerCollision);
	ManagerCommand->SetManagerFog(ManagerFog);
	ManagerCommand->SetManagerGizmo(ManagerGizmo);
	ManagerCommand->SetManagerLight(ManagerLight);
	ManagerCommand->SetManagerMap(ManagerMap);
	ManagerCommand->SetManagerParticuleSystem(ManagerParticuleSystem);
	ManagerCommand->SetManagerTexture(ManagerTexture);
	ManagerCommand->SetManagerWindow(ManagerWindow);
	ManagerCommand->SetManagerCamera(ManagerCamera);
 	ManagerCommand->SetManagerGizmo(ManagerGizmo);
	ManagerCommand->SetManagerInterface(ManagerInterface);
	ManagerCommand->SetManagerConsole(ManagerConsole);
	ManagerCommand->SetManagerSound(ManagerSound);
	ManagerCommand->SetManagerSpirit(ManagerSpirit);
	ManagerCommand->SetManagerModel(ManagerModele);
	ManagerCommand->SetManagerNetwork(ManagerNetwork);
	ManagerCommand->SetManagerObjectWindow(ManagerObjectWindow);
	ManagerCommand->SetManagerSpecialEffect(ManagerSpecialEffect);
	ManagerCommand->SetManagerLoad(ManagerLoad);
	ManagerCommand->SetManagerPVS(ManagerPVS);
	ManagerCommand->SetManagerMesh(ManagerMesh);
	ManagerCommand->SetManagerEntity(ManagerEntity);
	//------------------------------------------------------------------
	ManagerMap->SetManagerTexture(ManagerTexture);
	ManagerMap->SetManagerFog(ManagerFog);
    //------------------------------------------------------------------
	ManagerParticuleSystem->SetManagerTexture(ManagerTexture);
	ManagerParticuleSystem->SetManagerCollision(ManagerCollision);
	//-------------------------------------------------
	//ManagerOutput need this link to render the scene
	//-------------------------------------------------
	ManagerOutPut->SetManagerWindow(ManagerWindow);
	ManagerOutPut->SetManagerCommand(ManagerCommand);
	ManagerOutPut->SetManagerCamera(ManagerCamera);
	ManagerOutPut->SetManagerAnim(ManagerAnimation);
	ManagerOutPut->SetManagerCollision(ManagerCollision);
	ManagerOutPut->SetManagerFog(ManagerFog);
	ManagerOutPut->SetManagerConsole(ManagerConsole);
	ManagerOutPut->SetManagerInterface(ManagerInterface);
	ManagerOutPut->SetManagerSpirit(ManagerSpirit);
	ManagerOutPut->SetManagerMap(ManagerMap);
	ManagerOutPut->SetManagerModel(ManagerModele);
	ManagerOutPut->SetManagerGizmo(ManagerGizmo);
	ManagerOutPut->SetManagerParticuleSystem(ManagerParticuleSystem);
	ManagerOutPut->SetManagerLight(ManagerLight);
	ManagerOutPut->SetManagerNetwork(ManagerNetwork);
	ManagerOutPut->SetManagerCollision(ManagerCollision);
	ManagerOutPut->SetManagerVertexProgram(ManagerVertexProgram);
	ManagerOutPut->SetManagerObjectWindow(ManagerObjectWindow);
	ManagerOutPut->SetManagerSpecialEffect(ManagerSpecialEffect);
	ManagerOutPut->SetManagerPVS(ManagerPVS);
	ManagerOutPut->SetManagerLoad(ManagerLoad);
	ManagerOutPut->SetManagerLight(ManagerLight);
	//-------------------------------------------------	
	ManagerInterface->SetManagerTexture(ManagerTexture);
	//-------------------------------------------------	
	ManagerConsole->SetManagerWindow(ManagerWindow);
	ManagerConsole->SetManagerTexture(ManagerTexture);
	//-------------------------------------------------	
	ManagerObjectWindow->SetManagerTexture(ManagerTexture);
	ManagerObjectWindow->SetManagerWindow(ManagerWindow);
	//-------------------------------------------------	
	ManagerAnimation->SetManagerCamera(ManagerCamera);
	ManagerAnimation->SetManagerGizmo(ManagerGizmo);
	ManagerAnimation->SetManagerLight(ManagerLight);
	ManagerAnimation->SetManagerModel(ManagerModele);
	ManagerAnimation->SetManagerParticuleSystem(ManagerParticuleSystem);
	ManagerAnimation->SetManagerEntity(ManagerEntity);
	//-------------------------------------------------	
	ManagerLoad->SetManagerCamera(ManagerCamera);
	ManagerLoad->SetManagerAnim(ManagerAnimation);
	ManagerLoad->SetManagerConsole(ManagerConsole);
	ManagerLoad->SetManagerInterface(ManagerInterface);
	ManagerLoad->SetManagerSpirit(ManagerSpirit);
	ManagerLoad->SetManagerMap(ManagerMap);
	ManagerLoad->SetManagerModel(ManagerModele);
	ManagerLoad->SetManagerGizmo(ManagerGizmo);
	ManagerLoad->SetManagerParticuleSystem(ManagerParticuleSystem);
	ManagerLoad->SetManagerLight(ManagerLight);
	ManagerLoad->SetManagerVertexProgram(ManagerVertexProgram);
	ManagerLoad->SetManagerObjectWindow(ManagerObjectWindow);
	ManagerLoad->SetManagerSpecialEffect(ManagerSpecialEffect);
	ManagerLoad->SetManagerMesh(ManagerMesh);
	ManagerLoad->SetManagerSound(ManagerSound);
	ManagerLoad->SetManagerTexture(ManagerTexture);
	ManagerLoad->SetManagerEntity(ManagerEntity);
	//-------------------------------------------------	
	ManagerPVS->SetManagerCamera(ManagerCamera);
	ManagerPVS->SetManagerMap(ManagerMap);
	ManagerPVS->SetManagerModel(ManagerModele);
	ManagerPVS->SetManagerGizmo(ManagerGizmo);
	ManagerPVS->SetManagerParticuleSystem(ManagerParticuleSystem);
	ManagerPVS->SetManagerLight(ManagerLight);
	ManagerPVS->SetManagerMesh(ManagerMesh);
	ManagerPVS->SetManagerEntity(ManagerEntity);
	//-------------------------------------------------	
	ManagerMesh->SetManagerTexture(ManagerTexture);
	ManagerMesh->SetManagerModel(ManagerModele);
	//-------------------------------------------------
	ManagerEntity->SetManagerGizmo(ManagerGizmo);
	ManagerEntity->SetManagerMesh(ManagerMesh);
	ManagerEntity->SetManagerModel(ManagerModele);//TO DO remove this one en use only mesh
UnGuard
}

void PreInitManager(void)
{
Guard(void PreInitManager(void))
	//-------------------------------------------------------------------------------
	//Try to init all manager. When a manager fail in his init he return a exception
	//-------------------------------------------------------------------------------
	try{
		ManagerInputGLUT->Init();
		ManagerInputGLUT->CheckInput();
		ManagerInputGLUT->DisplayAviableInput();
	}catch(...){std::cout<<"Unknow error in ManagerInputGLUT Init "<<std::endl;}
	try{ManagerId->Init();}
		catch(...){std::cout<<"Unknow error in ManagerId Init "<<std::endl;}
	try{ManagerVertexArrays->Init();}
		catch(...){std::cout<<"Unknow error in ManagerVertexArrays Init "<<std::endl;}
	try{ManagerVertexProgram->Init();}
		catch(...){std::cout<<"Unknow error in ManagerVertexProgram Init "<<std::endl;}
	try{ManagerTexture->Init();}
		catch (ExCExpMultitexturing) 
		{
			std::cout<<"GL_ARB_multitexture is missing unable to launch engine"<<std::endl;
		}
		catch(...){std::cout<<"Unknow error in ManagerTexture Init "<<std::endl;}
	try{
		ManagerSound->Init();
		ManagerSound->DisplayAviableInput();}
	catch(...){std::cout<<"Unknow error in ManagerSound Init "<<std::endl;}
		//---------------------
	try{ManagerInterface->Init();}
		catch(...){std::cout<<"Unknow error in ManagerInterface Init "<<std::endl;}
	try{ManagerSpirit->Init();}
		catch(...){std::cout<<"Unknow error in ManagerSpirit Init "<<std::endl;}
	try{ManagerMesh->Init();}
		catch(...){std::cout<<"Unknow error in ManagerMesh Init "<<std::endl;}
	try{ManagerFont->Init();}
		catch(...){std::cout<<"Unknow error in ManagerFont Init "<<std::endl;}
	try{ManagerMap->Init();}
		catch(...){std::cout<<"Unknow error in ManagerMap Init "<<std::endl;}
	try{ManagerCamera->Init();}
		catch(...){std::cout<<"Unknow error in ManagerCamera Init "<<std::endl;}
	try{ManagerGizmo->Init();}
		catch(...){std::cout<<"Unknow error in ManagerGizmo Init "<<std::endl;}
	try{ManagerParticuleSystem->Init();}
		catch(...){std::cout<<"Unknow error in ManagerParticuleSystem Init "<<std::endl;}
	try{ManagerLight->Init();}
		catch(...){std::cout<<"Unknow error in ManagerLight Init "<<std::endl;}
	//---------------------
	try{ManagerWindow->GlutCallBack=&SetGlutCallBack;
		if(m_FullScreen)ManagerWindow->Apply();}
		catch(...){std::cout<<"Unknow error in ManagerWindow Init "<<std::endl;}
	try{ManagerModele->Init();}
		catch(...){std::cout<<"Unknow error in ManagerModele Init "<<std::endl;}
	try{ManagerObjectWindow->Init();}
		catch(...){std::cout<<"Unknow error in ManagerObjectWindow Init "<<std::endl;}
	try{ManagerOutPut->Init();}
		catch(...){std::cout<<"Unknow error in ManagerOutPut Init "<<std::endl;}
	try{ManagerCommand->Init();}
		catch(...){std::cout<<"Unknow error in ManagerCommand Init "<<std::endl;}
	try{ManagerConsole->Init();}
		catch(...){std::cout<<"Unknow error in ManagerConsole Init "<<std::endl;}
	try{ManagerNetwork->Init();}
		catch(...){std::cout<<"Unknow error in ManagerNetwork Init "<<std::endl;}
	try{ManagerFog->Init();}
		catch(...){std::cout<<"Unknow error in ManagerFog Init "<<std::endl;}
	try{ManagerAnimation->Init();}
		catch(...){std::cout<<"Unknow error in ManagerAnimation Init "<<std::endl;}
	try{ManagerEntity->Init();}
		catch(...){std::cout<<"Unknow error in ManagerEntity Init "<<std::endl;}
	try{ManagerLoad->Init();}
		catch(...){std::cout<<"Unknow error in ManagerLoad Init "<<std::endl;}
	try{ManagerPVS->Init();}
		catch(...){std::cout<<"Unknow error in ManagerPVS Init "<<std::endl;}
UnGuard
}

void PostInitManager(void)
{
Guard(void PostInitManager(void))
	ManagerConsole->Init();
	ExNihilo::InitBasicObjectList();
	ManagerOutPut->Init();
	ManagerInterface->Reset();
	ManagerInterface->Init();
UnGuard
}

void SetGlutCallBack(void)
{
Guard(SetGlutCallBack(void))
	//------------------------------------------------
	//Adresse of Callbacks Keyboard
	//------------------------------------------------	
	if(ManagerInputGLUT->IsKeyboard())
	{	
		glutKeyboardFunc(keyboard);
		glutKeyboardUpFunc(keyboardup);
		glutSpecialFunc(spekeyboard);
		glutSpecialUpFunc(spekeyboardup);
	}else
	{
		glutKeyboardFunc(NULL);
		glutKeyboardUpFunc(NULL);
		glutSpecialFunc(NULL);
		glutSpecialUpFunc(NULL);
	}
	//------------------------------------------------
	//Adresse of Callbacks Mouse
	//------------------------------------------------	
	if(ManagerInputGLUT->IsMouse())
	{
		glutMouseFunc(Mouse);
		glutEntryFunc(Focus);
		glutMotionFunc(MotionFunc);
		glutPassiveMotionFunc(PassiveMotionFunc);
	}
	else
	{
		glutMouseFunc(NULL);
		glutEntryFunc(NULL);
		glutMotionFunc(NULL);
		glutPassiveMotionFunc(NULL);
	}
	//------------------------------------------------
	//Adresse of Callbacks Joystick
	//------------------------------------------------	
	if(ManagerInputGLUT->IsJoystick())
	{
	}
	else
	{
	}
	//------------------------------------------------
	//Adresse of Callbacks SpaceBall
	//------------------------------------------------	
	if(ManagerInputGLUT->IsSpaceBall())
	{
		glutSpaceballMotionFunc(SpaceballMotionFunc);
		glutSpaceballRotateFunc(SpaceballRotateFunc);
	}
	else
	{
		glutSpaceballRotateFunc(NULL);
		glutSpaceballMotionFunc(NULL);
	}
	//------------------------------------------------
	//Adresse of Callbacks Tablet
	//------------------------------------------------	
	if(ManagerInputGLUT->IsTablet())
	{
		glutTabletMotionFunc(TabletMotionFunc);
		glutTabletButtonFunc(TabletButtonFunc);
	}
	else
	{
		glutTabletMotionFunc(NULL);
		glutTabletButtonFunc(NULL);
	}
	//------------------------------------------------
	//Adresse of Callbacks render
	//------------------------------------------------	
	glutDisplayFunc(display);
	glutIdleFunc(display);	
	glutReshapeFunc(reshape);

UnGuard
}

void keyboard(unsigned char key,int x,int y){ManagerInputGLUT->Key(key,x,y);}
void keyboardup(unsigned char key, int x, int y){ManagerInputGLUT->KeyUp(key,x,y);}
void spekeyboard(int key,int x,int y){ManagerInputGLUT->KeySpe(key,x,y);}	
void spekeyboardup(int key, int x, int y){ManagerInputGLUT->KeySpeUp(key,x,y);}
void Mouse(int button, int state, int x, int y){ManagerInputGLUT->Mouse(button,state,x,y);}
void Focus(int state){ManagerInputGLUT->Focus(state);}
void MotionFunc(int x, int y){ManagerInputGLUT->MouseMotion(x,y);}
void PassiveMotionFunc(int x, int y){ManagerInputGLUT->MousePassiveMotion(x,y);}
void SpaceballMotionFunc(int x, int y, int z){ManagerInputGLUT->SpaceballMotion(x,y,z);} 
void SpaceballRotateFunc(int x, int y, int z){ManagerInputGLUT->SpaceballRotate(x,y,z);}
void TabletMotionFunc(int x, int y){ManagerInputGLUT->TabletMotion(x,y);} 
void TabletButtonFunc(int button, int state, int x, int y)	{ManagerInputGLUT->TabletButton(button,state,x,y);} 
void display(void){ManagerOutPut->DrawScene();}
void reshape(int w,int h){ManagerOutPut->Reshape(w,h);}



