/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :Main.h													*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description	:This is the main entry of the progamme				*/
/*						Initialize all manager 							*/
/*						Create link between manager						*/
/*						Set the call back function for glut				*/
/*						Lauch the engine								*/
/************************************************************************/

#ifndef __MAIN_H__
#define __MAIN_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "ExCAction.h"
//------------------------------------------------------------------------
#include "Flux/ExCFluxAction.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerWindow.h"
#include "Manager/ExManagerConsole.h"
#include "Manager/ExManagerOutput.h"
#include "Manager/ExManagerMap.h"
#include "Manager/ExManagerCommand.h"
#include "Manager/ExManagerCollision.h"
#include "Manager/ExManagerFog.h"
#include "Manager/ExManagerId.h"
#include "Manager/ExManagerInputGLUT.h"
#include "Manager/ExManagerNetwork.h"
#include "Manager/ExManagerSpecialEffect.h"
#include "Manager/ExManagerPVS.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerLoad.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ManagerObject/ExManagerInterface.h"
#include "Manager/ManagerObject/ExManagerParticuleSystem.h"
#include "Manager/ManagerObject/ExManagerGizmo.h"
#include "Manager/ManagerObject/ExManagerLight.h"
#include "Manager/ManagerObject/ExManagerAnimation.h"
#include "Manager/ManagerObject/ExManagerSound.h"
#include "Manager/ManagerObject/ExManagerSpirit.h"
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerModele.h"
#include "Manager/ManagerObject/ExManagerCamera.h"
#include "Manager/ManagerObject/ExManagerFont.h"
#include "Manager/ManagerObject/ExManagerVertexArrays.h"
#include "Manager/ManagerObject/ExManagerVertexProgram.h"
#include "Manager/ManagerObject/ExManagerObjectWindow.h"
#include "Manager/ManagerObject/ExManagerMesh.h"
#include "Manager/ManagerObject/ExManagerEntity.h"
//--------------------------------------------------------------------
//fonctions for glut call back
//--------------------------------------------------------------------
void display(void);								
void reshape(int w, int h) ;					
void keyboard(unsigned char key,int x,int y);	
void keyboardup(unsigned char key, int x, int y);
void spekeyboard(int key,int x,int y);			
void spekeyboardup(int key, int x, int y) ;
void Mouse(int button, int state, int x, int y);
void MotionFunc(int x, int y); 
void PassiveMotionFunc(int x, int y); 
void SpaceballMotionFunc(int x, int y, int z); 
void SpaceballRotateFunc(int x, int y, int z);
void TabletMotionFunc(int x, int y);
void TabletButtonFunc(int button, int state, int x, int y);
void Focus(int state);
void SetGlutCallBack(void);
void CreateManager(void);
void SetManagerLink(void);
void PreInitManager(void);
void PostInitManager(void);
void InitFlux(void);

//--------------------------------------------------------------------
// Variables
//--------------------------------------------------------------------
ExManagerWindow				*ManagerWindow;
ExManagerConsole			*ManagerConsole;
ExManagerOutput				*ManagerOutPut;
ExManagerTexture			*ManagerTexture;
ExManagerCollision			*ManagerCollision;
ExManagerInterface			*ManagerInterface;
ExManagerMap				*ManagerMap;
ExManagerCommand			*ManagerCommand;
ExManagerParticuleSystem	*ManagerParticuleSystem;
ExManagerGizmo				*ManagerGizmo;
ExManagerLight				*ManagerLight;
ExManagerFog				*ManagerFog;
ExManagerAnimation			*ManagerAnimation;
ExManagerInputGLUT			*ManagerInputGLUT;
ExManagerId					*ManagerId;
ExManagerSpirit				*ManagerSpirit;
ExManagerSound				*ManagerSound;
ExManagerModel				*ManagerModele;
ExManagerCamera				*ManagerCamera;
ExManagerNetwork			*ManagerNetwork;
ExManagerFont				*ManagerFont;
ExManagerSpecialEffect		*ManagerSpecialEffect;
ExManagerVertexArrays		*ManagerVertexArrays;
ExManagerVertexProgram		*ManagerVertexProgram;
ExManagerObjectWindow		*ManagerObjectWindow;
ExManagerMesh				*ManagerMesh;
ExManagerLoad				*ManagerLoad;
ExManagerPVS				*ManagerPVS;
ExManagerEntity				*ManagerEntity;
//--------------------------------------------------------------------
bool m_FullScreen;

ExCFluxAction				*FluxAction;
#endif//__MAIN_H__
