/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerCollision.cpp,v 1.5 2002/09/22 15:54:02 data Exp $
 *
 */

#include "ExManagerCollision.h"

bool ExManagerCollision::m_flag = false; 
ExManagerCollision* ExManagerCollision::m_instance = NULL; 

ExManagerCollision* ExManagerCollision::CreateSingleton(void){
Guard(ExManagerCollision* ExManagerCollision::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerCollision; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerCollision::ExManagerCollision(void)
{
}

ExManagerCollision::~ExManagerCollision(void)
{
}

void ExManagerCollision::Reset(void)
{
}

void ExManagerCollision::Reload(void)
{
}

void ExManagerCollision::ResolveCollision(void)
{
Guard(void ExManagerCollision::ResolveCollision(void))
	//i=0 comparer i avec i+1....i+nombre elem
	//i=1 ...
	//i=nombre elem quit
	ExCVec3D Nev,CurrentVec;
	ExCModel *CurrentModel,*ModelToCompare;
	float lowlestradius;
	bool Collision;
	for(unsigned int i=0;i<ManagerModel->GetNumberObject();i++)
	{
		CurrentModel=ManagerModel->GetCurrentObject();
		Collision=false;
		for(unsigned int j=i+1;j<ManagerModel->GetNumberObject();j++)
		{
			ManagerModel->NextObject();
			ModelToCompare=ManagerModel->GetCurrentObject();
			ModelToCompare->ResetCollisionCouter();
			ModelToCompare->GetCollisionGizmo()->SetColor(ExCVec3D(1.0f,1.0f,1.0f));
			//CHECK COLLISION TYPE BOX/BOX SPHERE/SPHERE SPHERE/BOX...
			//SPHERE/SPHERE
			if(strcmp(ModelToCompare->GetCollisionGizmo()->GetType().data(),"class ExCGizmoSphere *")==0
				&&strcmp(CurrentModel->GetCollisionGizmo()->GetType().data(),"class ExCGizmoSphere *")==0)//sphere with sphere
			{
			
				if(ModelToCompare->m_SphereRadius<CurrentModel->m_SphereRadius)
				{
					lowlestradius=ModelToCompare->m_SphereRadius;
				}else{
					lowlestradius=CurrentModel->m_SphereRadius;
				}
				Nev=ModelToCompare->GetPosition()-CurrentModel->GetPosition();
				if(Nev.GetX()<lowlestradius&&Nev.GetX()>-lowlestradius)
				{
					if(Nev.GetZ()<lowlestradius&&Nev.GetZ()>-lowlestradius)
					{
						std::cout<<CurrentModel->GetName()<<" Collision SPHERE/SPHERE with "<<ModelToCompare->GetName()<<std::endl;
						if(Nev.GetY()<lowlestradius&&Nev.GetY()>-lowlestradius)
						{
							ExCVec3D tmpvel,tmptrgt;
							tmpvel=CurrentModel->GetVelocity()+ModelToCompare->GetVelocity();
							tmptrgt=CurrentModel->GetTarget()+ModelToCompare->GetTarget();
											
							CurrentModel->SetVelocity(tmpvel/2);
							CurrentModel->SetTarget(tmptrgt/2);
							ModelToCompare->SetVelocity(tmpvel/2);
							ModelToCompare->SetTarget(tmptrgt/2);
							CurrentModel->GetCollisionGizmo()->SetColor(ExCVec3D(1.0f,0.0f,0.0f));
							ModelToCompare->GetCollisionGizmo()->SetColor(ExCVec3D(0.0f,1.0f,0.0f));
							Collision=true;
							CurrentModel->IncreaseCollisionCouter();
							ModelToCompare->IncreaseCollisionCouter();

						}
					}
				}
			}
			//SPHERE/RECTANGLE
			if(strcmp(ModelToCompare->GetCollisionGizmo()->GetType().data(),"class ExCGizmoSphere *")==0
				&&strcmp(CurrentModel->GetCollisionGizmo()->GetType().data(),"class ExCGizmoRectangle*")==0)//sphere with sphere
			{
			//	std::cout<<CurrentModel->GetName()<<" Collision SPHERE/RECTANGLE with "<<ModelToCompare->GetName()<<std::endl;
			}
			//RECTANGLE/SPHERE
			if(strcmp(ModelToCompare->GetCollisionGizmo()->GetType().data(),"class ExCGizmoRectangle *")==0
				&&strcmp(CurrentModel->GetCollisionGizmo()->GetType().data(),"class ExCGizmoSphere *")==0)//sphere with sphere
			{
			//	std::cout<<CurrentModel->GetName()<<" Collision RECTANGLE/SPHERE with "<<ModelToCompare->GetName()<<std::endl;
			}
			//RECTANGLE/RECTANGLE
			if(strcmp(ModelToCompare->GetCollisionGizmo()->GetType().data(),"class ExCGizmoRectangle *")==0
				&&strcmp(CurrentModel->GetCollisionGizmo()->GetType().data(),"class ExCGizmoRectangle *")==0)//sphere with sphere
			{
			//	std::cout<<CurrentModel->GetName()<<" Collision RECTANGLE/RECTANGLE with "<<ModelToCompare->GetName()<<std::endl;
			}
		}
		if(!Collision)
		{
			//CurrentModel->GetCollisionGizmo()->SetColor(ExCVec3D(1.0f,1.0f,1.0f));
		}
		ManagerModel->NextObject();
	}
UnGuard
}

void ExManagerCollision::Clear(void)
{

}