/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerCommand.cpp,v 1.51 2002/12/13 11:45:00 data Exp $
 *
 */

#include "ExManagerCommand.h"

bool ExManagerCommand::m_flag = false; 
ExManagerCommand* ExManagerCommand::m_instance = NULL; 

ExManagerCommand* ExManagerCommand::CreateSingleton(void){
Guard(ExManagerCommand* ExManagerCommand::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerCommand; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerCommand::ExManagerCommand(void)
{
	LogCommand = true;
	#ifdef UNIX_SRC
	logfilecommand.open("/tmp/logCommand.txt",std::ios::out);
	#else
	logfilecommand.open("logCommand.txt",std::ios::out);
	#endif
	plok=true;
}

ExManagerCommand::~ExManagerCommand(void)
{
}

bool ExManagerCommand::LoadCommandFile(std::string FileName)
{
Guard(bool ExManagerCommand::LoadCommandFile(std::string FileName))
	char buffer[255];
	
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Command/%s", FileName.data());
#else
	sprintf(buffer, "../Data/Command/%s",FileName.data());
#endif
    
/*	ExCFileReader my_file (buffer);
	if (! my_file.exist()) 
	{
		*Consol<<"File not found: "<<buffer<<std::endl;
		return false;
	} else 
	{
		*Consol<<"Loading Command File: "<<FileName<<std::endl;	
		ExCFileData _data = my_file.getContent();
		
		if (_data.getType() != FILE_COMMAND) 
		{
			*Consol<<FileName<<" is not a valide command file"<<std::endl;
			return false;
		} else 
		{
			vector<ExCFileDataAction> dd = _data.getContent();
			vector<ExCFileDataAction>::iterator i = dd.begin ();
			ExCFileDataAction f;
			while (i != dd.end ()) 
			{
				f = *i++;
				AddCommandAction (f);
			}
		}
		return true;
	}
	*/
	return false;
UnGuard
}


void ExManagerCommand::InputCommand(int command)
{
Guard(void ExManagerCommand::InputCommand(int command))
	std::cout<<"ManagerCommand::InputCommand : plokiiiiiii"<<std::endl;
UnGuard
}


ExCAction ExManagerCommand::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerCommand::InputCommand(ExCCommand Command))
	//std::cout<<"ManagerCommand::InputCommand :"<<Command.m_Command<<std::endl;
	if(ManagerConsole->AskForCommand())
	{
		AddAction(ManagerConsole->InputCommand(Command));
		if(ManagerConsole->AskForExclusifCommand())return NOTHING;
	}
	if(ManagerNetwork->AskForCommand())
	{
		AddAction(ManagerNetwork->InputCommand(Command));
		if(ManagerNetwork->AskForExclusifCommand())return NOTHING;
	}
	if(ManagerObjectWindow->AskForCommand())
	{
		AddAction(ManagerObjectWindow->InputCommand(Command));
		if(ManagerObjectWindow->AskForExclusifCommand())return NOTHING;
	}
	if(ManagerLoad->AskForCommand())
	{
		AddAction(ManagerLoad->InputCommand(Command));
	//	if(ManagerLoad->AskForExclusifCommand())return NOTHING;
	}
	/*
	if(ManagerInterface->AskForCommand())
	{
		AddAction(ManagerMenu->InputCommand(Command));
		if(ManagerMenu->AskForExclusifCommand())return NOTHING;
	}*/
	ProcessCommand(Command);
	return NOTHING;
UnGuard
}


void ExManagerCommand::ProcessCommand(ExCCommand command)
{
Guard(void ExManagerCommand::ProcessCommand(ExCCommand command))
	//std::cout<<"ManagerCommand::Process command :"<<command.m_Command<<std::endl;
	for(m_ItVecCommand=m_VecCommand.begin();m_ItVecCommand!=m_VecCommand.end();m_ItVecCommand++)
	{
		if(m_ItVecCommand->first.m_Command==command.m_Command)
		{
			AddAction(m_ItVecCommand->second);
		}
	}
UnGuard
}

void ExManagerCommand::AddAction(ExCAction action)
{
Guard(void ExManagerCommand::AddAction(ExCAction action))	
	//std::cout<<"ManagerCommand::Add Action"<<action.m_Action<<std::endl;
	if(action.m_Action!=NOTHING)
	{
		m_VecAction.push_back(action);
	}
UnGuard
}

void ExManagerCommand::AddNewAction(ExCAction action)
{
Guard(void ExManagerCommand::AddNewAction(ExCAction action))	
	//std::cout<<"ManagerCommand::ADD NEW ACTION:"<<action;
	if(action.m_Action!=NOTHING)
	{
		
		m_VecTempAction.push_back(action);
	}
UnGuard
}

void ExManagerCommand::RemoveRepAction(ExCAction action)
{
Guard(void ExManagerCommand::RemoveRepAction(ExCAction action))	
	int i=0;
	for(m_ItVecRepAction=m_VecRepAction.begin();m_ItVecRepAction!=m_VecRepAction.end();m_ItVecRepAction++,i++)
	{
		if(m_VecRepAction.at(i).m_Action==action.m_Action)
		{
			m_VecRepAction.erase(m_ItVecRepAction);	break;
		}
	}
UnGuard
}

void ExManagerCommand::AddRepAction(ExCAction action)
{
Guard(void ExManagerCommand::AddRepAction(ExCAction action))	
	bool already=false;
	int i=0;
	for(m_ItVecRepAction=m_VecRepAction.begin();m_ItVecRepAction!=m_VecRepAction.end();m_ItVecRepAction++,i++)
	{
		if(m_VecRepAction.at(i).m_Action==action.m_Action)
		{
			already=true;
		}
	}  
	if(!already)
	{  
		m_VecRepAction.push_back(action);
	}
UnGuard
}

void ExManagerCommand::ApplyAction(void)
{
Guard(void ExManagerCommand::ApplyAction(void))
//Read action on flux to apply;




	int i;
	std::vector<ExCAction>			TmpVecAction;
	for(m_ItVecAction=m_VecAction.begin();m_ItVecAction!=m_VecAction.end();m_ItVecAction++,i++)
	{
		//std::cout<<"ManagerCommand::Aplly Action :"<<m_VecAction.at(i)<<endl;
		if(!ProcesExCAction(*m_ItVecAction))
		{
			AddNewAction(*m_ItVecAction);
		}
	}
	
	//Remove executed action
	/*for(m_ItVecAction=m_VecAction.begin();m_ItVecAction!=m_VecAction.end();m_ItVecAction++)
	{
		
		if(!m_ItVecAction->AllActionDone())
		{
			TmpVecAction.push_back(*m_ItVecAction);
		}else
		{
			std::cout<<"action not done :"<<m_ItVecAction->m_Action<<std::endl;
		}
	}*/
	m_VecAction.clear();
	//m_VecAction=TmpVecAction;
	for(i=0; (unsigned)i<m_VecTempAction.size();i++)
	{
		AddAction(m_VecTempAction.at(i));
	}
	m_VecTempAction.clear();
	i=0;
	for(m_ItVecRepAction=m_VecRepAction.begin();m_ItVecRepAction!=m_VecRepAction.end();m_ItVecRepAction++,i++)
	{
		ProcesExCAction(m_VecRepAction.at(i));
	}
	while(FluxAction->GetSize()>0)
	{
		AddAction(FluxAction->Pop());
	}	
UnGuard
}

/*void ExManagerCommand::AddCommandAction (ExCFileDataAction e)
{
Guard(void ExManagerCommand::AddCommandAction(ExCFileDataAction e))
	CommandAction ComAct;
	ComAct.first = atoi (e.getAction ().data());
	ComAct.second.m_Action = e.getCommand ();
	ComAc t.second.m_Param  = e.getParam ();
	m_VecCommand.push_back (ComAct);
UnGuard
}*/

void ExManagerCommand::AddCommandAction(int command,ExCAction action)
{
Guard(void ExManagerCommand::AddCommandAction(int command,ExCAction action))
	CommandAction ComAct;	
	ComAct.first=command;
	ComAct.second=action;
	/*
	ComAct.second.m_Action=action.m_Action;
	ComAct.second.m_Param= action.m_Param;*/
	m_VecCommand.push_back(ComAct);
UnGuard
}

void ExManagerCommand::AddCommandAction(CommandAction ComAct)
{
Guard(void ExManagerCommand::AddCommandAction(CommandAction ComAct))
	m_VecCommand.push_back(ComAct);
UnGuard
}

void ExManagerCommand::AddCommandAction(int command,int action,std::string param)
{
Guard(void ExManagerCommand::AddCommandAction(int command,int action,std::string param))
	CommandAction ComAct;
	ComAct.first=command;
	ComAct.second.m_Action=action;
	ComAct.second.m_Param= param;
	m_VecCommand.push_back(ComAct);	
UnGuard
}

void ExManagerCommand::Init(void)
{
Guard(void ExManagerCommand::Init(void))
	AddCommandAction(KEYBOARD_DOWN_EXP,		ExCAction(CONSOL_NEXT_AVIABLE_STATE));
	AddCommandAction(MOUSE_RIGHT_BUTTON_DOWN,		ExCAction(TOGGLE_WINDOW));
	AddCommandAction(KEYBOARD_UP_PAGE_UP,	ExCAction(CONSOL_LINE_UP));
	AddCommandAction(KEYBOARD_UP_PAGE_DOWN,	ExCAction(CONSOL_LINE_DOWN));


	AddCommandAction(KEYBOARD_DOWN_4,		ExCAction(CAMERA_CURRENT_START_ROTATEY_DOWN));
	AddCommandAction(KEYBOARD_UP_4,			ExCAction(CAMERA_CURRENT_STOP_ROTATEY_DOWN));
	AddCommandAction(KEYBOARD_UP_5,			ExCAction(CAMERA_CURRENT_INCREASE_SPEED));
	AddCommandAction(KEYBOARD_UP_0,			ExCAction(CAMERA_CURRENT_DECREASE_SPEED));
	AddCommandAction(KEYBOARD_UP_S,			ExCAction(CAMERA_CURRENT_FULL_STOP));
	AddCommandAction(KEYBOARD_DOWN_6,		ExCAction(CAMERA_CURRENT_START_ROTATEY_UP));
	AddCommandAction(KEYBOARD_UP_6,			ExCAction(CAMERA_CURRENT_STOP_ROTATEY_UP));
	AddCommandAction(KEYBOARD_DOWN_2,		ExCAction(CAMERA_CURRENT_START_ROTATEX_UP));
	AddCommandAction(KEYBOARD_UP_2,			ExCAction(CAMERA_CURRENT_STOP_ROTATEX_UP));
	AddCommandAction(KEYBOARD_DOWN_8,		ExCAction(CAMERA_CURRENT_START_ROTATEX_DOWN));
	AddCommandAction(KEYBOARD_UP_8,			ExCAction(CAMERA_CURRENT_STOP_ROTATEX_DOWN));
	AddCommandAction(KEYBOARD_DOWN_1,		ExCAction(CAMERA_CURRENT_START_ROTATEZ_UP));
	AddCommandAction(KEYBOARD_UP_1,			ExCAction(CAMERA_CURRENT_STOP_ROTATEZ_UP));
	AddCommandAction(KEYBOARD_DOWN_3,		ExCAction(CAMERA_CURRENT_START_ROTATEZ_DOWN));
	AddCommandAction(KEYBOARD_UP_3,			ExCAction(CAMERA_CURRENT_STOP_ROTATEZ_DOWN));
	AddCommandAction(KEYBOARD_UP_A,			ExCAction(CAMERA_CURRENT_STOP_INCREASE_ZOOM));
	AddCommandAction(KEYBOARD_UP_Q,			ExCAction(CAMERA_CURRENT_STOP_DECREASE_ZOOM));

	//AddCommandAction(KEYBOARD_UP_ESC,			ExCAction(QUIT));

	AddCommandAction(KEYBOARD_DOWN_A,		ExCAction(CAMERA_CURRENT_START_INCREASE_ZOOM));
	AddCommandAction(KEYBOARD_DOWN_Q,		ExCAction(CAMERA_CURRENT_START_DECREASE_ZOOM));
	AddCommandAction(KEYBOARD_UP_9,			ExCAction(CAMERA_NEXT_CAM));
	AddCommandAction(KEYBOARD_UP_7,			ExCAction(CAMERA_PREV_CAM));
	AddCommandAction(KEYBOARD_UP_F1,		ExCAction(STAR_ALL_PARTICULESYSTEME));
	AddCommandAction(KEYBOARD_UP_F2,		ExCAction(PAUSE_ALL_PARTICULESYSTEME));


	AddCommandAction(KEYBOARD_UP_G,			ExCAction(SWITCH_GRIDE));
	
	//AddCommandAction(KEYBOARD_DOWN_T,		ExCAction(SAY));

	AddCommandAction(KEYBOARD_DOWN_SPACE,		ExCAction(MODEL_START_MOVE_FORWARD));
	AddCommandAction(KEYBOARD_UP_SPACE,			ExCAction(MODEL_STOP_MOVE_FORWARD));
	
	AddCommandAction(KEYBOARD_DOWN_ARROW_RIGHT,		ExCAction(MODEL_START_ROTATE_Y_DOWN));
	AddCommandAction(KEYBOARD_UP_ARROW_RIGHT,			ExCAction(MODEL_STOP_ROTATE_Y_DOWN));
	AddCommandAction(KEYBOARD_DOWN_ARROW_LEFT,		ExCAction(MODEL_START_ROTATE_Y_UP));
	AddCommandAction(KEYBOARD_UP_ARROW_LEFT,			ExCAction(MODEL_STOP_ROTATE_Y_UP));
	//AddCommandAction(KEYBOARD_DOWN_ARROW_UP,		ExCAction(MODEL_JUMP));
	

/*	AddCommandAction(KEYBOARD_DOWN_X,		ExCAction(MODEL_START_STRAFE_LEFT));
	AddCommandAction(KEYBOARD_UP_X,			ExCAction(MODEL_STOP_STRAFE_LEFT));
	AddCommandAction(KEYBOARD_DOWN_W,		ExCAction(MODEL_START_STRAFE_RIGHT));
	AddCommandAction(KEYBOARD_UP_W,			ExCAction(MODEL_STOP_STREFA_RIGHT));
*/	
	AddCommandAction(KEYBOARD_DOWN_ARROW_UP,		ExCAction(MODEL_START_ROTATE_Z_DOWN));
	AddCommandAction(KEYBOARD_UP_ARROW_UP,			ExCAction(MODEL_STOP_ROTATE_Z_DOWN));
	AddCommandAction(KEYBOARD_DOWN_ARROW_DOWN,		ExCAction(MODEL_START_ROTATE_Z_UP));
	AddCommandAction(KEYBOARD_UP_ARROW_DOWN,			ExCAction(MODEL_STOP_ROTATE_Z_UP));
/*
	AddCommandAction(KEYBOARD_DOWN_U,		ExCAction(MODEL_START_ROTATE_X_DOWN));
	AddCommandAction(KEYBOARD_UP_U,			ExCAction(MODEL_STOP_ROTATE_X_DOWN));
	AddCommandAction(KEYBOARD_DOWN_J,		ExCAction(MODEL_START_ROTATE_X_UP));
	AddCommandAction(KEYBOARD_UP_J,			ExCAction(MODEL_STOP_ROTATE_X_UP));	 
*/	
//	AddCommandAction(KEYBOARD_DOWN_V,		ExCAction(START_ACTION," RUN"));
//	AddCommandAction(KEYBOARD_DOWN_B,		ExCAction(START_ACTION," JUMP"));
	AddCommandAction(KEYBOARD_DOWN_N,		ExCAction(STOP_ACTION));

	AddCommandAction(KEYBOARD_DOWN_O,		ExCAction(CAMERA_CURRENT_START_INCREASE_AROUND));
	AddCommandAction(KEYBOARD_UP_O,			ExCAction(CAMERA_CURRENT_STOP_INCREASE_AROUND));
	AddCommandAction(KEYBOARD_DOWN_P,		ExCAction(CAMERA_CURRENT_START_DECREASE_AROUND));
	AddCommandAction(KEYBOARD_UP_P,			ExCAction(CAMERA_CURRENT_STOP_DECREASE_AROUND));	

	AddCommandAction(KEYBOARD_DOWN_L,		ExCAction(CAMERA_CURRENT_START_INCREASE_DISTANCE));
	AddCommandAction(KEYBOARD_UP_L,			ExCAction(CAMERA_CURRENT_STOP_INCREASE_DISTANCE));
	AddCommandAction(KEYBOARD_DOWN_M,		ExCAction(CAMERA_CURRENT_START_DECREASE_DISTANCE));
	AddCommandAction(KEYBOARD_UP_M,			ExCAction(CAMERA_CURRENT_STOP_DECREASE_DISTANCE));	

	AddCommandAction(KEYBOARD_DOWN_I,		ExCAction(CAMERA_CURRENT_START_INCREASE_HEIGHT));
	AddCommandAction(KEYBOARD_UP_I,			ExCAction(CAMERA_CURRENT_STOP_INCREASE_HEIGHT));
	AddCommandAction(KEYBOARD_DOWN_K,		ExCAction(CAMERA_CURRENT_START_DECREASE_HEIGHT));
	AddCommandAction(KEYBOARD_UP_K,			ExCAction(CAMERA_CURRENT_STOP_DECREASE_HEIGHT));

	//AddCommandAction(KEYBOARD_DOWN_F3,		ExCAction(MODEL_NEXT_MODEL));
	//AddCommandAction(KEYBOARD_DOWN_F4,		ExCAction(MODEL_PREV_MODEL));
	//AddCommandAction(KEYBOARD_DOWN_F5,		ExCAction(MODEL_STOP_ALL));
	//AddCommandAction(KEYBOARD_DOWN_F6,		ExCAction(MODEL_SHOW_COLLISION_SPHERE));
	
	//AddCommandAction(KEYBOARD_UP_F6,		ExCAction(HEIGHTMAP_INCREASE_TEXTURE_2_REPETITION));
	AddCommandAction(KEYBOARD_UP_F7,		ExCAction(HEIGHTMAP_DECREASE_TEXTURE_2_REPETITION));
	AddCommandAction(KEYBOARD_UP_F8,		ExCAction(HEIGHTMAP_INCREASE_FOG_DEPHT_LEVEL));
	AddCommandAction(KEYBOARD_UP_F9,		ExCAction(HEIGHTMAP_DECREASE_FOG_DEPHT_LEVEL));
	AddCommandAction(KEYBOARD_UP_F10,		ExCAction(HEIGHTMAP_SWITCH_FOG));
	AddCommandAction(KEYBOARD_UP_F11,		ExCAction(HEIGHTMAP_INCREASE_DETAIL_LEVEL));
	AddCommandAction(KEYBOARD_UP_F12,		ExCAction(HEIGHTMAP_DECREASE_DETAIL_LEVEL));
	
	AddCommandAction(KEYBOARD_UP_E,		ExCAction(SAVE_TEXTURE," screen.tga"));

	AddCommandAction(KEYBOARD_DOWN_W,		ExCAction(START_FADE_TO_WHITE));
	AddCommandAction(KEYBOARD_DOWN_X,		ExCAction(START_WITHE_TO_FADE));
	AddCommandAction(KEYBOARD_DOWN_C,		ExCAction(START_FADE_TO_BLACK));
	AddCommandAction(KEYBOARD_DOWN_V,		ExCAction(START_BLACK_TO_FADE));
	AddCommandAction(KEYBOARD_DOWN_B,		ExCAction(START_MOTION_BLUR));
	AddCommandAction(KEYBOARD_DOWN_N,		ExCAction(STOP_MOTION_BLUR));
	AddCommandAction(KEYBOARD_DOWN_T,		ExCAction(MANAGER_ANIMATION_TOGGLE_PAUSE_ALL_ANIMATION));
UnGuard
}


void ExManagerCommand::LoadExecFile(std::string FileName)
{
Guard(void ExManagerCommand::LoadExecFile(std::string FileName))
	std::cout<<"Loading Programme :"<<FileName<<std::endl;
	ExCAction			NewActionA;
	char			buffer[255];
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Program/%s", FileName.data());
#else
	sprintf(buffer, "../Data/Program/%s", FileName.data());
#endif
	std::ifstream fin;
	std::string buffstring;
	char b[256];
	fin.open(buffer,std::ios::in);
	if(fin.is_open())
	{
		try
		{
			do
			{
				memset(b,0,255);
				fin.getline(b,256,'\n');
				try
				{
					buffstring=ExNihilo::ExtracValueFromSring(b,"<Exec_Action>","<#Exec_Action>");
					NewActionA.m_Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
					NewActionA.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
					NewActionA.m_Param1=ExNihilo::ExtracValueFromSring(buffstring,"<Param1>","<#Param1>");
					NewActionA.m_Param2=ExNihilo::ExtracValueFromSring(buffstring,"<Param2>","<#Param2>");
					NewActionA.m_ExecutingLife=ExNihilo::ExtractIntValueFromSring(buffstring,"<Timer>","<#Timer>");
					NewActionA.m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
					//std::cout<<"READNEW ACTION:"<<NewActionA<<std::endl;;
					//AddNewAction(NewActionA);
					FluxAction->Push(NewActionA);
				}catch(ExCExpStringNotFound){}
			}while(!fin.eof());
			fin.close();
		}catch(...)
		{
			std::cout<<"ExCExpFileReadError"<<std::endl; 
			throw ExCExpFileReadError();
		}
	}else
	{
		std::cout<<"ExCExpFileNotFound:"<<buffer<<std::endl; 
		throw   ExCExpFileNotFound();
	}
	//std::cout<<"FIN"<<std::endl;;
UnGuard
}


bool ExManagerCommand::LoadFile(std::string FileName)
{
	ExCAction action;
	action.SetParam(FileName);
	action.m_Action=30038;
    AddNewAction(action);
	return true;
}
//-----------------------------------------------------------
// ici taper ce que fait l action
//-----------------------------------------------------------
bool ExManagerCommand::ProcesExCAction(ExCAction action)
{
Guard(bool ExManagerCommand::ProcesExCAction(ExCAction action))
	if(action.m_executed==false)//check if action already executed
	{
	
		std::string Param;
		Param=action.m_Param;
		Param.erase(Param.begin(),Param.begin()+1);
		
		ExCAction NAction(action);
		//NAction.m_Action=action.m_Action;
		NAction.m_Param=Param;

		//check if is time to execute action
		double ctime;
		ctime=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
		//std::cout<<"ManagerCommand::"<<action<<std::endl;
		if(action.m_ExecutingLife<0||(double)ctime-action.m_ExecutingLife>=(action.m_StartingLife))
		{
			if(LogCommand)
			{
				logfilecommand<<"Process Action :"<<action.m_Action<<" Param :"<<action.m_Param<<std::endl;
			}
			//*Consol<<action;
			//std::cout<<"ManagerCommand::Process Action :"<<action.m_Action<<" Param :"<<action.m_Param<<std::endl;
			//time to execute action
			//-------------------------------------------------
			//BASIC ACTION
			//-------------------------------------------------
			if(action.m_Action>=START_BASIC_ACTION_MAP && action.m_Action<END_BASIC_ACTION_MAP) 
			{
				switch(action.m_Action)
				{
				case NOTHING:
					break;
				case QUIT:
					exit(0);
					break;
				case RESET:
					ManagerId->Reset();
					ManagerCollision->Reset();
					ManagerAnim->Reset();
					ManagerMap->Reset();	
					ManagerFog->Reset();
					ManagerModel->Reset();
					ManagerGizmo->Reset();
					ManagerLight->Reset();
					ManagerCamera->Reset();
					ManagerParticuleSystem->Reset();
					ManagerTexture->Reset();
					ManagerInterface->Reset();
					ManagerConsole->Reset();
					ManagerSpirit->Reset();
					ManagerSound->Reset();
					ManagerObjectWindow->Reset();
					ManagerMesh->Reset();
					ManagerLoad->Reset();
					ManagerConsole->ClearConsol();
					ManagerEntity->Reset();
					
					*Consol<<"Engine reseted"<<std::endl;
					break;
				case RELOAD:
					Reload();
					ManagerAnim->Reload();
					ManagerCollision->Reload();
					ManagerGizmo->Reload();
					ManagerInterface->Reload();
					ManagerLight->Reload();
					ManagerMesh->Reload();
					ManagerModel->Reload();
					ManagerObjectWindow->Reload();
					ManagerParticuleSystem->Reload();
					ManagerSound->Reload();
					ManagerSpirit->Reload();
					ManagerTexture->Reload();
					ManagerConsole->Reload();
					ManagerMap->Reload();
					ManagerPVS->Reload();
					ManagerSpecialEffect->Reload();
					
				default:
					*Consol<<"Can not file action in BASIC_ACTION_MAP Action:"<<action.m_Action<<" Param:"<<Param<<std::endl;
					break;
				}

			}
			//-------------------------------------------------
			//CONSOLE ACTION
			//-------------------------------------------------
			if(action.m_Action>START_CONSOL_ACTION_MAP && action.m_Action<END_CONSOL_ACTION_MAP) 
			{
				AddNewAction(ManagerConsole->InputAction(NAction));
			}
			//-------------------------------------------------
			//CAMERA ACTION
			//-------------------------------------------------
			if(action.m_Action>START_CAMERA_ACTION_MAP && action.m_Action<END_CAMERA_ACTION_MAP) 
			{
				AddNewAction(ManagerCamera->InputAction(NAction));
			}
			//-------------------------------------------------
			//CONSOL ACTION
			//-------------------------------------------------
			if(action.m_Action>START_CONSOL_ACTION_MAP && action.m_Action<END_CONSOL_ACTION_MAP) 
			{
				AddNewAction(ManagerConsole->InputAction(NAction));
			}
			//-------------------------------------------------
			//FOG ACTION
			//-------------------------------------------------
			if(action.m_Action>START_FOG_ACTION_MAP && action.m_Action<END_FOG_ACTION_MAP) 
			{
				AddNewAction(ManagerFog->InputAction(NAction));
			}
			//-------------------------------------------------
			//INTERFACE ACTION
			//-------------------------------------------------
			if(action.m_Action>START_INTERFACE_ACTION_MAP && action.m_Action<END_INTERFACE_ACTION_MAP) 
			{
				AddNewAction(ManagerInterface->InputAction(NAction));
			}
			//-------------------------------------------------
			//SOUND ACTION
			//-------------------------------------------------
			if(action.m_Action>START_SOUND_ACTION_MAP && action.m_Action<END_SOUND_ACTION_MAP) 
			{
				AddNewAction(ManagerSound->InputAction(NAction));
			}
			//-------------------------------------------------
			//MAP ACTION
			//-------------------------------------------------
			if(action.m_Action>START_MAP_ACTION_MAP && action.m_Action<END_MAP_ACTION_MAP) 
			{
				AddNewAction(ManagerMap->InputAction(NAction));
			}
			//-------------------------------------------------
			//PARTICULESYSTEME ACTION
			//-------------------------------------------------
			if(action.m_Action>START_PARTICULESYSTEME_ACTION_MAP && action.m_Action<END_PARTICULESYSTEME_ACTION_MAP) 
			{
				AddNewAction(ManagerParticuleSystem->InputAction(NAction));
			}
			//-------------------------------------------------
			//MODEL ACTION
			//-------------------------------------------------
			if(action.m_Action>START_MODEL_ACTION_MAP && action.m_Action<END_MODEL_ACTION_MAP) 
			{
				AddNewAction(ManagerModel->InputAction(NAction));
			}
			//-------------------------------------------------
			//NETWORK ACTION
			//-------------------------------------------------
			if(action.m_Action>START_NETWORK_ACTION_MAP && action.m_Action<END_NETWORK_ACTION_MAP) 
			{
				AddNewAction(ManagerNetwork->InputAction(NAction));
			}
			//-------------------------------------------------
			//ID ACTION
			//-------------------------------------------------
			if(action.m_Action>START_ID_ACTION_MAP && action.m_Action<END_ID_ACTION_MAP) 
			{
				AddNewAction(ManagerId->InputAction(NAction));
			}
			//-------------------------------------------------
			//MAIN WINDOW ACTION
			//-------------------------------------------------
			if(action.m_Action>START_WINDOW_ACTION_MAP && action.m_Action<END_WINDOW_ACTION_MAP) 
			{
				AddNewAction(ManagerWindow->InputAction(NAction));
			}
			//-------------------------------------------------
			//OBJECT WINDOW ACTION
			//-------------------------------------------------
			if(action.m_Action>START_OBJECT_WINDOW_ACTION_MAP && action.m_Action<END_OBJECT_WINDOW_ACTION_MAP) 
			{
				AddNewAction(ManagerObjectWindow->InputAction(NAction));
			}
			//-------------------------------------------------
			//TEXTURE ACTION
			//-------------------------------------------------
			if(action.m_Action>START_TEXTURE_ACTION_MAP && action.m_Action<END_TEXTURE_ACTION_MAP) 
			{
				AddNewAction(ManagerTexture->InputAction(NAction));
			}
			//-------------------------------------------------
			//SPECIALEFFECT ACTION
			//-------------------------------------------------
			if(action.m_Action>START_SPECIALEFFECT_ACTION_MAP && action.m_Action<END_SPECIALEFFECT_ACTION_MAP) 
			{
				AddNewAction(ManagerSpecialEffect->InputAction(NAction));
			}
			//-------------------------------------------------
			//MESH ACTION
			//-------------------------------------------------
			if(action.m_Action>START_MESH_ACTION_MAP && action.m_Action<END_MESH_ACTION_MAP) 
			{
				AddNewAction(ManagerMesh->InputAction(NAction));
			}
			//-------------------------------------------------
			//LOAD ACTION
			//-------------------------------------------------
			if(action.m_Action>START_LOAD_ACTION_MAP && action.m_Action<END_LOAD_ACTION_MAP) 
			{
				AddNewAction(ManagerLoad->InputAction(NAction));
			}
			//-------------------------------------------------
			//PVS ACTION
			//-------------------------------------------------
			if(action.m_Action>START_PVS_ACTION_MAP && action.m_Action<END_PVS_ACTION_MAP) 
			{
				AddNewAction(ManagerPVS->InputAction(NAction));
			}
			//-------------------------------------------------
			//ENTITY ACTION
			//-------------------------------------------------
			if(action.m_Action>START_ENTITY_ACTION_MAP && action.m_Action<END_ENTITY_ACTION_MAP) 
			{
				AddNewAction(ManagerEntity->InputAction(NAction));
			}
			//-------------------------------------------------
			//ANIMATION ACTION
			//-------------------------------------------------
			if(action.m_Action>START_ANIMATION_ACTION_MAP && action.m_Action<END_ANIMATION_ACTION_MAP) 
			{
				AddNewAction(ManagerAnim->InputAction(NAction));
			}
			//-------------------------------------------------
			//COMMAND ACTION
			//-------------------------------------------------
			if(action.m_Action>START_COMMAND_ACTION_MAP && action.m_Action<END_COMMAND_ACTION_MAP) 
			{
				AddNewAction(InputAction(NAction));
			}
		}else	AddNewAction(action);
	}
    //action.m_executed=false;
	//to call all acton in the stack
	if(action.m_NextAction!=NULL)
	{
		ProcesExCAction(*action.m_NextAction);
	}
	if(action.m_ActionNumber==0)//this is the first action of the stack
	{
		if(action.AllActionDone())//all action in the stack was done
		{
			return true;
		}
	}
	return false;
UnGuard
}




ExCAction ExManagerCommand::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerCommand::InputAction(ExCAction Action))
	//std::cout<<"ExManagerCommand::InputAction::"<<Action<<std::endl;
	switch(Action.m_Action)
	{		
	case LOAD_EXEC_CONFIG_FILE:
		LoadExecFile(Action.m_Param.data());
		break;

	default:
		*Consol<<"Can not file action in COMMAND_ACTION_MAP Action:"<<Action.m_Action<<" Param:"<<Action.m_Param<<std::endl;
		break;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

