/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :InputActionList.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERCOMMAND_H__
#define __EXMANAGERCOMMAND_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExCCommand.h"
#include "ExCAction.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerWindow.h"
#include "Manager/ExManagerConsole.h"
#include "Manager/ExManagerMap.h"
#include "Manager/ExManagerCommand.h"
#include "Manager/ExManagerCollision.h"
#include "Manager/ExManagerFog.h"
#include "Manager/ExManagerId.h"
#include "Manager/ExManagerNetwork.h"
#include "Manager/ExManagerSpecialEffect.h"
#include "Manager/ExManagerPVS.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerLoad.h"
#include "Manager/ManagerObject/ExManagerMesh.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ManagerObject/ExManagerInterface.h"
#include "Manager/ManagerObject/ExManagerParticuleSystem.h"
#include "Manager/ManagerObject/ExManagerGizmo.h"
#include "Manager/ManagerObject/ExManagerLight.h"
#include "Manager/ManagerObject/ExManagerAnimation.h"
#include "Manager/ManagerObject/ExManagerSound.h"
#include "Manager/ManagerObject/ExManagerSpirit.h"
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerModele.h"
#include "Manager/ManagerObject/ExManagerCamera.h"
#include "Manager/ManagerObject/ExManagerFont.h"
#include "Manager/ManagerObject/ExManagerVertexArrays.h"
#include "Manager/ManagerObject/ExManagerVertexProgram.h"
#include "Manager/ManagerObject/ExManagerObjectWindow.h"
#include "Manager/ManagerObject/ExManagerEntity.h"
//------------------------------------------------------------------------
class ExManagerCommand : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerMap				*ManagerMap;	
	ExManagerFog				*ManagerFog;
	ExManagerAnimation			*ManagerAnim;
	ExManagerWindow				*ManagerWindow;
	ExManagerGizmo				*ManagerGizmo;
	ExManagerLight				*ManagerLight;
	ExManagerParticuleSystem	*ManagerParticuleSystem;
	ExManagerTexture			*ManagerTexture;
	ExManagerCollision			*ManagerCollision;
	ExManagerId					*ManagerId	;
	ExManagerInterface			*ManagerInterface;
	ExManagerConsole			*ManagerConsole;
	ExManagerSpirit				*ManagerSpirit;
	ExManagerSound				*ManagerSound;
	ExManagerCamera				*ManagerCamera;
	ExManagerModel				*ManagerModel;
	ExManagerNetwork			*ManagerNetwork;
	ExManagerObjectWindow		*ManagerObjectWindow;
	ExManagerSpecialEffect		*ManagerSpecialEffect;
	ExManagerLoad				*ManagerLoad;
	ExManagerPVS				*ManagerPVS;
	ExManagerMesh				*ManagerMesh;
	ExManagerEntity				*ManagerEntity;

	int		m_MousePosX;
	int		m_MousePosY;	

	typedef std::pair<ExCCommand,ExCAction> CommandAction;
	std::vector<CommandAction>				m_VecCommand;
	std::vector<CommandAction>::iterator	m_ItVecCommand;

	std::vector<ExCAction>			m_VecAction;
	std::vector<ExCAction>::iterator	m_ItVecAction;
	std::vector<ExCAction>			m_VecTempAction;//action added when action run

	std::vector<ExCAction>			m_VecRepAction;
	std::vector<ExCAction>::iterator	m_ItVecRepAction;

	void RemoveRepAction(ExCAction action);
	void AddRepAction(ExCAction action);
	void AddAction(ExCAction action);
	//void AddCommandAction (ExCFileDataAction);
	void AddCommandAction(int command,ExCAction action);
	void AddCommandAction(int command,int action,std::string param);
	void AddCommandAction(CommandAction ComAct); 
	void ProcessCommand(ExCCommand command);
	bool ProcesExCAction(ExCAction action);

	bool LogCommand;
	std::ofstream logfilecommand;
	bool plok;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerCommand *m_instance;
	ExManagerCommand(void);
	~ExManagerCommand(void);
public:
	static ExManagerCommand*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void AddNewAction(ExCAction action);
	void Reset(void){return;}

	inline void SetManagerLoad(ExManagerLoad *Load){ManagerLoad = Load;}
	inline void SetManagerPVS(ExManagerPVS *PVS){ManagerPVS = PVS;}
	inline void SetManagerMesh(ExManagerMesh *Mesh){ManagerMesh = Mesh;}
	inline void SetManagerMap(ExManagerMap *Map){ManagerMap = Map;}
	inline void SetManagerFog(ExManagerFog *Fog){ManagerFog = Fog;}
	inline void SetManagerAnim(ExManagerAnimation *Anim){ManagerAnim = Anim;}
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerGizmo(ExManagerGizmo *Gizmo){ManagerGizmo = Gizmo;}
	inline void SetManagerLight(ExManagerLight *Light){ManagerLight = Light;}
	inline void SetManagerParticuleSystem(ExManagerParticuleSystem *ParticuleSystem){ManagerParticuleSystem = ParticuleSystem;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
	inline void SetManagerInterface(ExManagerInterface * Interface){ManagerInterface=Interface;}
	inline void SetManagerConsole(ExManagerConsole * Console){ManagerConsole=Console;}
	inline void SetManagerSound(ExManagerSound * Sound){ManagerSound=Sound;}
	inline void SetManagerSpirit(ExManagerSpirit * Spirit){ManagerSpirit=Spirit;}

	inline void SetManagerCamera(ExManagerCamera *Cam){ManagerCamera = Cam;}
	inline void SetManagerModel(ExManagerModel *Model){ManagerModel = Model;}
	inline void SetManagerNetwork(ExManagerNetwork *Network){ManagerNetwork = Network;}
	inline void SetManagerObjectWindow(ExManagerObjectWindow *ObjectWindow){ManagerObjectWindow = ObjectWindow;}
	inline void SetManagerSpecialEffect(ExManagerSpecialEffect *SpecialEffect){ManagerSpecialEffect = SpecialEffect;}
	inline void SetManagerEntity(ExManagerEntity *Entity){ManagerEntity = Entity;}

	void Init(void);
	bool LoadCommandFile(std::string FileName);
	//bool LoadExecFile(ExCAction *action);
	bool LoadFile(std::string FileName);

	void InputCommand(int command);
	ExCAction InputCommand(ExCCommand Command);
	void ApplyAction(void);

	inline void SetMousePosition(int posx,int posy){m_MousePosX=posx;m_MousePosY=posy;}
	

	void LoadExecFile(std::string FileName);


	ExCAction InputAction(ExCAction Action);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERCOMMAND_H__
