/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerConsole.cpp,v 1.43 2002/12/13 11:45:00 data Exp $
 *
 */

#include "ExManagerConsole.h"

bool ExManagerConsole::m_flag = false; 
ExManagerConsole* ExManagerConsole::m_instance = NULL; 

ExManagerConsole* ExManagerConsole::CreateSingleton(void){
Guard(ExManagerConsole* ExManagerConsole::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerConsole; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerConsole::ExManagerConsole(void)
{
Guard(ExManagerConsole::ExManagerConsole(void))
	m_ConsoleState=HIDE;
	m_LineCounter=2;
	PosIntoBuffOldCommand=0;
	m_ConsoleTransPalier=20;
	m_fBlending=0.3f;
	m_fBackGroundBlue=1.0f;
	m_fBackGroundRed=1.0f;
	m_fBackGroundGreen=1.0f;
	console_move = false;
	m_BackGroundTextureState=true;
	m_Blending = false;
	LogConsol =true;
	m_AskForCommand=true;
	m_Move=0;
	#ifdef UNIX_SRC
	logfilecsl.open("/tmp/logConsol.txt",std::ios::out);
	#else
	logfilecsl.open("logConsol.txt",std::ios::out);
	#endif
	logfilecsl.close();
	SetStatus(false);
	SetAskForCommand(false);
	SetAskForExclusifCommand(false);

	TabTextures[0]=0;
	TabTextures[2]=0;TabTextures[3]=0;
	TabTextures[4]=1;TabTextures[5]=0;
	TabTextures[6]=1;

	TabVertices[0]=0;TabVertices[1]=0;
	TabVertices[2]=0;
	TabVertices[7]=0;

UnGuard
}


void ExManagerConsole::Reset(void)
{
Guard(ExManagerConsole::Reset(void))
	m_ConsoleState=HIDE;
	m_LineCounter=2;
	PosIntoBuffOldCommand=0;
	m_ConsoleTransPalier=20;
	//m_BufferConsol.clear();
	m_VecStringAction.clear();
//	SetConsoleBackGroudTexture("back2.tga");
	console_move = false;
UnGuard
}

ExManagerConsole::~ExManagerConsole(void)
{
Guard(ExManagerConsole::~ExManagerConsole(void))
UnGuard
}

void ExManagerConsole::Init(void)
{
Guard(void ExManagerConsole::init(void))
	SetConsoleBackGroudTexture("back");
UnGuard
}


void ExManagerConsole::SetConsoleBackGroudTexture(std::string	FileName)
{
Guard(void ExManagerConsole::SetConsoleBackGroudTexture(std::string	FileName))
	if(ManagerTexture->Add(FileName))
	{
		m_BackGroundTexture=FileName;	
	}

UnGuard
}
void ExManagerConsole::Draw(void)
{
Guard(void ExManagerConsole::Draw(void))
	if(!GetStatus())return;
	int i=0;
	float	textcoordy=0;
	float   cordy=0;
	char buffer[80];
	sprintf(buffer,"version %s ",VERSION);
	


	switch(m_ConsoleState)
	{
	case HIDE:
		SetStatus(false);
		break;

	case HALF:
		textcoordy=0.5f;
		cordy=ManagerWindow->GetResolutionY()/2;
		break;

	case FULL:
	   	textcoordy=1.0f;
		cordy=ManagerWindow->GetResolutionY();
		break;

	case HIDETOHALF:
		//cout<<"Draw hide to half "<<endl;
		textcoordy=(1.0f/m_ConsoleTransPalier)*m_ConsoleTrans;
		cordy=(ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans;
		m_ConsoleTrans++;
		if(cordy>((ManagerWindow->GetResolutionY()/2)-(ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)))
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case HIDETOFULL:
		//cout<<"Draw hide to full "<<endl;
		textcoordy=((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=(ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans;
		m_ConsoleTrans++;
		if(cordy>(ManagerWindow->GetResolutionY()))
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case HALFTOFULL:
		//cout<<"Draw half to full"<<endl;
		textcoordy=((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans)+0.5f;
		cordy=((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans)+ManagerWindow->GetResolutionY()/2;
		m_ConsoleTrans++;
		if(cordy>(ManagerWindow->GetResolutionY()))
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case FULLTOHIDE:
		//cout<<"Draw full to hide"<<endl;
		textcoordy=1.0f-((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=ManagerWindow->GetResolutionY()-((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans);
		m_ConsoleTrans++;
		if(cordy<0)
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;

	case FULLTOHALF:
		//cout<<"Draw full to half"<<endl;
		textcoordy=1.0f-((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=(ManagerWindow->GetResolutionY())-((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans);
		m_ConsoleTrans++;
		if(cordy<ManagerWindow->GetResolutionY()/2)
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;
 
	case HALFTOHIDE:
		//cout<<"Draw half to hide"<<endl;
		textcoordy=0.5f-((1.0f/m_ConsoleTransPalier)*m_ConsoleTrans);
		cordy=(ManagerWindow->GetResolutionY()/2)-((ManagerWindow->GetResolutionY()/m_ConsoleTransPalier)*m_ConsoleTrans);
		m_ConsoleTrans++;
		if(cordy<0)
		{
			m_ConsoleState=m_NextConsoleState;
		}
		break;
	}
	//-------------------
	//Draw back console
	//-------------------
	if(m_Move>0)LineUp();
	if(m_Move<0)LineDown();

	ExNihilo::EnterOrthoMode();
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	if(m_BackGroundTextureState)glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	ManagerTexture->SetCurrentObject(m_BackGroundTexture);
	if(m_Blending)
	{
		glColor4f(m_fBackGroundRed,m_fBackGroundGreen,m_fBackGroundBlue,m_fBlending);
		glEnable(GL_BLEND);
		glEnable(GL_ALPHA);
		glBlendFunc(GL_ONE,GL_ONE);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER,0);
		glDisable(GL_LIGHTING);
	}else
	{
		glColor4f(1,1,1,1);
	}

	TabTextures[1]=textcoordy;
	TabTextures[7]=textcoordy;


	TabVertices[3]=cordy;
	TabVertices[4]=ManagerWindow->GetResolutionX();
	TabVertices[5]=cordy;
	TabVertices[6]=ManagerWindow->GetResolutionX();

		glMatrixMode(GL_TEXTURE);
			glTranslatef(0.0f,-0.0001*glutGet(GLUT_ELAPSED_TIME),0.0f);
		glMatrixMode(GL_MODELVIEW);		
		ManagerTexture->SetTexture(0,"back3");
		glTexCoordPointer(2,GL_FLOAT,0,TabTextures);
		ManagerTexture->SetTexture(1,m_BackGroundTexture);
		glTexCoordPointer(2,GL_FLOAT,0,TabTextures);

		glEnableClientState(GL_VERTEX_ARRAY);
		glVertexPointer(2,GL_FLOAT,0,TabVertices);
		glDrawArrays( GL_QUADS, 0, 4 );
		ManagerTexture->ResetMultitexture();
		glMatrixMode(GL_TEXTURE);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
	glPopAttrib();

    //-------------------
	//Draw credits
	//-------------------
	glColor4f(0,0,1,1);
	
	ExNihilo::RenderBitmapString(ManagerWindow->GetResolutionX()-160,cordy-40,GLUT_BITMAP_8_BY_13,"ExNihilo Engine ");
	ExNihilo::RenderBitmapString(ManagerWindow->GetResolutionX()-160,cordy-30,GLUT_BITMAP_8_BY_13,buffer);
	ExNihilo::RenderBitmapString(ManagerWindow->GetResolutionX()-160,cordy-20,GLUT_BITMAP_8_BY_13,"Plok Software");
	//-------------------
	//Draw buffer console
	//-------------------
	glColor3f(0.5,0,0);
	
	UpdateConsolBuffer();


	for(i=0,m_RItBufferConsol=m_BufferConsol.rbegin();i<m_LineToStar;i++)
	{
		m_RItBufferConsol++;	
	}

	for(i=0;m_RItBufferConsol!=m_BufferConsol.rend();m_RItBufferConsol++,i++)
	{
		ExNihilo::RenderBitmapString(10,cordy-(10*i)-20,GLUT_BITMAP_8_BY_13,m_RItBufferConsol->data());	
		if(i*10>cordy)break;
	}
	
	m_BufferConsol.clear();
	
	//--------------------
	//Draw Current Command
	//--------------------
	ExNihilo::RenderBitmapString(10,cordy-10,GLUT_BITMAP_8_BY_13,"]"+m_BuffCommand);

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);

	ExNihilo::LeaveOrthoMode();	
	
	if (m_ConsoleState == m_NextConsoleState && console_move == true) {
		console_move = false;
	}
	
	//DrawBuffer();	
UnGuard
}
void ExManagerConsole::UpdateConsolBuffer(void)
{
Guard(void ExManagerConsole::UpdateConsolBuffer(void))
	std::string		bufferstring,bufferstring2;
	bufferstring=Consol->rdbuf( )->str();
	Consol->freeze(false);
	Consol->clear();
	Consol->flush();
	//m_BufferConsol.push_back(bufferstring);
	
	
	m_LineInConsol=0;
	do
	{
		bufferstring2 = bufferstring.substr(0,bufferstring.find ( "\n" ,0));
		bufferstring.erase(0,bufferstring.find ( "\n" ,0)+1);
		do
		{
			if(bufferstring2.size()>(unsigned)(ManagerWindow->GetResolutionX()/8)-1)
			{
				m_BufferConsol.push_back(bufferstring2.substr(0,((int)(ManagerWindow->GetResolutionX()/8))-1));
				bufferstring2=bufferstring2.substr(((int)(ManagerWindow->GetResolutionX()/8))-1,bufferstring2.size());
				m_LineInConsol++;
            }else
			{
				m_BufferConsol.push_back(bufferstring2);
				m_LineInConsol++;
				break;
			}
		}while(1);
	}while((unsigned)-1 != bufferstring.find( "\n" ,0));

	//-------------------
	//Save Consol Flux
	//-------------------
		
	if(LogConsol=true)
	{
		logfilecsl.open("logConsol.txt",std::ios::out);
		int i=0;
		for(m_ItBufferConsol=m_BufferConsol.begin();m_ItBufferConsol!=m_BufferConsol.end();m_ItBufferConsol++,i++)
		{
			logfilecsl<<i<<"::"<<m_ItBufferConsol->data()<<std::endl;					
		}
		//logfilecsl.close();
	}
UnGuard
}

void ExManagerConsole::LineUp(void)
{
	m_LineToStar++;
	if(m_LineToStar>m_LineInConsol)m_LineToStar=m_LineInConsol;
}
void ExManagerConsole::LineDown(void)
{
	m_LineToStar--;
	if(m_LineToStar<0){m_LineToStar=0;}
}

void ExManagerConsole::ConsoleMove (bool p) {
	console_move = p;
}

void ExManagerConsole::SetConsoleState(int state)
{
Guard(void ExManagerConsole::SetConsoleState(int state))
	//cout<<"set console state :"<<state<<endl;
	SetStatus(true);
	switch(m_ConsoleState)
	{
	case HIDE:
		m_NextConsoleState=state;
		switch(state)
		{
		case HALF:
			m_ConsoleState=HIDETOHALF;
			break;
		case FULL:
			m_ConsoleState=HIDETOFULL;
			break;
		}
		break;
	case HALF:
		m_NextConsoleState=state;
		switch(state)
		{
		case FULL:
			m_ConsoleState=HALFTOFULL;
			break;
		case HIDE:
			m_ConsoleState=HALFTOHIDE;
			break;
		}
		break;
	case FULL:
		m_NextConsoleState=state;
		switch(state)
		{
		case HALF:
			m_ConsoleState=FULLTOHALF;
			break;
		case HIDE:
			m_ConsoleState=FULLTOHIDE;
			break;
		}
		break;
	}
	m_ConsoleTrans=1;
UnGuard
}

int ExManagerConsole::NextAviableState(void) {
Guard(int ExManagerConsole::NextAviableState(void))
	switch(m_ConsoleState) {
		case HIDE: return HALF;
		case HALF: return FULL;
		case FULL: return HIDE;
		case HIDETOHALF	: return HALF;
		case HIDETOFULL : return FULL;
		case HALFTOFULL	: return FULL;
		case FULLTOHALF	: return HALF;
		case FULLTOHIDE	: return HIDE;
		case HALFTOHIDE	: return HIDE;
		default: return HALF;
	}
UnGuard
}

void ExManagerConsole::Write(const char *Label)
{
Guard(void ExManagerConsole::Write(const char *Label))
	//*Consol<<"<<==================Write to consol===========================>>"<<std::endl;
	*Consol << Label << std::endl;
	//*Consol<<"<<============================================================>>"<<std::endl;
UnGuard
}

ExCAction ExManagerConsole::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerConsole::InputCommand(ExCCommand Command))
	//std::cout<<"ManagerConsol::Input Command consol:"<<Command.m_Command<<std::endl;
	switch(Command.m_Command)
	{
	case KEYBOARD_DOWN_EXP:
		InputAction(CONSOL_NEXT_AVIABLE_STATE);
		return NOTHING;	
	
	case KEYBOARD_DOWN_ESC: 
		InputAction(HIDE_CONSOL);
		return NOTHING;	

	case KEYBOARD_DOWN_PAGE_UP:
		m_Move=-1;
		return NOTHING;
	
	case KEYBOARD_DOWN_PAGE_DOWN:
		m_Move=1;
		return NOTHING;

	case KEYBOARD_UP_PAGE_UP:
		m_Move=0;
		return NOTHING;
	
	case KEYBOARD_UP_PAGE_DOWN:
		m_Move=0;
		return NOTHING;

	case KEYBOARD_DOWN_SPACE:
		m_BuffCommand.append(" ");
		return NOTHING;

	case KEYBOARD_DOWN_ENTER:
		return ApplyBuffCommand();
	
	case KEYBOARD_DOWN_TAB: {
		std::vector<std::string> vec_tmp;
		std::vector<std::string>::iterator i_tmp;
		
		vec_tmp.push_back ("load");
		vec_tmp.push_back ("cmd");
		vec_tmp.push_back ("help");
		vec_tmp.push_back ("clear");
		vec_tmp.push_back ("quit");
		
		for (m_ItVecStringAction = m_VecStringAction.begin(); m_ItVecStringAction != m_VecStringAction.end(); m_ItVecStringAction++) {
			vec_tmp.push_back (m_ItVecStringAction->first);
		}
		
		i_tmp = vec_tmp.begin ();
		std::string tmp;
		
		while (i_tmp != vec_tmp.end ()) {
			tmp = *i_tmp++;
		
			if (tmp.find (m_BuffCommand) == 0) {
				if (tmp.find (' ') < tmp.length ())
					m_BuffCommand = tmp.substr (0, tmp.find (' '));
				else m_BuffCommand = tmp;
				//m_BuffCommand += ' '; // this add a space after command
				// but it sucks with some commands like quit :/
			}
		}
		return NOTHING;
	}

	case KEYBOARD_UP_ARROW_DOWN:
		PosIntoBuffOldCommand++;
		if(PosIntoBuffOldCommand<(int)m_BuffOldCommand.size()&&PosIntoBuffOldCommand>=-1)
		{
			m_BuffCommand=m_BuffOldCommand.at(PosIntoBuffOldCommand);			
		}else
		{
			PosIntoBuffOldCommand=0;
		}


		return NOTHING;
	
	case KEYBOARD_UP_ARROW_UP:
		PosIntoBuffOldCommand--;
		if(PosIntoBuffOldCommand<(int)m_BuffOldCommand.size()&&PosIntoBuffOldCommand>=0)
		{
			m_BuffCommand=m_BuffOldCommand.at(PosIntoBuffOldCommand);			
		}else
		{
			PosIntoBuffOldCommand=0;
		}
		return NOTHING;
	
	case KEYBOARD_UP_ARROW_LEFT:
		if(m_BuffCommand.size()>0)
		{
			m_BuffCommand.erase(m_BuffCommand.end()-1,m_BuffCommand.end());
		}
		return NOTHING;
	
	case KEYBOARD_UP_BACKSPACE:
		if(m_BuffCommand.size()>0)
		{
			m_BuffCommand.erase(m_BuffCommand.end()-1,m_BuffCommand.end());
		}
		return NOTHING;
	}
	ExNihilo::AddKeyToBuffer(Command.m_Command,m_BuffCommand);
	return NOTHING;
UnGuard
}

void ExManagerConsole::ListConsoleCommand(void)
{
Guard(void ExManagerConsole::ListConsoleCommand(void))
	*Consol<<"*******************************"<<std::endl;
	*Consol<<"*List of all available command*"<<std::endl;
	*Consol<<"*******************************"<<std::endl;
	*Consol<<"load 'FILENAME'"<<std::endl;
	*Consol<<"cmd 'number of command'"<<std::endl;;
	*Consol<<"help 'command'"<<std::endl;
	*Consol<<"clear 'clear console screen'"<<std::endl;
	*Consol<<"Extension ' List aviable Extension'"<<std::endl;
	*Consol<<"quit 'exit ExNihilo'"<<std::endl;
	int i=PREDIFINEDCOMMAND;
	for(m_ItVecStringAction=m_VecStringAction.begin(); m_ItVecStringAction != m_VecStringAction.end(); m_ItVecStringAction++, i++) 
	{
		*Consol<<m_ItVecStringAction->first.data()<<std::endl;
	}
	*Consol<<"*****************************"<<std::endl;
UnGuard
}

ExCAction ExManagerConsole::ApplyBuffCommand(void)
{
Guard(ExCAction ExManagerConsole::ApplyBuffCommand(void))
bool findaction=false;
	ExCAction Action;
	Action.m_StartingLife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000);
	*Consol<<m_BuffCommand.data()<<std::endl;
	for(m_ItVecStringAction=m_VecStringAction.begin();m_ItVecStringAction!=m_VecStringAction.end();m_ItVecStringAction++)
	{
		if(m_BuffCommand.find(m_ItVecStringAction->first.data())==0)
		{			 
			findaction=true;
			char buffer[255];
			memset(buffer,0,255);
			Action.m_Action=m_ItVecStringAction->second;
			m_BuffCommand.copy(buffer,(m_BuffCommand.size())-(strlen(m_ItVecStringAction->first.data())),strlen(m_ItVecStringAction->first.data()));
			Action.SetParam(buffer);
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
		}	    
	}
	if(!findaction)
	{
		if(strcmp(m_BuffCommand.data(),"clear")==0)
		{
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			m_BufferConsol.clear();
			ClearConsol();
			Action.m_Action= NOTHING;
			return Action;
		}
		
		if(m_BuffCommand.find("help")==0)
		{
			ListConsoleCommand();
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= NOTHING;
			return Action;
		}
		if(m_BuffCommand.find("Extension")==0)
		{
			*Consol<<"Extension      :"<<glGetString(GL_EXTENSIONS)<<std::endl;
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= NOTHING;
			return Action;
		}
		if(m_BuffCommand.find("cmd ")==0)
		{
			int cmd=0;
			char *SBuffer;
			SBuffer=new char[strlen(m_BuffCommand.data())-5] ;
			memset(SBuffer,0,strlen(m_BuffCommand.data()));
			m_BuffCommand.copy(SBuffer,m_BuffCommand.size()-4,4);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			try
			{
				cmd=atoi(SBuffer);
				Action.m_Action= m_VecStringAction.at(cmd-PREDIFINEDCOMMAND).second;
			}catch(...)
			{
				*Consol<<"Bad argument use list to show command list"<<std::endl;
				Action.m_Action= NOTHING;
				return Action;
			}
		}

		if(m_BuffCommand.find("run ")==0)
		{
			// stay ton fin space between each param and put it into action
			if (m_BuffCommand.size()<5) 
			{
				*Consol<<"run command need one argument"<<std::endl;
			}
			try
			{
				char *SBuffer;
				SBuffer=new char[strlen(m_BuffCommand.data())-4] ;
				m_BuffCommand.copy(SBuffer,m_BuffCommand.size()-4,m_BuffCommand.find("run ")+4);
				Action.m_Action= atoi(SBuffer);
			}catch(...){Action.m_Action= NOTHING;}
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			return Action;
		}

		if(strcmp(m_BuffCommand.data(),"quit")==0)
		{
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= QUIT;
			return Action;
		}
		
		if(strcmp(m_BuffCommand.data(),"reset")==0)
		{
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			Action.m_Action= RESET;
			return Action;
		}

		if(m_BuffCommand.find("load")!=(unsigned)-1)
		{
			char buffer[255];
			memset(buffer,0,255);
			Action.m_Action=LOAD_FILE;
			m_BuffCommand.copy(buffer,m_BuffCommand.size()-4,4);
			Action.SetParam(buffer);
			m_BuffOldCommand.push_back(m_BuffCommand);
			m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
			return Action;
		}
		
		*Consol<<"Unknow command"<<std::endl;
		m_BuffOldCommand.push_back(m_BuffCommand);
		m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
		Action.m_Action= NOTHING;
	}
	return Action;
UnGuard
}

void ExManagerConsole::AddStringAction(std::string String,int Action)
{
Guard(void ExManagerConsole::AddStringAction(std::string String,int Action))
	StringAction ac;
	ac.first=String;
	ac.second=Action;
	m_VecStringAction.push_back(ac);
	*Consol<<"Add new command to console command:"<<String<<" Action:"<<Action<<std::endl;
UnGuard
}

void ExManagerConsole::AddStringAction(StringAction StrAction)
{
Guard(void ExManagerConsole::AddStringAction(StringAction StrAction))
	AddStringAction(StrAction.first.data(),StrAction.second);
UnGuard
}

void ExManagerConsole::LoadStringActionFile(const char *FileName)
{
Guard(void ExManagerConsole::LoadStringActionFile(const char *FileName))
    char			buffer[255];
	
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Console/%s", FileName);
#else
	sprintf(buffer, "../Data/Console/%s", FileName);
#endif
	StringAction BuffStringAction;
	std::ifstream fin;
	std::string buffstring;
	char b[256];
	fin.open(buffer,std::ios::in);
	if(fin.is_open())
	{
		try
		{
			do
			{
				memset(b,0,255);
				fin.getline(b,256,'\n');
				try
				{
					buffstring=ExNihilo::ExtracValueFromSring(b,"<consolcommand>","<#consolcommand>");
					AddStringAction(ExNihilo::ExtracValueFromSring(buffstring,"<string>","<#string>")
						,ExNihilo::ExtractIntValueFromSring(buffstring,"<action>","<#action>"));
				}catch(ExCExpStringNotFound){}
			}while(!fin.eof());
			fin.close();
		}catch(...){throw ExCExpFileReadError();}
	}else throw   ExCExpFileNotFound();
UnGuard
}

void ExManagerConsole::ClearConsol(void)
{
Guard(void ExManagerConsole::ClearConsol(void))
	m_BuffOldCommand.push_back(m_BuffCommand);
	m_BuffCommand.erase(m_BuffCommand.begin(),m_BuffCommand.end());
	m_BufferConsol.clear();
UnGuard
}


ExCAction ExManagerConsole::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerConsole::InputAction(ExCAction Action))
	//std::cout<<"ManagerConsol::Input action :"<<Action<<std::endl;
	switch(Action.m_Action)
	{
	case CONSOL_LINE_UP:LineUp();break;
	case CONSOL_LINE_DOWN:LineDown();break;
    case SHOW_HALF_CONSOL:						
		if (!isConsoleMove ()) 
		{
			ConsoleMove (true);
			SetStatus(true);
			SetAskForCommand(true);
			SetAskForExclusifCommand(true);
			SetConsoleState(HALF);
		}
		break;
	case SHOW_FULL_CONSOL:
		if (!isConsoleMove ()) 
		{
			ConsoleMove (true);
			SetStatus(true);
			SetAskForCommand(true);
			SetAskForExclusifCommand(true);
			SetConsoleState(FULL);
		}
		break;
	case HIDE_CONSOL:	
		if (!isConsoleMove ()) 
		{
			ConsoleMove (true);
			SetStatus(false);
			SetConsoleState(HIDE);
			SetAskForCommand(false);
			SetAskForExclusifCommand(false);
		}
		break;
	case CONSOL_NEXT_AVIABLE_STATE:
		switch(NextAviableState())
		{
		case HIDE:
		case FULLTOHIDE:
		case HALFTOHIDE:
			if (!isConsoleMove ()) 
			{
				ConsoleMove (true);
				SetStatus(false);
				SetConsoleState(HIDE);
				SetAskForCommand(false);
				SetAskForExclusifCommand(false);
			}
			break;
		case HALF:
		case HIDETOHALF:
		case FULLTOHALF:
			if (!isConsoleMove ()) 
			{
				ConsoleMove (true);
				SetStatus(true);
				SetAskForCommand(true);
				SetAskForExclusifCommand(true);
				SetConsoleState(HALF);
			}
			break;
		case FULL:
		case HIDETOFULL:
		case HALFTOFULL:
			if (!isConsoleMove ()) 
			{
				ConsoleMove (true);
				SetStatus(true);
				SetAskForCommand(true);
				SetAskForExclusifCommand(true);
				SetConsoleState(FULL);
			}
			break;
		}
		break;

	case SET_CONSOL_BACKGROUND_TEXURE:SetConsoleBackGroudTexture(Action.m_Param);break;
	case ENABLE_CONSOL_BACKGROUND_TEXTURE:SetConsoleBackGroudTextureState(true);break;
	case DISABLE_CONSOL_BACKGROUND_TEXTURE:SetConsoleBackGroudTextureState(false);break;
	case SET_CONSOL_BACKGROUND_COLOR:break;
	case SET_CONSOL_BACKGROUND_COLOR_BLUE:
		try
		{
			SetConsoleBackGroudColorBlue(atof(Action.m_Param.data()));
		}catch(...)
		{
			*Consol<<"Enter a float value"<<std::endl;
		}
		break;
	case SET_CONSOL_BACKGROUND_COLOR_GREEN:
		try
		{
			SetConsoleBackGroudColorGreen(atof(Action.m_Param.data()));
		}catch(...)
		{
			*Consol<<"Enter a float value"<<std::endl;
		}
		break;
	case SET_CONSOL_BACKGROUND_COLOR_RED:
		try
		{
			SetConsoleBackGroudColorRed(atof(Action.m_Param.data()));
		}catch(...)
		{
			*Consol<<"Enter a float value"<<std::endl;
		}
	case ENABLE_CONSOL_BACKGROUND_BLENDING:SetConsoleBackGroudBlendingState(true);break;
	case DISABLE_CONSOL_BACKGROUND_BLENDING:SetConsoleBackGroudBlendingState(false);break;
	case SET_CONSOL_BACKGROUND_BLENDING:
		try
		{
			SetConsoleBackGroudBlending(atof(Action.m_Param.data()));
		}catch(...)
		{
			*Consol<<"Enter a float value"<<std::endl;
		}
		break;
	}	
    if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

