/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerConsole.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERCONSOLE_H__
#define __EXMANAGERCONSOLE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
#include "ExCCommand.h"
#include "ExCAction.h"
//#include <stdarg.h>
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerWindow.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
//Define
//------------------------------------------------------------------------
#define HIDE		0
#define HALF		1
#define FULL		2
#define HIDETOHALF	3
#define HIDETOFULL  4
#define HALFTOFULL	5
#define FULLTOHALF	6
#define FULLTOHIDE	7
#define HALFTOHIDE	8
#define PREDIFINEDCOMMAND 10
//------------------------------------------------------------------------
class ExManagerConsole   : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerWindow			*ManagerWindow;
	ExManagerTexture		*ManagerTexture;
	int						m_ConsoleState;	//HIDE,HALF,FULL
 	int						m_LineCounter;
 	int						m_ConsoleTrans;
	int						m_NextConsoleState;
	int						m_ConsoleTransPalier;
	bool					console_move;
	int						m_Move;
	bool					LogConsol;
	bool					m_BackGroundTextureState;
	bool					m_Blending;
	float                   m_fBlending;
	float                   m_fBackGroundBlue;
	float                   m_fBackGroundRed;
	float                   m_fBackGroundGreen;
	int						m_LineToStar;
	int						m_LineInConsol;
	std::ofstream				logfilecsl;
	int						PosIntoBuffOldCommand;
	
	std::string					m_BackGroundTexture;
	std::string					m_BuffCommand;
	std::vector<std::string>	m_BuffOldCommand;

	typedef std::pair<std::string,int>			StringAction;
    std::vector<StringAction>					m_VecStringAction;
	std::vector<StringAction>::iterator			m_ItVecStringAction;

   	std::vector<std::string>						m_BufferConsol;
	std::vector<std::string>::reverse_iterator		m_RItBufferConsol;
	std::vector<std::string>::iterator				m_ItBufferConsol;
	
	float TabTextures[8],TabVertices[8];
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void AddStringAction(std::string String,int Action);
	void AddStringAction(StringAction StrAction);
	ExCAction ApplyBuffCommand(void);
	void WriteInDaFile (std::string str);

	void UpdateConsolBuffer(void);
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerConsole *m_instance;
	ExManagerConsole(void);
	~ExManagerConsole(void);
public:
	static ExManagerConsole*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerTexture(ExManagerTexture *Texture){ManagerTexture = Texture;}

	void ClearConsol(void);
	void Reset(void);
	void Write (const char *);
	void Draw(void);
	
	void Init(void);
	int NextAviableState(void);
	void SetConsoleState(int state);
	int GetConsoleState (void) { return m_ConsoleState; }
	void ConsoleMove (bool);
	bool isConsoleMove (void) { return console_move; }
	void SetConsoleBackGroudTexture(std::string	FileName);
	inline void SetConsoleBackGroudTextureState(bool state){m_BackGroundTextureState=state;}
	inline void SetConsoleBackGroudBlendingState(bool state){m_Blending=state;}
	inline void SetConsoleBackGroudBlending(float blending){m_fBlending=blending;}
	inline void SetConsoleBackGroudColorRed(float value){m_fBackGroundRed=value;}
	inline void SetConsoleBackGroudColorGreen(float value){m_fBackGroundGreen=value;}
	inline void SetConsoleBackGroudColorBlue(float value){m_fBackGroundBlue=value;}
	inline void SetConsoleBackGroudColor(float R,float G,float B ){m_fBackGroundBlue=B;m_fBackGroundGreen=G;m_fBackGroundRed=R;}

	void LoadStringActionFile(const char *FileName);
	
	ExCAction InputCommand(ExCCommand Command);
	void ListConsoleCommand(void);

	void LineUp(void);
	void LineDown(void);

	ExCAction InputAction(ExCAction Action);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERCONSOLE_H__
