/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerFog.h											*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERFOG_H__
#define __EXMANAGERFOG_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
//------------------------------------------------------------------------
class ExManagerFog   : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	GLfloat			m_FogColor[4];
	GLfloat			m_StartPoint;
	GLfloat			m_EndPoint;
	GLfloat			m_Density;
	GLenum			m_FogAlgo;
	bool			m_State;

	PFNGLFOGCOORDFEXTPROC	glFogCoordfEXT ;	
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool	m_flag; 
	static ExManagerFog *m_instance;
	ExManagerFog(void);
	~ExManagerFog(void);
public:
	static ExManagerFog*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Reset(void);
	void Init(void);
	void Draw(void);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);

	void EnableFog(void);
	void DisableFog(void);
	inline bool GetState(void){return m_State;}

	void  SetFogColor(float R,float G,float B,float A);
	inline void SetFogColorR(float R);
	inline float GetFogColorR(void){return m_FogColor[0];}
	void  IncFogColorR(float inc);
	void  SetFogColorG(float G);
	inline float GetFogColorG(void){return m_FogColor[1];}
	void  IncFogColorG(float inc);
	void  SetFogColorB(float B);
	inline float GetFogColorB(void){return m_FogColor[2];}
	void  IncFogColorB(float inc);
	void  SetFogColorA(float A);
	inline float GetFogColorA(void){return m_FogColor[3];}
	void  IncFogColorA(float inc);

	void  SetStartPoint(float P);
	inline float GetStarPoint(void){return m_StartPoint;}
	void  IncStartPoint(float inc);
	
	void  SetEndPoint(float P);
	inline float GetEndPoint(void){return m_EndPoint;}
	void  IncEndPoint(float inc);

	void  SetDensity(float P);
	inline float GetDensity(void){return m_Density;}
	void  IncDensity(float inc);

	inline GLenum GetAlgo(void){return m_FogAlgo;}
	void SetAlgo(GLenum algo);

	void SetVolumetricFogCoord(GLfloat Value);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERFOG_H__
