/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerInputGLUT.cpp,v 1.10 2002/12/13 11:45:01 data Exp $
 *
 */
 
#include "ExManagerInputGLUT.h"

bool ExManagerInputGLUT::m_flag = false; 
ExManagerInputGLUT* ExManagerInputGLUT::m_instance = NULL; 

ExManagerInputGLUT* ExManagerInputGLUT::CreateSingleton(void){
Guard(ExManagerInputGLUT* ExManagerInputGLUT::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerInputGLUT; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerInputGLUT::ExManagerInputGLUT(void)
{
Guard(ExManagerInputGLUT::ExManagerInputGLUT(void))
	m_Keyboard=false;
	m_Mouse=false;
	m_SpaceBall=false;
	m_Tablet=false;
	m_Joystick=false;
	m_MouseNumberButtons=0;
	m_SpaceBallNumberButtons=0;
	m_TabletNumberButtons=0;
	m_JoystickNumberButtons=0;
	m_JoystickNumberAxes=0;
	for(int i=0;i<256;i++)
	{
		m_Pressed[i]=false;
	}
UnGuard
}

ExManagerInputGLUT::~ExManagerInputGLUT(void)
{
}

void ExManagerInputGLUT::CheckInput(void)
{
Guard(void ExManagerInputGLUT::CheckInput(void))
	*Consol<<"****************************************"<<std::endl;
	*Consol<<"*Checking for Hardware                 *"<<std::endl;
	*Consol<<"****************************************"<<std::endl;
	if(glutDeviceGet(GLUT_HAS_KEYBOARD)!=0)
	{
		m_Keyboard=true;
	}else
	{
		m_Keyboard=false;
	}
	if(glutDeviceGet(GLUT_HAS_MOUSE)!=0)
	{
		m_Mouse=true;
		m_MouseNumberButtons=glutDeviceGet(GLUT_NUM_MOUSE_BUTTONS);
	}
	else
	{
		m_Mouse=false;
	}
	if(glutDeviceGet(GLUT_HAS_SPACEBALL)!=0)
	{
		m_SpaceBall=true;
		m_SpaceBallNumberButtons=glutDeviceGet(GLUT_NUM_SPACEBALL_BUTTONS);
	}
	else
	{
		m_SpaceBall=false;
	}
	if(glutDeviceGet(GLUT_HAS_TABLET)!=0)
	{
		m_Tablet=true;
		m_TabletNumberButtons=glutDeviceGet(GLUT_NUM_TABLET_BUTTONS);
	}
	else
	{
		m_Tablet=false;
	}
	if(	glutDeviceGet(GLUT_HAS_JOYSTICK)!=0)
	{
		m_Joystick=true;
		m_JoystickNumberButtons=glutDeviceGet(GLUT_JOYSTICK_BUTTONS);
		m_JoystickNumberAxes=glutDeviceGet(GLUT_JOYSTICK_AXES);
	}
	else
	{
		m_Joystick=false;
	}
UnGuard
}

void ExManagerInputGLUT::DisplayAviableInput(void)
{
Guard(void ExManagerInputGLUT::DisplayAviableInput(void))

		
	if(m_Keyboard)
		*Consol<<"Keyboard       : available"<<std::endl;
	else
		*Consol<<"Keyboard       : Not available"<<std::endl;
	if(m_Mouse)
		*Consol<<"Mouse          : available "<<m_MouseNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"Mouse          : Not available"<<std::endl;
	if(m_SpaceBall)
		*Consol<<"SpaceBall      : available "<<m_SpaceBallNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"SpaceBall      : Not available"<<std::endl;
	if(m_Tablet)
		*Consol<<"Tablet         : available "<<m_TabletNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"Tablet         : Not available"<<std::endl;
    if(m_Joystick)
		*Consol<<"Joystick       : available "<<m_TabletNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"Joystick       : Not available"<<std::endl;
	
	*Consol<<"Graphic Render :"<<glGetString(GL_RENDERER)<<std::endl;
	*Consol<<"Company        :"<<glGetString(GL_VENDOR)<<std::endl;
	*Consol<<"Version        :"<<glGetString(GL_VERSION)<<std::endl;
	std::ofstream LogExtension;
	LogExtension.open("LogExtension.txt",std::ios::out);
	LogExtension<<glGetString(GL_EXTENSIONS)<<std::endl;
	LogExtension.close();
	*Consol<<"Extension      : Watch LogExtension.txt for a full list of aviable Extension or tape extension in consol"<<std::endl;
UnGuard
}

void ExManagerInputGLUT::Key(unsigned char key,int x,int y)
{
	if(key<177)
	{
		if(m_Pressed[key]==true)return;
		m_Pressed[key]=true;
	}	
	switch(key)
	{
	case 8:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_BACKSPACE,x,y));break;
	case 21:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_CTRL_U,x,y));break;
	case 9:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_TAB,x,y));break;
	case 27:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_ESC,x,y));break;
	case 178:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_EXP,x,y));break;
	case 13	:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_ENTER,x,y));break;
	case 32	:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_SPACE,x,y));break;
	case '_':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN__,x,y));break;
	case ':':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_2POINTS,x,y));break;
	case '.':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_POINT,x,y));break;
	case '0':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_0,x,y));break;
	case '1':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_1,x,y));break;
	case '2':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_2,x,y));break;
	case '3':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_3,x,y));break;
	case '4':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_4,x,y));break;
	case '5':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_5,x,y));break;
	case '6':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_6,x,y));break;
	case '7':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_7,x,y));break;
	case '8':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_8,x,y));break;
	case '9':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_9,x,y));break;
	case 'a':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_A,x,y));break;
	case 'A':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_A,x,y));break;
	case 'b':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_B,x,y));break;
	case 'B':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_B,x,y));break;
	case 'c':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_C,x,y));break;
	case 'C':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_C,x,y));break;
	case 'd':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_D,x,y));break;
	case 'D':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_D,x,y));break;
	case 'e':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_E,x,y));break;
	case 'E':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_E,x,y));break;
	case 'f':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F,x,y));break;
	case 'F':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_F,x,y));break;
	case 'g':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_G,x,y));break;
	case 'G':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_G,x,y));break;
	case 'h':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_H,x,y));break;
	case 'H':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_H,x,y));break;
	case 'i':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_I,x,y));break;
	case 'I':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_I,x,y));break;
	case 'j':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_J,x,y));break;
	case 'J':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_J,x,y));break;
	case 'k':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_K,x,y));break;
	case 'K':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_K,x,y));break;
	case 'l':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_L,x,y));break;
	case 'L':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_L,x,y));break;
	case 'm':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M,x,y));break;
	case 'M':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_M,x,y));break;
	case 'n':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_N,x,y));break;
	case 'N':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_N,x,y));break;
	case 'o':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_O,x,y));break;
	case 'O':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_O,x,y));break;
	case 'p':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_P,x,y));break;
	case 'P':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_P,x,y));break;
	case 'q':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_Q,x,y));break;
	case 'Q':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_Q,x,y));break;
	case 'r':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_R,x,y));break;
	case 'R':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_R,x,y));break;
	case 's':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_S,x,y));break;
	case 'S':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_S,x,y));break;
	case 't':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_T,x,y));break;
	case 'T':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_T,x,y));break;
	case 'u':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_U,x,y));break;
	case 'U':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_U,x,y));break;
	case 'v':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_V,x,y));break;
	case 'V':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_V,x,y));break;
	case 'w':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_W,x,y));break;
	case 'W':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_W,x,y));break;
	case 'x':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_X,x,y));break;
	case 'X':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_X,x,y));break;
	case 'y':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_Y,x,y));break;
	case 'Y':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_Y,x,y));break;
	case 'z':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_Z,x,y));break;
	case 'Z':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_M_Z,x,y));break;
	}
}

void ExManagerInputGLUT::KeyUp(unsigned char key, int x, int y)
{
	if(key<177)
	{
		if(m_Pressed[key]==false)return;
		m_Pressed[key]=false;
	}
	switch(key)
	{
	case 8:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_BACKSPACE,x,y));break;
	case 27:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_ESC,x,y));break;
	case 178:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_EXP,x,y));break;
	case 32	:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_SPACE,x,y));break;
	case ':':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_2POINTS,x,y));break;
	case '.':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_POINT,x,y));break;
	case '_':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP__,x,y));break;
	case '0':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_0,x,y));break;
	case '1':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_1,x,y));break;
	case '2':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_2,x,y));break;
	case '3':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_3,x,y));break;
	case '4':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_4,x,y));break;
	case '5':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_5,x,y));break;
	case '6':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_6,x,y));break;
	case '7':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_7,x,y));break;
	case '8':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_8,x,y));break;
	case '9':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_9,x,y));break;
	case 'a':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_A,x,y));break;
	case 'A':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_A,x,y));break;
	case 'b':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_B,x,y));break;
	case 'B':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_B,x,y));break;
	case 'c':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_C,x,y));break;
	case 'C':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_C,x,y));break;
	case 'd':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_D,x,y));break;
	case 'D':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_D,x,y));break;
	case 'e':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_E,x,y));break;
	case 'E':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_E,x,y));break;
	case 'f':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F,x,y));break;
	case 'F':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_F,x,y));break;
	case 'g':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_G,x,y));break;
	case 'G':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_G,x,y));break;
	case 'h':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_H,x,y));break;
	case 'H':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_H,x,y));break;
	case 'i':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_I,x,y));break;
	case 'I':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_I,x,y));break;
	case 'j':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_J,x,y));break;
	case 'J':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_J,x,y));break;
	case 'k':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_K,x,y));break;
	case 'K':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_K,x,y));break;
	case 'l':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_L,x,y));break;
	case 'L':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_L,x,y));break;
	case 'm':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M,x,y));break;
	case 'M':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_M,x,y));break;
	case 'n':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_N,x,y));break;
	case 'N':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_N,x,y));break;
	case 'o':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_O,x,y));break;
	case 'O':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_O,x,y));break;
	case 'p':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_P,x,y));break;
	case 'P':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_P,x,y));break;
	case 'q':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_Q,x,y));break;
	case 'Q':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_Q,x,y));break;
	case 'r':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_R,x,y));break;
	case 'R':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_R,x,y));break;
	case 's':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_S,x,y));break;
	case 'S':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_S,x,y));break;
	case 't':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_T,x,y));break;
	case 'T':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_T,x,y));break;
	case 'u':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_U,x,y));break;
	case 'U':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_U,x,y));break;
	case 'v':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_V,x,y));break;
	case 'V':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_V,x,y));break;
	case 'w':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_W,x,y));break;
	case 'W':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_W,x,y));break;
	case 'x':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_X,x,y));break;
	case 'X':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_X,x,y));break;
	case 'y':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_Y,x,y));break;
	case 'Y':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_Y,x,y));break;
	case 'z':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_Z,x,y));break;
	case 'Z':ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_M_Z,x,y));break;
	}
}

void ExManagerInputGLUT::KeySpe(int key,int x,int y)
{
Guard(void ExManagerInputGLUT::KeySpe(int key,int x,int y));
	if(m_Pressed[key]==true)return;
	m_Pressed[key]=true;
	switch (key) 
	{
	case GLUT_KEY_LEFT :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_ARROW_LEFT,x,y));break;
	case GLUT_KEY_RIGHT :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_ARROW_RIGHT,x,y));break;
	case GLUT_KEY_UP :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_ARROW_UP,x,y));break;
	case GLUT_KEY_DOWN :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_ARROW_DOWN,x,y));break;
	case GLUT_KEY_F1:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F1,x,y));break; 
	case GLUT_KEY_F2:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F2,x,y));break; 
	case GLUT_KEY_F3:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F3,x,y));break; 
	case GLUT_KEY_F4:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F4,x,y));break; 	
	case GLUT_KEY_F5:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F5,x,y));break; 
	case GLUT_KEY_F6:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F6,x,y));break; 	
	case GLUT_KEY_F7:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F7,x,y));break; 
	case GLUT_KEY_F8:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F8,x,y));break; 	
	case GLUT_KEY_F9:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F9,x,y));break; 
	case GLUT_KEY_F10:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F10,x,y));break; 	
	case GLUT_KEY_F11:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F11,x,y));break; 
	case GLUT_KEY_F12:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_F12,x,y));break;
	case GLUT_KEY_PAGE_UP:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_PAGE_UP,x,y));break; 
	case GLUT_KEY_PAGE_DOWN:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_PAGE_DOWN,x,y));break; 	
	case GLUT_KEY_END:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_END,x,y));break; 
	case GLUT_KEY_HOME:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_HOME,x,y));break; 	
	case GLUT_KEY_INSERT:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_DOWN_INSERT,x,y));break; 
	}
UnGuard
}

void ExManagerInputGLUT::KeySpeUp(int key, int x, int y)
{
	if(m_Pressed[key]==false)return;
	m_Pressed[key]=false;
	switch (key) 
	{
	case GLUT_KEY_LEFT :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_ARROW_LEFT,x,y));break;
	case GLUT_KEY_RIGHT :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_ARROW_RIGHT,x,y));break;
	case GLUT_KEY_UP :ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_ARROW_UP,x,y));break;
	case GLUT_KEY_DOWN:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_ARROW_DOWN,x,y));break;
	case GLUT_KEY_F1:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F1,x,y));break; 
	case GLUT_KEY_F2:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F2,x,y));break; 
	case GLUT_KEY_F3:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F3,x,y));break; 
	case GLUT_KEY_F4:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F4,x,y));break; 	
	case GLUT_KEY_F5:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F5,x,y));break; 
	case GLUT_KEY_F6:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F6,x,y));break; 	
	case GLUT_KEY_F7:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F7,x,y));break; 
	case GLUT_KEY_F8:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F8,x,y));break; 	
	case GLUT_KEY_F9:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F9,x,y));break; 
	case GLUT_KEY_F10:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F10,x,y));break; 	
	case GLUT_KEY_F11:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F11,x,y));break; 
	case GLUT_KEY_F12:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_F12,x,y));break;
	case GLUT_KEY_PAGE_UP:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_PAGE_UP,x,y));break; 
	case GLUT_KEY_PAGE_DOWN:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_PAGE_DOWN,x,y));break; 	
	case GLUT_KEY_END:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_END,x,y));break; 
	case GLUT_KEY_HOME:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_HOME,x,y));break; 	
	case GLUT_KEY_INSERT:ManagerCommand->InputCommand(ExCCommand(KEYBOARD_UP_INSERT,x,y));break; 
	}
}

void ExManagerInputGLUT::Mouse(int button, int state, int x, int y)
{
	//GLUT_UP ou GLUT_DOWN
	switch(button)
	{
	case GLUT_LEFT_BUTTON:
		if(state==GLUT_UP)
		{
			ManagerCommand->InputCommand(ExCCommand(MOUSE_LEFT_BUTTON_UP,x,y));
		}
		if(state==GLUT_DOWN)
		{
			ManagerCommand->InputCommand(ExCCommand(MOUSE_LEFT_BUTTON_DOWN,x,y));
		}
		break;
	case GLUT_MIDDLE_BUTTON:
		if(state==GLUT_UP)
		{
			ManagerCommand->InputCommand(ExCCommand(MOUSE_MIDDLE_BUTTON_UP,x,y));
		}
		if(state==GLUT_DOWN)
		{
			ManagerCommand->InputCommand(ExCCommand(MOUSE_MIDDLE_BUTTON_DOWN,x,y));
		}
		break;
	case GLUT_RIGHT_BUTTON:
		if(state==GLUT_UP)
		{
			ManagerCommand->InputCommand(ExCCommand(MOUSE_RIGHT_BUTTON_UP,x,y));
		}
		if(state==GLUT_DOWN)
		{
			ManagerCommand->InputCommand(ExCCommand(MOUSE_RIGHT_BUTTON_DOWN,x,y));
		}
		break;
	}
}
void ExManagerInputGLUT::Focus(int state)
{
Guard(void ExManagerInputGLUT::MouseFocus(int state))
	switch(state)
	{
	case GLUT_LEFT :
		break;
	case GLUT_ENTERED :
		break;
	}
UnGuard
}
void ExManagerInputGLUT::MouseMotion(int x, int y)
{
Guard(void ExManagerInputGLUT::MouseMotion(int x, int y))
	ManagerCommand->InputCommand(ExCCommand(MOUSE_MOTION,x,y));
UnGuard
}
void ExManagerInputGLUT::MousePassiveMotion(int x, int y)
{
Guard(void ExManagerInputGLUT::MousePassiveMotion(int x, int y))
	ManagerCommand->InputCommand(ExCCommand(MOUSE_MOTION_PASSIVE,x,y));
UnGuard
}
void ExManagerInputGLUT::SpaceballMotion(int x, int y, int z)
{
Guard(void ExManagerInputGLUT::SpaceballMotion(int x, int y, int z))
UnGuard
}
void ExManagerInputGLUT::SpaceballRotate(int x, int y, int z)
{
Guard(void ExManagerInputGLUT::SpaceballRotate(int x, int y, int z))
UnGuard
}
void ExManagerInputGLUT::TabletMotion(int x, int y)
{
Guard(void ExManagerInputGLUT::TabletMotion(int x, int y))
UnGuard
}
void ExManagerInputGLUT::TabletButton(int button, int state, int x, int y)
{
Guard(void ExManagerInputGLUT::TabletButton(int button, int state, int x, int y))
UnGuard
}
