/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :InputActionList.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERINPUTGLUT_H__
#define __EXMANAGERINPUTGLUT_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExCCommand.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerCommand.h"
//------------------------------------------------------------------------
class ExManagerInputGLUT : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerCommand		*ManagerCommand;
	bool					m_Keyboard;
	bool					m_Mouse;
	bool					m_SpaceBall;
	bool					m_Tablet;
	bool					m_Joystick;
	int						m_MouseNumberButtons;
	int						m_SpaceBallNumberButtons;
	int						m_TabletNumberButtons;
	int						m_JoystickNumberButtons;
	int						m_JoystickNumberAxes;
	bool					m_Pressed[256];
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerInputGLUT *m_instance;
	ExManagerInputGLUT(void);
	~ExManagerInputGLUT(void);
public:
	static ExManagerInputGLUT*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Reset(void){return;}
	void Init(void){return;}
	inline void SetManagerCommand(ExManagerCommand *Command){ManagerCommand = Command;}
//------------------------------------------------------------------------
//Ask for Hardware Methode
//------------------------------------------------------------------------
	inline bool IsKeyboard(void)	{return m_Keyboard;};
	inline bool IsMouse(void)		{return m_Mouse;};
	inline bool IsSpaceBall(void)	{return m_SpaceBall;};
	inline bool IsTablet(void)		{return m_Tablet;};
	inline bool IsJoystick(void)	{return m_Joystick;};
	void CheckInput(void);
	void DisplayAviableInput(void);
//------------------------------------------------------------------------
//Keyboard function
//------------------------------------------------------------------------
	void Key		(unsigned char key,int x,int y);
	void KeyUp		(unsigned char key, int x, int y);
	void KeySpe		(int key,int x,int y);			
	void KeySpeUp	(int key, int x, int y);
//------------------------------------------------------------------------
//Mouse Function
//------------------------------------------------------------------------
	void Mouse				(int button, int state, int x, int y);
	void MouseMotion		(int x, int y);
	void MousePassiveMotion	(int x, int y);
	void Focus				(int state);
//------------------------------------------------------------------------
//SpaceBall Function
//------------------------------------------------------------------------
	void SpaceballMotion(int x, int y, int z);
	void SpaceballRotate(int x, int y, int z);
//------------------------------------------------------------------------
//Tablet Function
//------------------------------------------------------------------------
	void TabletMotion(int x, int y); 
	void TabletButton(int button, int state, int x, int y);
//------------------------------------------------------------------------
//joystik Function
//------------------------------------------------------------------------
};
//------------------------------------------------------------------------
#endif //__EXMANAGERINPUTGLUT_H__
