/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerMap.cpp,v 1.9 2002/09/22 15:54:04 data Exp $
 *
 */

#include "ExManagerMap.h"

bool ExManagerMap::m_flag = false; 
ExManagerMap* ExManagerMap::m_instance = NULL; 

ExManagerMap* ExManagerMap::CreateSingleton(void){
Guard(ExManagerMap* ExManagerMap::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerMap; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerMap::ExManagerMap(void)
{
	MapLoaded=false;
	SkyLoaded=false;
}

ExManagerMap::~ExManagerMap(void)
{
}

void ExManagerMap::Init(void)
{

}

void ExManagerMap::Reset(void)
{
	MapLoaded=false;
	SkyLoaded=false;
}

void ExManagerMap::Load(std::string FileName)
{
Guard(ExManagerMap::Load(std::string FileName))

	//find extension type of map
	if(FileName.find("."))
	{
		//skybox
		if(FileName.find(".skyb")==(FileName.length()-5))
		{
			Skybox=new ExCSkyBox();
			Skybox->SetManagerTexture(ManagerTexture);
			Skybox->SetFileName(FileName);
			Skybox->Load(FileName);
			SkyLoaded=true;
			return;
		}
		//bsp map
		if(FileName.find(".bsp")==(FileName.length()-4))
		{
			return;
		}
		//height map
		if(FileName.find(".hgmp")==(FileName.length()-5))
		{
			HeightMap=new ExCHeightMap();
			HeightMap->SetManagerTexture(ManagerTexture);
			HeightMap->SetManagerFog(ManagerFog);
			HeightMap->SetFileName(FileName);
			HeightMap->Load(FileName);
			MapLoaded=true;
			return;
		}
	}

UnGuard
}

void ExManagerMap::Draw(void)
{
Guard(void ExManagerMap::Draw(void))
	if(MapLoaded)
	{
		HeightMap->Draw();
	}
	if(SkyLoaded)
	{
		Skybox->Draw();
	}
UnGuard
}

ExCAction ExManagerMap::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerMap::InputCommand(ExCCommand Command))
	return NOTHING;
UnGuard
}

ExCAction ExManagerMap::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerMap::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
	
	case HEIGHTMAP_INCREASE_DETAIL_LEVEL:HeightMap->IncreaseDetailLevel();break;
	case HEIGHTMAP_DECREASE_DETAIL_LEVEL:HeightMap->DereaseDetailLevel();break;
	case HEIGHTMAP_ENABLE_FOG:HeightMap->SetFogState(true);break;
	case HEIGHTMAP_DISABLE_FOG:HeightMap->SetFogState(false);break;
	case HEIGHTMAP_SWITCH_FOG:HeightMap->GetFogState()? HeightMap->SetFogState(false):HeightMap->SetFogState(true);

	case HEIGHTMAP_INCREASE_FOG_DEPHT_LEVEL:HeightMap->IncreaseFogDepthLevel();break;
	case HEIGHTMAP_DECREASE_FOG_DEPHT_LEVEL:HeightMap->DereaseFogDepthLevel();break;

	case HEIGHTMAP_INCREASE_TEXTURE_2_REPETITION:HeightMap->IncreaseTexture2Repetition();break;
	case HEIGHTMAP_DECREASE_TEXTURE_2_REPETITION:HeightMap->DereaseTexture2Repetition();break;
	case RELOAD_MANAGER_MAP:
		if(SkyLoaded)Skybox->Load(Skybox->GetFileName());
		if(MapLoaded)HeightMap->Load(HeightMap->GetFileName());
		break;
	default:
		*Consol<<"Can not file action in MAP_ACTION_MAP"<<std::endl;
		break;
	}	
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

