/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :InputActionList.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERMAP_H__
#define __EXMANAGERMAP_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Tools/ExCImageLoader.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ExManagerFog.h"
#include "Manager/ExManagerId.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCHeightMap.h"
#include "Object/Object3D/ExCSkyBox.h"
//------------------------------------------------------------------------
class ExManagerMap : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerId					*ManagerId;
	ExManagerTexture			*ManagerTexture;
	ExManagerFog				*ManagerFog;
	ExCHeightMap				*HeightMap;
	ExCSkyBox					*Skybox;
	bool						 MapLoaded;
	bool						 SkyLoaded;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerMap *m_instance;
	ExManagerMap(void);
	~ExManagerMap(void);
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerMap*  CreateSingleton(void);
	void Init(void);
	void Reset(void);

	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);

	inline void SetManagerId(ExManagerId *Id){ManagerId	= Id;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	inline void SetManagerFog(ExManagerFog * Fog){ManagerFog=Fog;}

	void Draw(void);
	void LoadSkybox(std::string FileName);
	void Load(std::string FileName);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERMAP_H__

