/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerNetwork.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERNETWORK_H__
#define __EXMANAGERNETWORK_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
#include "ExCAction.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
//------------------------------------------------------------------------
#include "NetWork/ExCSocket.h"
#include "NetWork/ExCSocketClient.h"
#include "NetWork/ExCMessage.h"
//------------------------------------------------------------------------
class ExManagerNetwork  : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExCSocketClient			m_SocketClient;
	std::string				m_ServerIp;
	bool					m_ShowNetStat;
	bool					m_ShowMessage;
	bool					m_ShowSayBar;
	bool					m_Connected;
	float					m_LastPing;
	std::string				m_BuffSay;
	std::string				m_BuffOldSay1;
	std::string				m_BuffOldSay2;
	std::string				m_BuffOldSay3;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerNetwork *m_instance;
	ExManagerNetwork(void);
	~ExManagerNetwork(void);
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerNetwork*  CreateSingleton(void);

	void Reset(void);
	void Init(void);
	void Draw(void);
	void DrawNetStat(void);
	void DrawMessage(void);
	void Connect(void);
	void Disconnect(void);
	void Ping(void);
	void Say(void);
	
	inline bool GetNetstatState(void){return m_ShowNetStat;}
	inline void SetNetstatState(bool state){m_ShowNetStat=state;}
	inline bool GetMessageState(void){return m_ShowMessage;}
	inline void SetMessageState(bool state){m_ShowMessage=state;}
	inline bool GetSayBarState(void){return m_ShowSayBar;}
	inline void SetSayBarState(bool state){m_ShowSayBar=state;}
	ExCAction InputAction(ExCAction Action);
	ExCAction InputCommand(ExCCommand Command);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERNETWORK_H__
