/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerNetwork.cpp,v 1.3 2002/11/24 11:58:58 data Exp $
 *
 */

#include "ExManagerNetwork.h"

bool ExManagerNetwork::m_flag = false; 
ExManagerNetwork* ExManagerNetwork::m_instance = NULL; 

ExManagerNetwork* ExManagerNetwork::CreateSingleton(void){
Guard(ExManagerNetwork* ExManagerNetwork::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerNetwork; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerNetwork::ExManagerNetwork(void)
{
	
}

ExManagerNetwork::~ExManagerNetwork(void)
{
}

void ExManagerNetwork::Init(void)
{
	m_ShowNetStat=false;
	m_ShowMessage=false;
	m_ShowSayBar=false;
	m_ServerIp="No Connexion";
	m_Connected=false;
	m_LastPing=0.0f;
	SetAskForCommand(false);
	SetAskForExclusifCommand(false);
	
}

void ExManagerNetwork::Draw(void)
{
	if(m_ShowNetStat)DrawNetStat();
	if(m_ShowMessage)DrawMessage();


}

void ExManagerNetwork::DrawNetStat(void)
{
	//ExNihilo::DrawCadre(10,glutGet(GLUT_WINDOW_HEIGHT)-135,140,50,0.2f,0.0f,0.6f,0.9f);
	
	ExNihilo::DrawCadre(glutGet(GLUT_WINDOW_WIDTH)-135,	glutGet(GLUT_WINDOW_HEIGHT)-80,	130,50,0.2f,0.0f,0.6f,0.9f);
	ExNihilo::WriteToScreen(glutGet(GLUT_WINDOW_WIDTH)-130,glutGet(GLUT_WINDOW_HEIGHT)-65,1,1,1,"NetStat");
	std::string buffserver("Server :");
	buffserver=buffserver+m_ServerIp;
	ExNihilo::WriteToScreen(glutGet(GLUT_WINDOW_WIDTH)-130,glutGet(GLUT_WINDOW_HEIGHT)-50,1,1,1,buffserver);
	char buffping[255];
	Ping();
	sprintf(buffping,"Ping :%4.4f",m_LastPing);
	ExNihilo::WriteToScreen(glutGet(GLUT_WINDOW_WIDTH)-130,glutGet(GLUT_WINDOW_HEIGHT)-35,1,1,1,buffping);
}

void ExManagerNetwork::DrawMessage(void)
{
	//draw old message
	ExNihilo::DrawCadre(10,glutGet(GLUT_WINDOW_HEIGHT)-80,glutGet(GLUT_WINDOW_WIDTH)-150,50,0.8f,0.0f,0.0f,0.9f);
	ExNihilo::WriteToScreen(15,glutGet(GLUT_WINDOW_HEIGHT)-65,1,1,1,m_BuffOldSay3);
	ExNihilo::WriteToScreen(15,glutGet(GLUT_WINDOW_HEIGHT)-50,1,1,1,m_BuffOldSay2);
	ExNihilo::WriteToScreen(15,glutGet(GLUT_WINDOW_HEIGHT)-35,1,1,1,m_BuffOldSay1);
	//draw current phrase
	if(m_ShowSayBar)
	{
		ExNihilo::DrawCadre(10,glutGet(GLUT_WINDOW_HEIGHT)-25,glutGet(GLUT_WINDOW_WIDTH)-15,20,0.7f,0.1f,0.0f,0.9f);
		ExNihilo::WriteToScreen(15,glutGet(GLUT_WINDOW_HEIGHT)-10,1,1,1,m_BuffSay);
	}
}

void  ExManagerNetwork::Ping(void)
{
	if(glutGet(GLUT_ELAPSED_TIME)%100==0)
	{
		if(m_Connected)
		{
			int time;
			ExCMessage buffmsg;
			time=glutGet(GLUT_ELAPSED_TIME);
			buffmsg.SetType(MESSAGE_PING);
			m_SocketClient.SendMessage(buffmsg);
			m_SocketClient.RecvMessage(buffmsg);
			m_LastPing=((float)(glutGet(GLUT_ELAPSED_TIME)-time)/100);
		}
	}
}

void ExManagerNetwork::Reset(void)
{
Guard(void ExManagerNetwork::Reset(void))
UnGuard
}


void ExManagerNetwork::Connect(void)
{
Guard(void ExManagerNetwork::Connect(void))
	m_SocketClient.Init();
	if(m_SocketClient.Connect()==0)
	{
		m_Connected=true;
		m_ServerIp="192.168.0.1";
		m_ShowNetStat=true;
		ExCMessage buffmsg;
		
		//w8 msg from server
		m_SocketClient.RecvMessage(buffmsg);
	//	*Consol<<buffmsg<<std::endl;
		//send login
		
		buffmsg.SetType(MESSAGE_LOGIN);
		buffmsg.SetMessage("Client");
		m_SocketClient.SendMessage(buffmsg);
	//	*Consol<<"connected"<<std::endl;
	}else
	{
	//	*Consol<<"Socket error"<<std::endl;
		m_SocketClient.Close();
	}
UnGuard
}

void ExManagerNetwork::Disconnect(void)
{
Guard(void ExManagerNetwork::Disconnect(void))
	ExCMessage buffmsg;
	buffmsg.SetType(MESSAGE_QUIT);
	m_SocketClient.SendMessage(buffmsg);	
	m_SocketClient.Close();
	m_Connected=false;
	m_ServerIp="No Connexion";

UnGuard
}

void ExManagerNetwork::Say(void)
{
Guard(void ExManagerNetwork::Say(void))
	SetAskForCommand(true);
	SetAskForExclusifCommand(true);
	SetSayBarState(true);
UnGuard
}

ExCAction ExManagerNetwork::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerNetwork::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
	case SHOW_NET_STAT:
		SetNetstatState(true);
		break;
	case HIDE_NET_STAT:
		SetNetstatState(false);
		break;
	case SHOW_CHAT:
		SetMessageState(true);
		break;
	case HIDE_CHAT:
		SetMessageState(false);
		break;
	case CONNECT:
		Connect();
		break;
	case DISCONNECT:
		Disconnect();
		break;
	case SAY:
		Say();
		break;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

ExCAction ExManagerNetwork::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerNetwork::InputCommand(ExCCommand Command))
	//std::cout<<"ExManagerNetwork::Input Command network:"<<Command.m_Command<<std::endl;
	//custom action
	switch(Command.m_Command)
	{
	case KEYBOARD_UP_ARROW_LEFT:
		if(m_BuffSay.size()>0)
		{
			m_BuffSay.erase(m_BuffSay.end()-1,m_BuffSay.end());
		}
		return NOTHING;
	
	case KEYBOARD_UP_BACKSPACE:
		if(m_BuffSay.size()>0)
		{
			m_BuffSay.erase(m_BuffSay.end()-1,m_BuffSay.end());
		}
		return NOTHING;

	case KEYBOARD_DOWN_ENTER:
		if(m_Connected)
		{
			ExCMessage buffmsg;
			buffmsg.SetType(MESSAGE_SAY);
			buffmsg.SetMessage(m_BuffSay);
			m_SocketClient.SendMessage(buffmsg);	
		}
		SetAskForCommand(false);
		SetAskForExclusifCommand(false);
		m_BuffOldSay3=m_BuffOldSay2;
		m_BuffOldSay2=m_BuffOldSay1;
		m_BuffOldSay1=m_BuffSay;
		SetSayBarState(false);
		m_BuffSay.erase(m_BuffSay.begin(),m_BuffSay.end());

		return NOTHING;
	}
	//simple text action
	ExNihilo::AddKeyToBuffer(Command.m_Command,m_BuffSay);
	return NOTHING;
UnGuard
}
