/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerOutput.cpp,v 1.23 2002/11/24 11:58:58 data Exp $
 *
 */

#include "ExManagerOutput.h"

bool ExManagerOutput::m_flag = false; 
ExManagerOutput* ExManagerOutput::m_instance = NULL; 

ExManagerOutput* ExManagerOutput::CreateSingleton(void){
Guard(ExManagerOutput* ExManagerOutput::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerOutput; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerOutput::ExManagerOutput(void)
{
Guard(ExManagerOutput::ExManagerOutput(void))
UnGuard
}

ExManagerOutput::~ExManagerOutput(void)
{
Guard(ExManagerOutput::~ExManagerOutput(void))
UnGuard
}

void ExManagerOutput::Reset(void)
{
	Init();
}

void ExManagerOutput::Init(void)
{
Guard(ExManagerOutput::Init(void))
 	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	//glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);
	//glEnable(GL_LIGHTING);
	glPolygonMode(GL_FRONT,GL_FILL);
	glEnable(GL_COLOR_MATERIAL );
	glEnable(GL_DEPTH_TEST);
	//glEnable(GL_AUTO_NORMAL);
	//glEnable(GL_NORMALIZE);
	glEnable(GL_ALPHA_TEST);
	//glLightModelf(GL_LIGHT_MODEL_TWO_SIDE,GL_FALSE);
	glLineWidth(1.5);
	glRenderMode(GL_RENDER);



UnGuard
}



void ExManagerOutput::Reshape(int w,int h)
{
Guard(ExManagerOutput::Reshape(int w,int h))
	ManagerWindow->SetResolution(w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glViewport(0,0,ManagerWindow->GetResolutionX(),ManagerWindow->GetResolutionY());
	gluPerspective(ManagerCamera->GetCurrentObject()->GetZoom(),
		(1.0f *ManagerWindow->GetResolutionX() / ManagerWindow->GetResolutionY()),
		ManagerCamera->GetCurrentObject()->GetClipNear(),
		ManagerCamera->GetCurrentObject()->GetClipFar());
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	ManagerCamera->GetCurrentObject()->Draw();
UnGuard
}

void ExManagerOutput::DrawScene(void)
{
Guard(ExManagerOutput::DrawScene(void))
	//std::cout<<"Drawscene"<<std::endl;
	//glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_ACCUM_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);	//Clear screen
	//glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
	ManagerCommand->ApplyAction();						//Apply all action for this frame
	ManagerAnimation->Draw();							//Apply all mouvement to object
	//ManagerCollision->ResolveCollision();				//Check for collision and modify object force
	//-------------------------------------------
	//Draw 3d Object
	//-------------------------------------------
	ManagerCamera->Draw();
    ManagerSpecialEffect->BeforeDraw();
	ManagerCollision->Clear();
    
	
	ManagerMap->Draw();
	ManagerModel->Draw();
	ManagerGizmo->Draw();
	ManagerPVS->Draw();
	ManagerParticuleSystem->Draw();
	ManagerLight->Draw();
	if(ManagerWindow->GetGrilleState()){ExNihilo::DrawGrid(250);}
	
	//-------------------------------------------
	//Draw 2d Object
	//-------------------------------------------
	ManagerSpecialEffect->Draw();
	if(ManagerInterface->GetStatus()){ManagerInterface->Draw();}
	if(ManagerWindow->GetFpsState())ManagerWindow->ShowFps();
	//ManagerVertexProgram->Draw();
	ManagerNetwork->Draw();
	ManagerSpirit->Draw();
	
	

	ManagerObjectWindow->Draw();
	ManagerLoad->Draw();
	ManagerConsole->Draw();
	glFlush();
	glutSwapBuffers();

UnGuard
}

