/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :InputActionList.h										*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGEROUTPUT_H__
#define __EXMANAGEROUTPUT_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerWindow.h"
#include "Manager/ExManagerCollision.h"
#include "Manager/ExManagerFog.h"
#include "Manager/ExManagerCommand.h"
#include "Manager/ExManagerConsole.h"
#include "Manager/ExManagerSpecialEffect.h"
#include "Manager/ExManagerMap.h"
#include "Manager/ExManagerNetwork.h"
#include "Manager/ExManagerPVS.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerInterface.h"
#include "Manager/ManagerObject/ExManagerSpirit.h"
#include "Manager/ManagerObject/ExManagerAnimation.h"
#include "Manager/ManagerObject/ExManagerCamera.h"
#include "Manager/ManagerObject/ExManagerModele.h"
#include "Manager/ManagerObject/ExManagerGizmo.h"
#include "Manager/ManagerObject/ExManagerParticuleSystem.h"
#include "Manager/ManagerObject/ExManagerLight.h"
#include "Manager/ManagerObject/ExManagerVertexProgram.h"
#include "Manager/ManagerObject/ExManagerObjectWindow.h"
#include "Manager/ManagerObject/ExManagerLoad.h"
#include "Manager/ManagerObject/ExManagerLight.h"
//------------------------------------------------------------------------
class ExManagerOutput  : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerCollision			*ManagerCollision;
	ExManagerFog				*ManagerFog;
	ExManagerAnimation			*ManagerAnimation;
	ExManagerWindow				*ManagerWindow;
	ExManagerCommand			*ManagerCommand;
	ExManagerConsole			*ManagerConsole;

	ExManagerInterface			*ManagerInterface;
	ExManagerSpirit				*ManagerSpirit;

	ExManagerMap				*ManagerMap;
	ExManagerCamera				*ManagerCamera;
	ExManagerModel				*ManagerModel;
	ExManagerGizmo				*ManagerGizmo;
	ExManagerParticuleSystem	*ManagerParticuleSystem;
	ExManagerLight				*ManagerLight;
	ExManagerNetwork			*ManagerNetwork;
	ExManagerVertexProgram		*ManagerVertexProgram;
	ExManagerObjectWindow		*ManagerObjectWindow;
	ExManagerSpecialEffect		*ManagerSpecialEffect;
	ExManagerPVS				*ManagerPVS;
	ExManagerLoad				*ManagerLoad;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerOutput *m_instance;
	ExManagerOutput(void);
	~ExManagerOutput(void);
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerOutput*  CreateSingleton(void);

	inline void SetManagerCollision(ExManagerCollision *Collision){ManagerCollision = Collision;}
	inline void SetManagerFog(ExManagerFog *Fog){ManagerFog = Fog;}
	inline void SetManagerAnim(ExManagerAnimation *Anim){ManagerAnimation = Anim;}
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerCommand(ExManagerCommand *Command){ManagerCommand	= Command;}
	inline void SetManagerConsole(ExManagerConsole * Console){ManagerConsole=Console;}
	inline void SetManagerInterface(ExManagerInterface * Interface){ManagerInterface=Interface;}
	inline void SetManagerSpirit(ExManagerSpirit * Spirit){ManagerSpirit=Spirit;}
	inline void SetManagerMap(ExManagerMap *Map){ManagerMap = Map;}
	inline void SetManagerCamera(ExManagerCamera *Cam){ManagerCamera = Cam;}
	inline void SetManagerModel(ExManagerModel *Model){ManagerModel = Model;}
	inline void SetManagerGizmo(ExManagerGizmo *Gizmo){ManagerGizmo = Gizmo;}
	inline void SetManagerParticuleSystem(ExManagerParticuleSystem *ParticuleSystem){ManagerParticuleSystem = ParticuleSystem;}
	inline void SetManagerLight(ExManagerLight *Light){ManagerLight = Light;}
	inline void SetManagerNetwork(ExManagerNetwork *Network){ManagerNetwork = Network;}
	inline void SetManagerVertexProgram(ExManagerVertexProgram *VertexProgram){ManagerVertexProgram = VertexProgram;}
	inline void SetManagerObjectWindow(ExManagerObjectWindow *ObjectWindow){ManagerObjectWindow = ObjectWindow;}
	inline void SetManagerSpecialEffect(ExManagerSpecialEffect *SpecialEffect){ManagerSpecialEffect = SpecialEffect;}
	inline void SetManagerPVS(ExManagerPVS *PVS){ManagerPVS = PVS;}
	inline void SetManagerLoad(ExManagerLoad *Load){ManagerLoad = Load;}
	
	void Reset(void);
	void Init(void);
	void DrawScene(void);
	void Reshape(int w,int h);
};
//------------------------------------------------------------------------
#endif //__EXMANAGEROUTPUT_H__
