/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerPVS.cpp,v 1.23 2002/11/24 11:58:58 data Exp $
 *
 */

#include "ExManagerPVS.h"

bool ExManagerPVS::m_flag = false; 
ExManagerPVS* ExManagerPVS::m_instance = NULL; 

ExManagerPVS* ExManagerPVS::CreateSingleton(void){
Guard(ExManagerPVS* ExManagerPVS::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerPVS; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerPVS::ExManagerPVS(void)
{
Guard(ExManagerPVS::ExManagerPVS(void))
UnGuard
}

ExManagerPVS::~ExManagerPVS(void)
{
Guard(ExManagerPVS::~ExManagerPVS(void))
UnGuard
}

void ExManagerPVS::Reset(void)
{
	Init();
}

void ExManagerPVS::Init(void)
{
Guard(ExManagerPVS::Init(void))
UnGuard
}

void ExManagerPVS::Draw(void)
{
Guard(ExManagerPVS::Draw(void))
	m_ViewFrustrum.CalculateFrustum();
	//------------------
	//TO DO
	//Dont call draw methode
	//get pointer of each objet and test if object is in vie frustrum


	ManagerEntity->Draw();
	ManagerMesh->Draw();
UnGuard
}


ExCAction ExManagerPVS::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerPVS::InputCommand(ExCCommand Command))
	return NOTHING;
UnGuard
}

ExCAction ExManagerPVS::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerPVS::InputAction(ExCAction Action))
		switch(Action.m_Action)
	{
		default:
			*Consol<<"Can not file action in PVS_ACTION_MAP"<<std::endl;
			break;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}
