/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerPVS.h											*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :07/15/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERPVS_H__
#define __EXMANAGERPVS_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
#include "Math/ExCFrustum.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerMap.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerCamera.h"
#include "Manager/ManagerObject/ExManagerModele.h"
#include "Manager/ManagerObject/ExManagerGizmo.h"
#include "Manager/ManagerObject/ExManagerParticuleSystem.h"
#include "Manager/ManagerObject/ExManagerLight.h"
#include "Manager/ManagerObject/ExManagerMesh.h"
#include "Manager/ManagerObject/ExManagerEntity.h"
//------------------------------------------------------------------------
class ExManagerPVS  : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerMap				*ManagerMap;
	ExManagerCamera				*ManagerCamera;
	ExManagerModel				*ManagerModel;
	ExManagerGizmo				*ManagerGizmo;
	ExManagerParticuleSystem	*ManagerParticuleSystem;
	ExManagerLight				*ManagerLight;
	ExManagerMesh				*ManagerMesh;
	ExManagerEntity				*ManagerEntity;
	ExCFrustum					m_ViewFrustrum;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerPVS *m_instance;
	ExManagerPVS(void);
	~ExManagerPVS(void);
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerPVS*  CreateSingleton(void);

	inline void SetManagerMesh(ExManagerMesh *Mesh){ManagerMesh = Mesh;}
	inline void SetManagerMap(ExManagerMap *Map){ManagerMap = Map;}
	inline void SetManagerCamera(ExManagerCamera *Cam){ManagerCamera = Cam;}
	inline void SetManagerModel(ExManagerModel *Model){ManagerModel = Model;}
	inline void SetManagerGizmo(ExManagerGizmo *Gizmo){ManagerGizmo = Gizmo;}
	inline void SetManagerParticuleSystem(ExManagerParticuleSystem *ParticuleSystem){ManagerParticuleSystem = ParticuleSystem;}
	inline void SetManagerLight(ExManagerLight *Light){ManagerLight = Light;}
	inline void SetManagerEntity(ExManagerEntity *Entity){ManagerEntity = Entity;}

	void Reset(void);
	void Init(void);
	void Draw(void);

	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERPVS_H__
