/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerSpecialEffect.cpp,v 1.2 2002/11/24 11:58:58 data Exp $
 *
 */
#include "ExManagerSpecialEffect.h"

bool ExManagerSpecialEffect::m_flag = false; 
ExManagerSpecialEffect* ExManagerSpecialEffect::m_instance = NULL; 

ExManagerSpecialEffect* ExManagerSpecialEffect::CreateSingleton(void){
Guard(ExManagerSpecialEffect* ExManagerSpecialEffect::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerSpecialEffect; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerSpecialEffect::ExManagerSpecialEffect(void)
{
}

ExManagerSpecialEffect::~ExManagerSpecialEffect(void)
{
}

void ExManagerSpecialEffect::Reset(void)
{
}

void ExManagerSpecialEffect::Init(void)
{
}

void ExManagerSpecialEffect::Draw(void)
{
	Specialeffect();
}

void ExManagerSpecialEffect::BeforeDraw(void)
{
	switch(m_effect)
	{
	case MOTION_BLUR:
		MotionBlur();
		break;
	}	
}

void ExManagerSpecialEffect::SetAntialliasingState(bool state)
{
Guard(void ExManagerSpecialEffect::SetAntialliasingState(bool state))
	m_Antialliasing=state;
	if(m_Antialliasing)
	{
		glEnable(GL_LINE_SMOOTH);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glHint(GL_LINE_SMOOTH_HINT,GL_DONT_CARE);
	}else
	{
		glDisable(GL_LINE_SMOOTH);
		glDisable(GL_BLEND);
	}
UnGuard
}


void ExManagerSpecialEffect::MotionBlur(void)
{
Guard(void ExManagerSpecialEffect::MotionBlur(void))
	if(!m_MotionBlurTexture)
	{
		// Create a pointer to store the blank image data
		unsigned int *pTexture = NULL;											

		// Allocate and init memory for the image array and point to it from pTexture
		pTexture = new unsigned int [512 * 512 * 3];
		memset(pTexture, 0, 512 * 512 * 3 * sizeof(unsigned int));	

		// Register the texture with OpenGL and bind it to the texture ID
		glGenTextures(1, &TextureMotionBlur);								
		glBindTexture(GL_TEXTURE_2D, TextureMotionBlur);					
		
		// Create the texture and store it on the video card
		glTexImage2D(GL_TEXTURE_2D, 0, 3, 512, 512, 0, GL_RGB, GL_UNSIGNED_INT, pTexture);						
		
		// Set the texture quality
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

		// Since we stored the texture space with OpenGL, we can delete the image data
		delete [] pTexture;							
		m_MotionBlurTexture=true;
	}

	// Push on a new stack so that we do not interfere with the current matrix
	glPushMatrix();

		// Turn off depth testing so that we can blend over the screen
		glDisable(GL_DEPTH_TEST);			

		// Set our blend method and enable blending
		//glBlendFunc(GL_SRC_ALPHA,GL_ONE);	
		//glEnable(GL_BLEND);					

		
		// Decrease the alpha value of the blend by %10 so it will fade nicely
		glColor4f(1, 1, 1, 0.9f);

		// Switch to 2D mode (Ortho mode)
		ExNihilo::EnterOrthoMode();

		// Display a 2D quad with our blended texture
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,TextureMotionBlur);
		glBegin(GL_QUADS);


			// Display the top left point of the 2D image
			glTexCoord2f(0.0f, 1.0f);	glVertex2f(100, 100);

			// Display the bottom left point of the 2D image
			//glTexCoord2f(0.0f, 0.0f);	glVertex2f(0, ExNihilo::GetResolutionY());
			glTexCoord2f(0.0f, 0.0f);	glVertex2f(100, 180);

			// Display the bottom right point of the 2D image
			//glTexCoord2f(1.0f, 0.0f);	glVertex2f(ExNihilo::GetResolutionX(), ExNihilo::GetResolutionY());
			glTexCoord2f(1.0f, 0.0f);	glVertex2f(180, 180);

			// Display the top right point of the 2D image
			//glTexCoord2f(1.0f, 1.0f);	glVertex2f(ExNihilo::GetResolutionX(), 0);
			glTexCoord2f(1.0f, 1.0f);	glVertex2f(180, 100);

		// Stop drawing 
		glEnd();
		glDisable(GL_TEXTURE_2D);
		// Let's set our mode back to perspective 3D mode.
		ExNihilo::LeaveOrthoMode();

		// Turn depth testing back on and texturing off.  If you do NOT do these 2 lines of 
		// code it produces a cool flash effect that might come in handy somewhere down the road.
		glEnable(GL_DEPTH_TEST);						
		glDisable(GL_BLEND);							
		
	// Go back to our original matrix
	glPopMatrix();	
UnGuard
}

void ExManagerSpecialEffect::CapturForMotionBlur(void)
{
Guard(void ExManagerSpecialEffect::CapturForMotionBlur(void))
/*	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,TextureMotionBlur);
	glReadBuffer(GL_FRONT);
	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, 256,256, 0);
*/
	unsigned char * imageData;
	imageData= (unsigned char*) malloc(ExNihilo::GetResolutionX()*ExNihilo::GetResolutionY()*3);
	memset(imageData,255, ExNihilo::GetResolutionX()* ExNihilo::GetResolutionY()* 3);

	glReadBuffer(GL_FRONT);
	glReadPixels(0, 0, ExNihilo::GetResolutionX()- 1, ExNihilo::GetResolutionY()- 1, GL_RGB, GL_UNSIGNED_BYTE, imageData);
	
	// Create the texture and store it on the video card
	glTexImage2D(GL_TEXTURE_2D, 0, 3, ExNihilo::GetResolutionX(), ExNihilo::GetResolutionY(), 0, GL_RGB, GL_UNSIGNED_BYTE, imageData);						

	// Set the texture quality
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);


UnGuard
}

void ExManagerSpecialEffect::Specialeffect(void)
{
	switch(m_effect)
	{
	case FADE_TO_WHITE:		
		glColor4ub(255,255,255, (uchar)m_CouterEffect);
		ExNihilo::EnterOrthoMode();
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		ExNihilo::LeaveOrthoMode();
		m_CouterEffect++;
				
		if(m_CouterEffect>255)
		{
			m_CouterEffect=0;
			m_effect=0;
		}
		break;
	case WITHE_TO_FADE:
		glColor4ub(255,255,255, m_CouterEffect);
		ExNihilo::EnterOrthoMode();
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		ExNihilo::LeaveOrthoMode();
		m_CouterEffect--;
				
		if(m_CouterEffect<1)
		{
			m_CouterEffect=255;
			m_effect=0;
		}
		break;
	case FADE_TO_BLACK:
		glColor4ub(0,0,0, m_CouterEffect);
		ExNihilo::EnterOrthoMode();
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		ExNihilo::LeaveOrthoMode();
		m_CouterEffect++;
				
		if(m_CouterEffect>255)
		{
			m_CouterEffect=0;
			m_effect=0;
		}

		if(m_CouterEffect==230)
		{
			//return end action
			ExCAction Action(LOAD_EXEC_CONFIG_FILE);
			Action.m_Param=" lotr1.exec";
			FluxAction->Push(Action);
		}
		break;
	case BLACK_TO_FADE:
		glColor4ub(0,0,0, m_CouterEffect);
		ExNihilo::EnterOrthoMode();
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), ExNihilo::GetResolutionY());
			glVertex2f(ExNihilo::GetResolutionX(), 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		ExNihilo::LeaveOrthoMode();
		m_CouterEffect--;
				
		if(m_CouterEffect<1)
		{
			m_CouterEffect=255;
			m_effect=0;
		}
		break;
	case MOTION_BLUR:
		CapturForMotionBlur();
		break;
	}
}
void ExManagerSpecialEffect::SetSpecialEffect(int effect)
{
	//std::cout<<"changeefftect"<<std::endl;
	m_effect=effect;
	switch(m_effect)
	{
	case FADE_TO_WHITE:
		m_CouterEffect=0;
		break;
	case WITHE_TO_FADE:
		m_CouterEffect=256;
		break;
	case FADE_TO_BLACK:
		m_CouterEffect=0;
		break;
	case BLACK_TO_FADE:
		m_CouterEffect=256;
		break;
	}
}

ExCAction ExManagerSpecialEffect::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerSpecialEffect::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
	case START_FADE_TO_WHITE:SetSpecialEffect(FADE_TO_WHITE);return NOTHING;
	case STOP_FADE_TO_WHITE:SetSpecialEffect(NO_EFFECT);return NOTHING;
	case START_WITHE_TO_FADE:SetSpecialEffect(WITHE_TO_FADE);return NOTHING;
	case STOP_WITHE_TO_FADE:SetSpecialEffect(NO_EFFECT);return NOTHING;
	case START_FADE_TO_BLACK:SetSpecialEffect(FADE_TO_BLACK);return NOTHING;
	case STOP_FADE_TO_BLACK:SetSpecialEffect(NO_EFFECT);return NOTHING;
	case START_BLACK_TO_FADE:SetSpecialEffect(BLACK_TO_FADE);return NOTHING;
	case STOP_BLACK_TO_FADE:SetSpecialEffect(NO_EFFECT);return NOTHING;
	case START_MOTION_BLUR:SetSpecialEffect(MOTION_BLUR);return NOTHING;
	case STOP_MOTION_BLUR:SetSpecialEffect(NO_EFFECT);return NOTHING;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

ExCAction ExManagerSpecialEffect::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerSpecialEffect::InputCommand(ExCCommand Command))
/*	switch(Command.m_Command)
	{
	}*/
	return NOTHING;
UnGuard
}