/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerSpecialEffect.h								*/
/*																		*/
/* Start Date   :10/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERSPECIALEFFECT_H__
#define __EXMANAGERSPECIALEFFECT_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
//------------------------------------------------------------------------
//Defines
//------------------------------------------------------------------------
#define NO_EFFECT			0
#define FADE_TO_WHITE		1
#define WITHE_TO_FADE		2
#define FADE_TO_BLACK		3
#define BLACK_TO_FADE       4
#define MOTION_BLUR			5
//------------------------------------------------------------------------
class ExManagerSpecialEffect : public ExManager
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	bool			m_Antialliasing;
	bool			m_MotionBlur;
	bool			m_MotionBlurTexture;
	uint			TextureMotionBlur;
	int				m_effect;
	float			m_CouterEffect;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerSpecialEffect *m_instance;
	ExManagerSpecialEffect(void);
	~ExManagerSpecialEffect(void);
public:
	static ExManagerSpecialEffect*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Reset(void);
	void BeforeDraw(void);
	void Draw(void);
	void Init(void);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
	
	void SetAntialliasingState(bool state);
	inline void SetMotionBlurState(bool state){m_MotionBlur=state;}
	inline bool GetAntialliasingState(void){return m_Antialliasing;}
	inline bool GetMotionBlurState(void){return m_MotionBlur;}

	void MotionBlur(void);
	void CapturForMotionBlur(void);
	void Specialeffect(void);
	void SetSpecialEffect(int effect);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERANIMATION_H__
