/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManager.h												*/
/*																		*/
/* Start Date   :04/16/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/
 
#ifndef __EXMANAGERWINDOW_H__
#define __EXMANAGERWINDOW_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
//------------------------------------------------------------------------
class ExManagerWindow   : public ExManager
{
private:
	//------------------------------------------------------------------------
	// Variable
	//------------------------------------------------------------------------
	int			m_WindowHandler;
	int			m_WindowSizeX;
	int			m_WindowSizeY;
	int			m_WindowSizeXOld;
	int			m_WindowSizeYOld;
	int			m_WindowPosX;
	int			m_WindowPosY;
	int			m_Bits;
	int			m_Rate;
	bool		m_FullScreen;
	bool		m_OldMode;
	char		*m_Title;
	char		*m_IconTitle;
	int			m_Cursor;
	bool		m_ShowGrille;
	bool		m_ShowFps;
	int			frame;
	int			timeframe;
	int			timebase;
	char		s[30];
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerWindow *m_instance;
	ExManagerWindow(void);
	~ExManagerWindow(void);
//------------------------------------------------------------------------
public:
	void (*GlutCallBack)();
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void CreateNewWindow(int SizeX,int SizeY,int PosX,int PosY,char *argv);
	void CreateNewWindow(int SizeX,int SizeY,char *argv);
	void Move(int Posx,int Posy);
	void SetResolution(int SizeX,int SizeY);
	inline void SetRate(int Rate){m_Rate=Rate;}
	inline void SetBits(int Bits){m_Bits=Bits;}
	inline void SetFullScreen(bool State){m_FullScreen=State;}
	void SetWindowTitle(char *Title);
	void SetIconTitle(char *Title);
	void SetCursor(int Cursor);
	void Apply(void);

	inline int GetResolutionX(void){return m_WindowSizeX;}
	inline int GetResolutionY(void){return m_WindowSizeY;}
	inline int GetRate(void){return m_Rate;}
	inline int GetBits(void){return m_Bits;}
	inline bool GetFullScreen(void){return m_FullScreen;}
	
	inline void SetGrilleState(bool state){m_ShowGrille=state;}
	inline bool GetGrilleState(void){return m_ShowGrille;}
	inline void SetFpsState(bool state){m_ShowFps=state;}
	inline bool GetFpsState(void){return m_ShowFps;}
	
	void ShowFps(void);
	void ShowNetStat(void);

	void Reset(void){return;}
	static ExManagerWindow*  CreateSingleton(void);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERWINDOW_H__
