/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerAnimation.cpp,v 1.7 2002/09/22 15:54:01 data Exp $
 *
 */
#include "ExManagerAnimation.h"

bool ExManagerAnimation::m_flag = false; 
ExManagerAnimation* ExManagerAnimation::m_instance = NULL; 

ExManagerAnimation* ExManagerAnimation::CreateSingleton(void){
Guard(ExManagerAnimation* ExManagerAnimation::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerAnimation; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerAnimation::ExManagerAnimation(void)
{
Guard(ExManagerAnimation::ExManagerAnimation(void))
UnGuard
}

ExManagerAnimation::~ExManagerAnimation(void)
{
Guard(ExManagerAnimation::~ExManagerAnimation(void))
UnGuard
}

void ExManagerAnimation::Reset(void)
{
Guard(void ExManagerAnimation::Reset(void))
	ExManagerObject<ExCAnimation>::Reset();
UnGuard
}

void ExManagerAnimation::Reload(void)
{
Guard(void ExManagerAnimation::Reload(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.LoadFile(m_ItMap->second.GetFileName());
	}
UnGuard
}

bool ExManagerAnimation::Load(std::string FileName)
{
Guard(void ExManagerAnimation::Load(std::string FileName))
	ExCAnimation Anim;
	Anim.SetManagerCamera(ManagerCamera);
	Anim.SetManagerId(ManagerId);
	Anim.SetManagerModel(ManagerModel);
	Anim.SetManagerEntity(ManagerEntity);
	Anim.LoadFile(FileName);
	//Anim.m_Object=ManagerModel->GetCurrentObject();
	//Anim.m_Object=ManagerCamera->GetCurrentObject();
	return ExManagerObject<ExCAnimation>::Add(Anim);
UnGuard
}


void ExManagerAnimation::Init(void)
{
Guard(void ExManagerAnimation::Init(void))
	ExManagerObject<ExCAnimation>::Init();
	//ExCAnimation Anim1;
	//Anim1.m_Object=ManagerModel->GetCurrentObject();
	//Anim1.m_Object=ManagerCamera->GetCurrentObject();
	//ExManagerObject<ExCAnimation>::Add(Anim1);
UnGuard
}

void ExManagerAnimation::Draw(void)
{
Guard(void ExManagerAnimation::Draw(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Draw();
	}	
UnGuard
}

ExCAction ExManagerAnimation::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerAnimation::InputCommand(ExCCommand Command))
/*	switch(Command.m_Command)
	{
		default :return NOTHING;
	}*/
	return NOTHING;
UnGuard
}

ExCAction ExManagerAnimation::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerAnimation::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
	case MANAGER_ANIMATION_RELOAD:
		Reload();
		*Consol<<"ExManagerAnimation::Reload sucess"<<std::endl;
		break;
	case MANAGER_ANIMATION_PAUSE_ALL_ANIMATION:
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			m_ItMap->second.SetPauseState(true);
		}	
		break;
	case MANAGER_ANIMATION_UNPAUSE_ALL_ANIMATION:
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			m_ItMap->second.SetPauseState(false);
		}	
		break;
	case MANAGER_ANIMATION_TOGGLE_PAUSE_ALL_ANIMATION:
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			m_ItMap->second.SetPauseState(!m_ItMap->second.GetPauseState());
		}	
		break;
	case MANAGER_ANIMATION_PAUSE_ANIMATION:
		GetCurrentObject()->SetPauseState(true);
		break;
	case MANAGER_ANIMATION_UNPAUSE_ANIMATION:
		GetCurrentObject()->SetPauseState(false);
		break;
	case MANAGER_ANIMATION_TOGGLE_ANIMATION:
		GetCurrentObject()->SetPauseState(GetCurrentObject()->GetPauseState());
		break;
	case MANAGER_ANIMATION_SET_CURRENT_OBJECT_BY_ID:
		SetCurrentObject(atoi(Action.m_Param.data()));
		break;
	case MANAGER_ANIMATION_SET_CURRENT_OBJECT_BY_NAME:
		SetCurrentObject(Action.m_Param);
		break;
	default:
		*Consol<<"Can not file action in ANIMATION_ACTION_MAP"<<std::endl;
		return NOTHING;
	}	
	return NOTHING;
UnGuard
}

ExCAnimation* ExManagerAnimation::GetCurrentObject(void)
{
Guard(ExCAnimation* ExManagerAnimation::GetCurrentObject(void))
		return GetObject(m_CurrentObjectId);
UnGuard
}
ExCAnimation * ExManagerAnimation::GetObject(ExNihilo::ExId id)
{
Guard(ExCAnimation *ExManagerAnimation::GetObject(ExNihilo::ExId id))
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			if(m_ItMap->second.GetId()==id)return &m_ItMap->second;
		}
		return NULL;
UnGuard
}