/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerCamera.h										*/
/*																		*/
/* Start Date   :04/20/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERCAMERA_H__
#define __EXMANAGERCAMERA_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerModele.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Camera/ExCCamera.h"
#include "Object/Object3D/Camera/ExCCameraFree.h"
#include "Object/Object3D/Camera/ExCCameraChase.h"
#include "Object/Object3D/Camera/ExCCameraFirst.h"
#include "Object/Object3D/Camera/ExCCameraFlight.h"
//------------------------------------------------------------------------
enum	CameraType
{
	CAMERA_DEFAULT,CAMERA_FREE,CAMERA_CHASE,CAMERA_FIRST,CAMERA_FLIGHT,CAMERA_UNKNOW
};
//------------------------------------------------------------------------
class ExManagerCamera : public ExManagerObject<ExCCamera*> 
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerModel				*ManagerModel;//for chase cam;

//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerCamera *m_instance;
	ExManagerCamera(void);
	~ExManagerCamera(void);
public:
	static ExManagerCamera*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	inline void SetManagerModel(ExManagerModel * Model){ManagerModel = Model;}
	void Reset(void);
	void Init(void);
	void Draw(void);
	void AddCamera(std::string CameraName,CameraType Type);
	
	ExCCamera* GetCurrentObject(void);
	ExCCamera * GetObject(ExNihilo::ExId id);

	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERCAMERA_H__

