/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerEntity.h										*/
/*																		*/
/* Star Date   :28/09/2003												*/
/*																		*/
/* Last Update :28/09/2003			                                    */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERENITY_H__
#define __EXMANAGERENITY_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerMesh.h"
#include "Manager/ManagerObject/ExManagerGizmo.h"
#include "Manager/ManagerObject/ExManagerModele.h"//TO DO remove this one en use only mesh
//------------------------------------------------------------------------
#include "Object/ExCEntity.h"
#include "Object/ExCGroupEntity.h"
//------------------------------------------------------------------------
enum EntityType
{
	ENTITY,
	ENTITY_GROUP,
	ENTITY_UNKNOWN
};
struct Groupe
{
	ExCEntity PropGroupe;
	std::vector<ExCEntity *>	m_VecEntity;
	int							m_NumberEntity;
};
class ExManagerEntity  : public ExManagerObject<ExCEntity *>
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerMesh					*ManagerMesh;
	ExManagerGizmo					*ManagerGizmo;
	ExManagerModel					*ManagerModel;//TO DO remove this one en use only mesh
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerEntity *m_instance;
	ExManagerEntity(void);
	~ExManagerEntity(void);
	EntityType GetEntityType(std::string FileName);

	std::vector<Groupe>	m_VecGroupe;
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerEntity*  CreateSingleton(void);
	void Reset(void);
	void Reload(void);
	void Init(void);
	void Draw(void);
	void Load(std::string FileName);
	void LoadGroupe(std::string FileName);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);

	inline void SetManagerMesh(ExManagerMesh * Mesh){ManagerMesh = Mesh;}
	inline void SetManagerGizmo(ExManagerGizmo * Gizmo){ManagerGizmo = Gizmo;}
	inline void SetManagerModel(ExManagerModel * Model){ManagerModel = Model;}//TO DO remove this one en use only mesh

	ExCEntity * GetObject(ExNihilo::ExId id);
	ExCEntity * GetCurrentObject();
};
//------------------------------------------------------------------------
#endif //__EXMANAGERENITY_H__
