/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerInterface.cpp,v 1.14 2002/12/08 17:57:06 data Exp $
 *
 */

#include "ExManagerInterface.h"

bool ExManagerInterface::m_flag = false; 
ExManagerInterface* ExManagerInterface::m_instance = NULL; 

ExManagerInterface* ExManagerInterface::CreateSingleton(void){
Guard(ExManagerInterface* ExManagerInterface::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerInterface; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerInterface::ExManagerInterface(void)
{
	m_AllDisable=false;	
}

ExManagerInterface::~ExManagerInterface(void)
{
}

void ExManagerInterface::Reset(void)
{
Guard(void ExManagerInterface::Reset(void))
	ExManagerObject<ExCInterface>::Reset();
UnGuard
}

void ExManagerInterface::Init(void)
{
Guard(void ExManagerInterface::Init(void))
	ExManagerObject<ExCInterface>::Init();
	SetStatus(true);
UnGuard
}

bool ExManagerInterface::Load(std::string FileName)
{
Guard(bool ExManagerInterface::Load(std::string FileName))
	ExCInterface Inter;
	Inter.SetManagerTexture(ManagerTexture);
	Inter.Consol=Consol;
	if(Inter.LoadFile(FileName))
	{
		SetCurrentObject(Inter.GetName());
		Add(Inter);
		return true;
	}
	return false;
UnGuard
}

void ExManagerInterface::Draw(void)
{
Guard(void ExManagerInterface::Draw(void))
	if(!GetStatus())return;
	if(m_AllDisable)return;
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Draw();
	}
UnGuard
}

void ExManagerInterface::ShowRegion(void)
{
Guard(void ExManagerInterface::ShowRegion(void))
	GetCurrentObject()->ShowRegion();
UnGuard
}

void ExManagerInterface::HideRegion(void)
{
Guard(void ExManagerInterface::HideRegion(void))
	GetCurrentObject()->HideRegion();
UnGuard
}

ExCAction ExManagerInterface::InputCommand(int command,int mousex,int mousey)
{
Guard(int ExManagerInterface::InputCommand(int command,int mousex,int mousey))
/*	if(GetCurrentObject()->GetInterfaceState())
	{
		return GetCurrentObject()->InputCommand(command,mousex,mousey);
	}*/
	return NOTHING;
UnGuard
}

int ExManagerInterface::EnableInterface(std::string param)
{
Guard(int ExManagerInterface::EnableInterface(std::string param))
	SetCurrentObject(param);
	GetCurrentObject()->EnableInterface();
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::DisableInterface(std::string param)
{
Guard(int ExManagerInterface::DisableInterface(std::string param))
	SetCurrentObject(param);
	GetCurrentObject()->EnableInterface();
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::EnableAllInterface(void)
{
Guard(int ExManagerInterface::EnableAllInterface(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.EnableInterface();
	}
	m_AllDisable=false;	
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::DisableAllInterface(void)
{
Guard(int ExManagerInterface::DisableAllInterface(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.DisableInterface();
	}
	m_AllDisable=true;	
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::GetNumberEnableInterface(void)
{
Guard(int ExManagerInterface::GetNumberEnableInterface(void))
	int ret=0;
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
			if(m_ItMap->second.GetInterfaceState())ret++;
	}
	return ret;
UnGuard
}

ExCAction ExManagerInterface::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerInterface::InputCommand(ExCCommand Command))
	return NOTHING;
UnGuard
}
ExCAction ExManagerInterface::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerInterface::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
	case ENABLE_INTERFACE:EnableInterface(Action.m_Param);break;
	case DISABLE_INTERFACE:DisableInterface(Action.m_Param);break;
	case ENABLE_ALL_INTERFACE:EnableAllInterface();break;
	case DISABLE_ALL_INTERFACE:DisableAllInterface();break;
	case LIST_INTERFACE:List();	break;
	case ADD_INTERFACE:Load(Action.m_Param);break;
	case SHOW_INTERFACE_REGION:ShowRegion();break;
	case HIDE_INTERFACE_REGION:HideRegion();break;
	default:
		*Consol<<"Can not file action in INTERFACE_ACTION_MAP"<<std::endl;
		break;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

