/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :InputActionList.h										*/
/*																		*/
/* Start Date  :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERINTERFACE_H__
#define __EXMANAGERINTERFACE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExCCommand.h"
#include "ExCAction.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object2D/ExCInterface.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ManagerObject/ExManagerObject.h"
//------------------------------------------------------------------------
class ExManagerInterface : public ExManagerObject<ExCInterface> 
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerTexture	*ManagerTexture;
	bool				m_AllDisable;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerInterface *m_instance;
	ExManagerInterface(void);
	~ExManagerInterface(void);
public:
	static ExManagerInterface*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}

	void ShowRegion(void);
	void HideRegion(void);

	void Init(void);
	void Reset(void);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
    void Draw(void);
	bool Load(std::string FileName);

	ExCAction InputCommand(int command,int mousex,int mousey);
	
	int EnableInterface(std::string param);
	int DisableInterface(std::string param);
	int EnableAllInterface(void);
	int DisableAllInterface(void);
	int GetNumberEnableInterface(void);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERINTERFACE_H__
