/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerLight.cpp,v 1.9 2002/09/22 15:54:04 data Exp $
 *
 */

#include "ExManagerLight.h"

bool ExManagerLight::m_flag = false; 
ExManagerLight* ExManagerLight::m_instance = NULL; 

ExManagerLight* ExManagerLight::CreateSingleton(void){
Guard(ExManagerLight* ExManagerLight::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerLight; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerLight::ExManagerLight(void)
{
Guard(ExManagerLight::ExManagerLight(void))
UnGuard
}


ExManagerLight::~ExManagerLight(void)
{
Guard(ExManagerLight::~ExManagerLight(void))
UnGuard
}


void  ExManagerLight::Reset(void)
{
Guard(void  ExManagerLight::Reset(void))
	ExManagerObject<ExCLight>::Reset();
UnGuard
}


void  ExManagerLight::Init(void)
{
Guard(void  ExManagerLight::Init(void))
	ExManagerObject<ExCLight>::Init();
	//ExCLight Light;
	//ExManagerObject<ExCLight>::Add(Light);
UnGuard
}

void  ExManagerLight::Draw(void)
{
Guard(void  ExManagerLight::Draw(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Draw();
	}
UnGuard
}