/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerLoad.h											*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERLoad_H__
#define __EXMANAGERLoad_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManager.h"
#include "Manager/ExManagerConsole.h"
#include "Manager/ExManagerSpecialEffect.h"
#include "Manager/ExManagerMap.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerInterface.h"
#include "Manager/ManagerObject/ExManagerSpirit.h"
#include "Manager/ManagerObject/ExManagerAnimation.h"
#include "Manager/ManagerObject/ExManagerCamera.h"
#include "Manager/ManagerObject/ExManagerModele.h"
#include "Manager/ManagerObject/ExManagerGizmo.h"
#include "Manager/ManagerObject/ExManagerParticuleSystem.h"
#include "Manager/ManagerObject/ExManagerLight.h"
#include "Manager/ManagerObject/ExManagerVertexProgram.h"
#include "Manager/ManagerObject/ExManagerObjectWindow.h"
#include "Manager/ManagerObject/ExManagerMesh.h"
#include "Manager/ManagerObject/ExManagerSound.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ManagerObject/ExManagerEntity.h"
//------------------------------------------------------------------------
#include "Object/Object2D/ExCLoadingAnimation.h"
//------------------------------------------------------------------------
enum FileType
{
	FILE_CONSOL,//.csl
	FILE_COMMAND,//.comd .exec 
	FILE_SET,//.set
	FILE_SOUND,//.wav .mid . mp3
	FILE_MODEL,//.asc .ase .3ds .md2 .md3 .exm .obj
	FILE_MAP,//.map .bsp .hgmp .skyb
	FILE_PARTICUL,//.part
	FILE_WINDOW,//.exw
	FILE_INTERFACE,//.int
	FILE_TEXTURE,//.bmp .tga .pcx .jpg .rgb .raw .ppm .dds
	FILE_LOADING_ANIMATION,//.lanim
	FILE_MESH,//.Mesh
	FILE_ANIMATION,//.anim
	FILE_ENTITY,//.ent
	FILE_UNKNOWN_TYPE
};
//------------------------------------------------------------------------
class ExManagerLoad  : public ExManagerObject<ExCLoadingAnimation> 
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerAnimation			*ManagerAnimation;
	ExManagerWindow				*ManagerWindow;
	ExManagerConsole			*ManagerConsole;
	ExManagerInterface			*ManagerInterface;
	ExManagerSpirit				*ManagerSpirit;
	ExManagerMap				*ManagerMap;
	ExManagerCamera				*ManagerCamera;
	ExManagerModel				*ManagerModel;
	ExManagerGizmo				*ManagerGizmo;
	ExManagerParticuleSystem	*ManagerParticuleSystem;
	ExManagerLight				*ManagerLight;
	ExManagerVertexProgram		*ManagerVertexProgram;
	ExManagerObjectWindow		*ManagerObjectWindow;
	ExManagerSpecialEffect		*ManagerSpecialEffect;
	ExManagerMesh				*ManagerMesh;
	ExManagerSound				*ManagerSound;
	ExManagerTexture			*ManagerTexture;
	ExManagerEntity				*ManagerEntity;


	std::string					m_EntityFilePath;
//------------------------------------------------------------------------
	FileType GetFileType(std::string FileName);
	bool							m_Loading;
	bool							m_Draw;

	std::vector<std::string>		m_VecFileToLoad;
	int								m_CurrentFileLoading;

	ExCLoadingAnimation				*m_CurrentLoadingAniamtion;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerLoad *m_instance;
	ExManagerLoad(void);
	~ExManagerLoad(void);
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerLoad*  CreateSingleton(void);

	inline void SetManagerAnim(ExManagerAnimation *Anim){ManagerAnimation = Anim;}
	inline void SetManagerConsole(ExManagerConsole * Console){ManagerConsole=Console;}
	inline void SetManagerInterface(ExManagerInterface * Interface){ManagerInterface=Interface;}
	inline void SetManagerSpirit(ExManagerSpirit * Spirit){ManagerSpirit=Spirit;}
	inline void SetManagerMap(ExManagerMap *Map){ManagerMap = Map;}
	inline void SetManagerCamera(ExManagerCamera *Cam){ManagerCamera = Cam;}
	inline void SetManagerModel(ExManagerModel *Model){ManagerModel = Model;}
	inline void SetManagerGizmo(ExManagerGizmo *Gizmo){ManagerGizmo = Gizmo;}
	inline void SetManagerParticuleSystem(ExManagerParticuleSystem *ParticuleSystem){ManagerParticuleSystem = ParticuleSystem;}
	inline void SetManagerLight(ExManagerLight *Light){ManagerLight = Light;}
	inline void SetManagerVertexProgram(ExManagerVertexProgram *VertexProgram){ManagerVertexProgram = VertexProgram;}
	inline void SetManagerObjectWindow(ExManagerObjectWindow *ObjectWindow){ManagerObjectWindow = ObjectWindow;}
	inline void SetManagerSpecialEffect(ExManagerSpecialEffect *SpecialEffect){ManagerSpecialEffect = SpecialEffect;}
	inline void SetManagerMesh(ExManagerMesh *Mesh){ManagerMesh = Mesh;}
	inline void SetManagerSound(ExManagerSound * Sound){ManagerSound=Sound;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	inline void SetManagerEntity(ExManagerEntity * Entity){ManagerEntity=Entity;}

	void Reset(void);
	void Init(void);
	void Load(std::string FileName);
	void LoadAnimationFile(std::string FileName);
	void LoadSetOfFile(std::string FileName);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);

	void DisplayFileType(void);
	void Draw(void);
	void DrawInAnimation(void);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERLoad_H__
