/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerMesh.cpp,v 1.9 2002/12/03 22:40:03 data Exp $
 *
 */

#include "ExManagerMesh.h"

bool ExManagerMesh::m_flag = false; 
ExManagerMesh* ExManagerMesh::m_instance = NULL; 

ExManagerMesh* ExManagerMesh::CreateSingleton(void){
Guard(ExManagerMesh* ExManagerMesh::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerMesh; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerMesh::ExManagerMesh(void)
{
}

ExManagerMesh::~ExManagerMesh(void)
{
}

void ExManagerMesh::Reset(void)
{
	ExManagerObject<ExCMesh *>::Reset();
}

void ExManagerMesh::Init(void)
{
Guard(void ExManagerMesh::Init(void))
	ExManagerObject<ExCMesh *>::Init();

UnGuard
}

void ExManagerMesh::Draw(void)
{
	//Draw here only if PVS is not active
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second->Draw();
	}
}


MeshType ExManagerMesh::GetMeshType(std::string FileName)
{
Guard(MeshType ExManagerMesh::GetMeshType(std::string FileName))
	std::string buffstring;
	buffstring=ExNihilo::ExtracStringValueFromFile("../Data/Mesh/"+FileName,"<Type>","<#Type>");
	if(strcmpi(buffstring.data(),"ExCMeshFireEffect")==0)return MESH_FIRE_EFFECT;
	if(strcmpi(buffstring.data(),"ExCMeshWaterEffect")==0)return MESH_WATER_EFFECT;
	if(strcmpi(buffstring.data(),"ExCMeshSummonCylenderEffect")==0)return MESH_SUMMON_CYLENDER_EFFECT;
	if(strcmpi(buffstring.data(),"ExCMeshSmogEffect")==0)return MESH_SMOG_EFFECT;
	if(strcmpi(buffstring.data(),"ExCMeshWaterDisqueEffect")==0)return MESH_WATER_DISQUE_EFFECT;
	if(strcmpi(buffstring.data(),"ExCMeshLOD3ds")==0)return MESH_LOD_3DS;
	if(strcmpi(buffstring.data(),"ExCMeshSauronEffect")==0)return MESH_SAURON_EFFECT;
	if(strcmpi(buffstring.data(),"ExCMesh3ds")==0)return MESH_3DS;
	if(strcmpi(buffstring.data(),"ExCMeshBilboarded")==0)return MESH_BILBOARDED;
	return MESH_UNKNOWN;
UnGuard
}

ExNihilo::ExId ExManagerMesh::Load(std::string FileName)
{
Guard(ExNihilo::ExManagerMesh::Load(std::string FileName))
	//std::cout<<"Load file:"<<FileName<<std::endl;
	//Check if model already loaded
	try
	{
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			if(strcmp(m_ItMap->second->GetName().data(),FileName.data())==0)
			{
				return m_ItMap->second->GetId();
			}
		}  
	}catch(...){}
	ExCMesh *Mesh;
	switch(GetMeshType(FileName))
	{
	case MESH_FIRE_EFFECT:Mesh = new ExCMeshFireEffect;break;
	case MESH_WATER_EFFECT:Mesh = new ExCMeshWaterEffect;break;
	case MESH_SUMMON_CYLENDER_EFFECT:Mesh = new ExCMeshSummonCylenderEffect;break;
	case MESH_SMOG_EFFECT:Mesh = new ExCMeshSmogEffect;break;
	case MESH_WATER_DISQUE_EFFECT:Mesh = new ExCMeshWaterDisqueEffect;break;
	case MESH_SAURON_EFFECT:Mesh = new ExCMeshSauronEffect;break;
	case MESH_LOD_3DS:Mesh = new ExCMeshLOD3ds;break;
	case MESH_3DS:
		Mesh = new ExCMesh3ds;
		((ExCMesh3ds *)Mesh)->SetManagerModel(ManagerModel);
		((ExCMesh3ds *)Mesh)->SetManagerId(ManagerId);
		break;
	case MESH_BILBOARDED:
		Mesh = new ExCMeshBilboarded;
		break;
	}
	
	Mesh->SetName(FileName);
	Mesh->SetManagerTexture(ManagerTexture);
	Mesh->Load(FileName);
	Add(Mesh);
	return Mesh->GetId();
UnGuard
}

ExNihilo::ExId ExManagerMesh::Load(std::string FileName,std::string ObjectName)
{
Guard(ExNihilo::ExId ExManagerMesh::Load(std::string FileName,std::string ObjectName))

UnGuard
}

ExCAction ExManagerMesh::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerMesh::InputCommand(ExCCommand Command))
		return NOTHING;
UnGuard
}

ExCAction ExManagerMesh::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerMesh::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
		default:
			*Consol<<"Can not file action in MESH_ACTION_MAP"<<std::endl;
			break;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

ExCMesh * ExManagerMesh::GetObject(ExNihilo::ExId id)
{
	Guard(ExCMesh *ExManagerMesh::GetObject(ExNihilo::ExId id))
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			if(m_ItMap->second->GetId()==id)return m_ItMap->second;
		}
		return NULL;
		UnGuard
}