/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerMesh.h											*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :07/15/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/
class ExManagerMesh;

#ifndef __EXMANAGERMESH_H__
#define __EXMANAGERMESH_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ManagerObject/ExManagerModele.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Mesh/ExCMesh.h"
#include "Object/Object3D/Mesh/ExCMeshFireEffect.h"
#include "Object/Object3D/Mesh/ExCMeshWaterEffect.h"
#include "Object/Object3D/Mesh/ExCMeshSummonCylenderEffect.h"
#include "Object/Object3D/Mesh/ExCMeshSmogEffect.h"
#include "Object/Object3D/Mesh/ExCMeshWaterDisqueEffect.h"
#include "Object/Object3D/Mesh/ExCMeshLOD3ds.h"
#include "Object/Object3D/Mesh/ExCMeshSauronEffect.h"
#include "Object/Object3D/Mesh/ExCMesh3ds.h"
#include "Object/Object3D/Mesh/ExCMeshBilboarded.h"
//------------------------------------------------------------------------
enum MeshType
{
	MESH_FIRE_EFFECT,
	MESH_WATER_EFFECT,
	MESH_SUMMON_CYLENDER_EFFECT,
	MESH_SMOG_EFFECT,
	MESH_WATER_DISQUE_EFFECT,
	MESH_LOD_3DS,
	MESH_SAURON_EFFECT,
	MESH_3DS,
	MESH_BILBOARDED,
	MESH_UNKNOWN
};
//------------------------------------------------------------------------

class ExManagerMesh  : public ExManagerObject<ExCMesh *>
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerTexture			*ManagerTexture;
	ExManagerModel				*ManagerModel;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerMesh *m_instance;
	ExManagerMesh(void);
	~ExManagerMesh(void);
//------------------------------------------------------------------------
	MeshType GetMeshType(std::string FileName);
public:
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	static ExManagerMesh*  CreateSingleton(void);
	void Reset(void);
	void Init(void);
	void Draw(void);
	ExNihilo::ExId Load(std::string FileName);
	ExNihilo::ExId Load(std::string FileName,std::string ObjectName);

	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerModel(ExManagerModel *Model){ManagerModel = Model;}
	ExCMesh * GetObject(ExNihilo::ExId id);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERMESH_H__
