/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExManagerObjectWindow.h"

bool ExManagerObjectWindow::m_flag = false; 
ExManagerObjectWindow* ExManagerObjectWindow::m_instance = NULL; 

ExManagerObjectWindow* ExManagerObjectWindow::CreateSingleton(void){
Guard(ExManagerObjectWindow* ExManagerObjectWindow::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerObjectWindow; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerObjectWindow::ExManagerObjectWindow(void)
{
Guard(ExManagerObjectWindow::ExManagerObjectWindow(void))
	
UnGuard
}


ExManagerObjectWindow::~ExManagerObjectWindow(void)
{
Guard(ExManagerObjectWindow::~ExManagerObjectWindow(void))
UnGuard
}


void  ExManagerObjectWindow::Reset(void)
{
Guard(void  ExManagerObjectWindow::Reset(void))
	ExManagerObject<ExCWindow>::Reset();
	Load("WindowMainMenu.ExW");
	//Load("wlotr.ExW");
	m_DrawAllWindow=true;
UnGuard
}


void  ExManagerObjectWindow::Init(void)
{
Guard(void  ExManagerObjectWindow::Init(void))
	SetStatus(true);
	SetAskForCommand(true);
	SetAskForExclusifCommand(false);
	ExManagerObject<ExCWindow>::Init();

/*	ExCWindow Win2(ExCVec2D(600,300),ExCVec2D(200,350),"TEST2");
	Win2.SetManagerTexture(ManagerTexture);
	Win2.SetManagerWindow(ManagerWindow);
	Win2.GetWindowContentPointer()->SetBackroundTexturing1(true,"earth.bmp");
	Win2.GetWindowContentPointer()->SetBackroundTexturing2(true,"fog.bmp");
	ExManagerObject<ExCWindow>::Add(Win2);
	*/
	Load("WindowMainMenu.ExW");
	//Load("wlotr.ExW");

	m_MoveWindow=false;
	ModalWindow=NULL;
	m_SizeWhenMinimized=150;
	m_DrawAllWindow=true;
UnGuard
}

void  ExManagerObjectWindow::Draw(void)
{
Guard(void  ExManagerObjectWindow::Draw(void))
glPushAttrib(GL_ALL_ATTRIB_BITS);	
glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
	if(m_DrawAllWindow)
	{
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			if(!m_ItMap->second.IsActive())
			{
				m_ItMap->second.Draw();
			}
		}
		if(m_CurrentObjectId!=-1)GetCurrentObject()->Draw();
	}
	if(ModalWindow!=NULL)
	{
		ModalWindow->Draw();
		if(ModalWindow->m_BeClosed)
		{
			delete ModalWindow;
			ModalWindow=NULL;
		}
	}
glPopAttrib();
	
UnGuard
}

ExCAction ExManagerObjectWindow::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerObjectWindow::InputCommand(ExCCommand Command))
	//std::cout<<"ExManagerObjectWindow::Input Command window:"<<Command.m_Command<<std::endl;
	if(ModalWindow!=NULL)
	{
		return InputAction(ModalWindow->InputCommand(Command));
	}
		
	m_LastCommandReceived=Command;
	switch(Command.m_Command)
	{
	/*case MOUSE_RIGHT_BUTTON_DOWN:
		m_DrawAllWindow ? m_DrawAllWindow=false :m_DrawAllWindow=true;
	break;*/
	case MOUSE_LEFT_BUTTON_DOWN:
	//Search for the good window to activate
		if(!m_DrawAllWindow) return NOTHING;
		if(m_CurrentObjectId!=-1)
		{
			if(GetCurrentObject()->PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))break;
		}
		for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
		{
			if(m_ItMap->second.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
			{
				
				//if(!GetCurrentObject()->PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
				//{
					if(m_CurrentObjectId!=-1)GetCurrentObject()->SetActive(false);
					SetCurrentObject(m_ItMap->second.GetId());
					GetCurrentObject()->SetActive(true);
				//}
			}
		}
		break;
	case MOUSE_LEFT_BUTTON_UP:
		if(m_MoveWindow)
		{
			GetCurrentObject()->SetWindowPosition(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)-m_MovePointerShift);
			m_MoveWindow=false;
		}
	case MOUSE_MOTION:
		if(m_MoveWindow)
		{
			GetCurrentObject()->SetWindowPosition(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)-m_MovePointerShift);
			
		}
		break;
	}
	//find the correct window to send the message
	if(m_CurrentObjectId==-1)return NOTHING;//there is no active window
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		if(m_ItMap->second.IsActive())
		{
			if(m_ItMap->second.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
			{
				return InputAction(m_ItMap->second.InputCommand(Command));
			}
		}
	}
	

	return NOTHING;
UnGuard
}

void ExManagerObjectWindow::OrganizeMinimizedWindow(void)
{
Guard(void ExManagerObjectWindow::OrganizeMinimizedWindow(void))
	int couterx=0,coutery=1;
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		if(m_ItMap->second.IsReduced())
		{
			m_ItMap->second.SetWindowSize(ExCVec2D((ManagerWindow->GetResolutionX()/(ManagerWindow->GetResolutionX()/m_SizeWhenMinimized)),GetCurrentObject()->GetTitleBarSize()));
			m_ItMap->second.SetWindowPosition(ExCVec2D((ManagerWindow->GetResolutionX()/(ManagerWindow->GetResolutionX()/m_SizeWhenMinimized))*couterx-1,(ManagerWindow->GetResolutionY()-(GetCurrentObject()->GetTitleBarSize()*coutery-1))));	
			couterx++;
		}
		if(couterx>=(ManagerWindow->GetResolutionX()/m_SizeWhenMinimized)-1)
		{
			couterx=0;
			coutery++;
		}
	}
UnGuard
}


ExCAction ExManagerObjectWindow::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerObjectWindow::InputAction(ExCAction Action))
	//std::cout<<"Receive action :"<<Action<<std::endl;
	ExCVec2D TmpSize,TmpPos;
	switch(Action.m_Action)
    {
	case CLOSE_OBJECT_WINDOW:
		if(ModalWindow!=NULL)
		{
			delete ModalWindow;
			ModalWindow=NULL;
			return NOTHING;
		}
		//check were we are are (button) bar window content
		if(m_CurrentObjectId==-1) return NOTHING;
		std::cout<<"Close window id:"<<m_CurrentObjectId<<std::endl;
		if(RemoveCurrentObject())
		{
			std::cout<<"Close window succes"<<std::endl;
		}else std::cout<<"Close window fail"<<std::endl;
		return NOTHING;	

	case MINIMIZE_OBJECT_WINDOW:
		//std::cout<<"Minimize window id:"<<m_CurrentObjectId<<std::endl;
		
		if(!GetCurrentObject()->IsReduced())
		{
			if(!GetCurrentObject()->IsMaximized())
			{
				GetCurrentObject()->SetOldWindowSize(GetCurrentObject()->GetWindowSize());
				GetCurrentObject()->SetOldPosition(GetCurrentObject()->GetPosition());
			}
			if(GetCurrentObject()->IsShowWindowContent())
			{
				//GetCurrentObject()->SetShowWindowContent(false);
			}
			GetCurrentObject()->SetReduced(true);
			GetCurrentObject()->SetWindowOldTitle(GetCurrentObject()->GetWindowTitle());
			std::string ShortName(GetCurrentObject()->GetWindowTitle());
			ShortName.resize(10);
			ShortName.replace(6,4,"...");
			GetCurrentObject()->SetWindowTitle(ShortName);
			OrganizeMinimizedWindow();
		}else
		{
			GetCurrentObject()->SetWindowSize(ExCVec2D(GetCurrentObject()->GetOldWindowSize()));
			GetCurrentObject()->SetWindowPosition(ExCVec2D(GetCurrentObject()->GetOldPosition()));
			GetCurrentObject()->SetWindowTitle(GetCurrentObject()->GetWindowOldTitle());
			GetCurrentObject()->SetReduced(false);
			if(!GetCurrentObject()->IsShowWindowContent())
			{
				GetCurrentObject()->SetShowWindowContent(true);
			}
		}
		
		return NOTHING;
	case MAXIMIZE_OBJECT_WINDOW:
		//std::cout<<"MAximize window id:"<<m_CurrentObjectId<<std::endl;
		if(!GetCurrentObject()->IsMaximized())
		{
			if(!GetCurrentObject()->IsReduced())
			{
				GetCurrentObject()->SetOldWindowSize(GetCurrentObject()->GetWindowSize());
				GetCurrentObject()->SetOldPosition(GetCurrentObject()->GetPosition());
			}
			GetCurrentObject()->SetWindowSize(ExCVec2D(ManagerWindow->GetResolutionX(),ManagerWindow->GetResolutionY()));
			GetCurrentObject()->SetWindowPosition(ExCVec2D(0,0));
			GetCurrentObject()->SetMaximized(true);
			if(!GetCurrentObject()->IsShowWindowContent())
			{
				GetCurrentObject()->SetShowWindowContent(true);
			}
			break;
		}else
		{
			GetCurrentObject()->SetWindowSize(ExCVec2D(GetCurrentObject()->GetOldWindowSize()));
			GetCurrentObject()->SetWindowPosition(ExCVec2D(GetCurrentObject()->GetOldPosition()));
			GetCurrentObject()->SetMaximized(false);
		}
		return NOTHING;
	case MINIMIZE_TO_BAR_OBJECT_WINDOW:
		//std::cout<<"Minimize to bar window id:"<<m_CurrentObjectId<<std::endl;
		if(GetCurrentObject()->IsShowWindowContent())
		{
		//GetCurrentObject()->SetShowWindowContent(false);
		}else GetCurrentObject()->SetShowWindowContent(true);
		return NOTHING;
	case MOUVE_OBJECT_WINDOW:
		std::cout<<"Move window:"<<m_CurrentObjectId<<std::endl;
		m_MovePointerShift=((ExCVec2D(m_LastCommandReceived.m_MousePosx,m_LastCommandReceived.m_MousePosy)-GetCurrentObject()->GetPosition()));
		m_MoveWindow=true;
		return NOTHING;
	case MESSAGE_BOX:
		ModalWindow= new ExCWindowMessageBox(Action.m_Param);
		ModalWindow->SetManagerTexture(ManagerTexture);
		ModalWindow->SetManagerWindow(ManagerWindow);
		break;
	case MESSAGE_BOX_QUESTION:
		ModalWindow= new ExCWindowMessageBoxQuestion(Action.m_Param,Action.GetParamAsInt(1),Action.GetParamAsInt(2));
		ModalWindow->SetManagerTexture(ManagerTexture);
		ModalWindow->SetManagerWindow(ManagerWindow);
		break;
	case LOAD_OBJECT_WINDOW:
		Load(Action.m_Param);
		/*m_ItMap=m_Map->end();
		if(m_CurrentObjectId!=-1)
		GetCurrentObject()->SetActive(false);
		SetCurrentObject(m_ItMap->second.GetId());
		//GetCurrentObject()->SetActive(true);
		std::cout<<"plok"<<std::endl;*/
		break;
	case ENABLE_WINDOW:
		m_DrawAllWindow=true;
		if(m_Map->size()==0)Load("WindowMainMenu.ExW");
		//if(m_Map->size()==0)Load("wlotr.ExW");
		break;
	case DISABLE_WINDOW:
		m_DrawAllWindow=false;
		break;
	case TOGGLE_WINDOW:
		m_DrawAllWindow ? m_DrawAllWindow=false :m_DrawAllWindow=true;
		break;
	default:
		return Action;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

bool ExManagerObjectWindow::SetCurrentObject(ExNihilo::ExId id)
{
Guard(bool ExManagerObjectWindow::SetCurrentObject(ExNihilo::ExId id))
	ExManagerObject<ExCWindow>::SetCurrentObject(id);	
	GetCurrentObject()->SetActive(true);
	return true;
UnGuard
}

bool ExManagerObjectWindow::Load(std::string FileName)
{
Guard(bool ExManagerObjectWindow::Load(std::string FileName))
	//std::cout<<"Load:"<<FileName<<std::endl;
	char			buffer[255],b[255];
	std::string buffstring;
	std::ifstream file,fileControl;
	#ifdef UNIX_SRC
		sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
		sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif

	ExCWindow NewWindow;
	file.open(buffer,std::ios::in);
	if(file.is_open())
	{
		//read header 
		memset(b,0,255);file.getline(b,256,'\n');
		try
		{
			//READ MAIN WINDOW INFO
			ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
			ReadWindowObject(&NewWindow,&file);
			//READ CONTENT WINDOW INFO
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForWindow>","<#FileForWindow>");
			ReadWindowSubObject(&NewWindow,buffstring);
			//READ BAR WINDOW INFO
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForBar>","<#FileForBar>");
			ReadWindowSubObject(&NewWindow,buffstring);

		}catch(ExCExpStringNotFound){std::cout<<"Bad file type plok"<<buffer<<std::endl;}
	}else
	{
		std::cout<<"a pouet"<<buffer<<std::endl;
		throw   ExCExpFileNotFound();
	}
	file.close();
    NewWindow.RefreshPosotion();
	NewWindow.RefreshSize();
	NewWindow.SetManagerTexture(ManagerTexture);
	NewWindow.SetManagerWindow(ManagerWindow);
	ExManagerObject<ExCWindow>::Add(NewWindow);
	/*m_ItMap=m_Map->end();
	m_ItMap--;
	SetCurrentObject(m_ItMap->second.GetId());
	GetCurrentObject()->SetActive(true);*/
	/*ExCCommand Command;
	Command.m_MousePosx=NewWindow.GetPosition().GetX()+5;
	Command.m_MousePosy=NewWindow.GetPosition().GetY()+5;
	Command.m_Command=MOUSE_LEFT_BUTTON_DOWN;
	InputCommand(Command);*/
	return true;
UnGuard
}

void ExManagerObjectWindow::ReadWindowSubObject(ExCWindow *win,std::string FileName)
{
Guard(void ExManagerObjectWindow::ReadWindowSubObject(ExCWindow *win,std::string FileName))
	char			buffer[255],b[255];
	std::string buffstring;
	std::ifstream file,fileButton,fileControl;
	#ifdef UNIX_SRC
		sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
		sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif
	//std::cout<<buffer<<std::endl;
	file.open(buffer,std::ios::in);

	if(file.is_open())
	{
		//read header 
		memset(b,0,255);file.getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
			if(strcmp(buffstring.data(),"WindowContent")==0)
			{
				ReadWindowObject(win->GetWindowContentPointer(),&file);	
				//Read all control
				memset(b,0,255);file.getline(b,256,'\n');
				int numberofcontrol=ExNihilo::ExtractIntValueFromSring(b,"<NumberOfControl>","<#NumberOfControl>");
				for(int i=0;i<numberofcontrol;i++)
				{
					memset(b,0,255);file.getline(b,256,'\n');
					ReadWindowControlObject(win->GetWindowContentPointer(),ExNihilo::ExtracValueFromSring(b,"<FileControl>","<#FileControl>"));
				}
			}
			if(strcmp(buffstring.data(),"BarContent")==0)
			{
				ReadWindowObject(win->GetWindowBarPointer(),&file);	
				//READ CLOSE BUTTON
				memset(b,0,255);file.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonClose>","<#FileForButtonClose>");
				#ifdef UNIX_SRC
					sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
				#else
					sprintf(buffer, "../Data/Window/%s", buffstring.data());
				#endif
				fileButton.open(buffer,std::ios::in);
				if(fileButton.is_open())
				{
					memset(b,0,255);fileButton.getline(b,256,'\n');
					buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
                    ReadWindowObject(win->GetButtonClose(),&fileButton);
					win->GetButtonClose()->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
				}fileButton.close();
				//READ Maximize BUTTON
				memset(b,0,255);file.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMaximize>","<#FileForButtonMaximize>");
				#ifdef UNIX_SRC
					sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
				#else
					sprintf(buffer, "../Data/Window/%s", buffstring.data());
				#endif
				fileButton.open(buffer,std::ios::in);
				if(fileButton.is_open())
				{
					memset(b,0,255);fileButton.getline(b,256,'\n');
					buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
                    ReadWindowObject(win->GetButtonMaximize(),&fileButton);
					win->GetButtonMaximize()->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
				}fileButton.close();
				//READ Minimize BUTTON
				memset(b,0,255);file.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMinimize>","<#FileForButtonMinimize>");
				#ifdef UNIX_SRC
					sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
				#else
					sprintf(buffer, "../Data/Window/%s", buffstring.data());
				#endif
				fileButton.open(buffer,std::ios::in);
				if(fileButton.is_open())
				{
					memset(b,0,255);fileButton.getline(b,256,'\n');
					buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
					ReadWindowObject(win->GetButtonMinimize(),&fileButton);
					win->GetButtonMinimize()->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
				}fileButton.close();
				//READ MinimizeToBar BUTTON
				memset(b,0,255);file.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMinimizeToBar>","<#FileForButtonMinimizeToBar>");
				#ifdef UNIX_SRC
					sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
				#else
					sprintf(buffer, "../Data/Window/%s", buffstring.data());
				#endif
				fileButton.open(buffer,std::ios::in);
				if(fileButton.is_open())
				{
					memset(b,0,255);fileButton.getline(b,256,'\n');
					buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
                    ReadWindowObject(win->GetButtonMinimizeToBar(),&fileButton);
					win->GetButtonMinimizeToBar()->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
				}fileButton.close();

			}
		}catch(ExCExpStringNotFound){std::cout<<"ReadWindowSubObject::ExCExpStringNotFound";}
	}else throw   ExCExpFileNotFound();
	file.close();
UnGuard
}

ExCWindowControl *  ExManagerObjectWindow::ReadWindowControlObject(ExCWindowObject *win,std::string FileName)
{
Guard(ExCWindowControl *  ExManagerObjectWindow::ReadWindowControlObject(ExCWindowObject *win,std::string FileName))
	char			buffer[255],b[255];
	std::string buffstring;
	std::ifstream fileControl;
	#ifdef UNIX_SRC
		sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
		sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif
	fileControl.open(buffer,std::ios::in);
	if(fileControl.is_open())
	{
		memset(b,0,255);fileControl.getline(b,256,'\n');
		buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
		// EXCWINDOWLABEL CONTROL					
		if(strcmp(buffstring.data(),"ExCWindowLabel")==0)
		{
			ExCWindowLabel *NewLabel;
			NewLabel= new ExCWindowLabel;
			ReadWindowObject(NewLabel,&fileControl);
			win->AddObjectControl(NewLabel);
		}
		// EXCWINDOWBUTTON CONTROL					
		if(strcmp(buffstring.data(),"ExCWindowButton")==0)
		{
			ExCWindowButton *NewButton;
			NewButton= new ExCWindowButton;
			ReadWindowObject(NewButton,&fileControl);
			//READ ACTION FOR BUTTON
			memset(b,0,255);fileControl.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<ActionCommand>","<#ActionCommand>");
			ExCAction Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
			ExCCommand Command=ExNihilo::ExtractIntValueFromSring(buffstring,"<Command>","<#Command>");
			Action.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
			NewButton->AddActionCommand(Action,Command);
			win->AddObjectControl(NewButton);
		}
		//EXCWINDOWBUTTONSWITCH CONTROL
		if(strcmp(buffstring.data(),"ExCWindowButtonSwitch")==0)
		{
			std::ifstream fileB1,fileB2;
			ExCWindowButtonSwitch *NewButton;
			NewButton= new ExCWindowButtonSwitch;
			ReadWindowObject(NewButton,&fileControl);
			ExCWindowButton * Butt1,*Butt2;
			Butt1=new ExCWindowButton;
			Butt2=new ExCWindowButton;

			//Read Normal Button
			memset(b,0,255);fileControl.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Button1>","<#Button1>");
			ReadWindowObject(Butt1,buffstring,&fileB1);
			NewButton->m_Butt1=Butt1;
			
			
			//Read Alternate Button
			memset(b,0,255);fileControl.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Button2>","<#Button2>");
			ReadWindowObject(Butt2,buffstring,&fileB2);
			NewButton->m_Butt2=Butt2;
			
			//READ ACTION FOR BUTTON1
			memset(b,0,255);fileB1.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<ActionCommand>","<#ActionCommand>");
			ExCAction Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
			ExCCommand Command=ExNihilo::ExtractIntValueFromSring(buffstring,"<Command>","<#Command>");
			Action.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
			Butt1->AddActionCommand(Action,Command);
			fileB1.close();
			
			//READ ACTION FOR BUTTON2
			memset(b,0,255);fileB2.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<ActionCommand>","<#ActionCommand>");
			Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
			Command=ExNihilo::ExtractIntValueFromSring(buffstring,"<Command>","<#Command>");
			Action.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
			Butt2->AddActionCommand(Action,Command);
			fileB2.close();
			
			NewButton->SwitchValue();
			//NewButton->SwitchValue();
			win->AddObjectControl(NewButton);
		}
		//EXCWINDOWBUTTONSWITCHONMOUSE CONTROL
		if(strcmp(buffstring.data(),"ExCWindowButtonSwitchOnMouse")==0)
		{
			std::ifstream fileB1,fileB2;
			ExCWindowButtonSwitchOnMouse *NewButton;
			NewButton= new ExCWindowButtonSwitchOnMouse;
			ReadWindowObject(NewButton,&fileControl);
			ExCWindowButton * Butt1,*Butt2;
			Butt1=new ExCWindowButton;
			Butt2=new ExCWindowButton;

			//Read Normal Button
			memset(b,0,255);fileControl.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Button1>","<#Button1>");
			ReadWindowObject(Butt1,buffstring,&fileB1);
			NewButton->m_Butt1=Butt1;
			
			
			//Read Alternate Button
			memset(b,0,255);fileControl.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Button2>","<#Button2>");
			ReadWindowObject(Butt2,buffstring,&fileB2);
			NewButton->m_Butt2=Butt2;
			
			//READ ACTION FOR BUTTON1
			memset(b,0,255);fileB1.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<ActionCommand>","<#ActionCommand>");
			ExCAction Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
			ExCCommand Command=ExNihilo::ExtractIntValueFromSring(buffstring,"<Command>","<#Command>");
			Action.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
			Butt1->AddActionCommand(Action,Command);
			fileB1.close();
			
			//READ ACTION FOR BUTTON2
			memset(b,0,255);fileB2.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<ActionCommand>","<#ActionCommand>");
			Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
			Command=ExNihilo::ExtractIntValueFromSring(buffstring,"<Command>","<#Command>");
			Action.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
			Butt2->AddActionCommand(Action,Command);
			fileB2.close();
			
			NewButton->SwitchValue();
			//NewButton->SwitchValue();
			win->AddObjectControl(NewButton);
		}
	}
	fileControl.close();
	return NULL;
UnGuard
}

std::string ExManagerObjectWindow::ReadWindowObject(ExCWindowObject *win,std::string FileName)
{
Guard(std::string ExManagerObjectWindow::ReadWindowObject(ExCWindowObject *win,std::string FileName))
	char			buffer[255],b[255];
	std::string buffstring;
	std::ifstream fileControl;
	#ifdef UNIX_SRC
		sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
		sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif
	fileControl.open(buffer,std::ios::in);
	if(fileControl.is_open())
	{
		memset(b,0,255);fileControl.getline(b,256,'\n');
		buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
		ReadWindowObject(win,&fileControl);
	}
	fileControl.close();
	return buffstring;//RETURN TYPE OF CONTROL
UnGuard
}

std::string ExManagerObjectWindow::ReadWindowObject(ExCWindowObject *win,std::string FileName,std::ifstream *fileReturn)
{
Guard(std::string ExManagerObjectWindow::ReadWindowObject(ExCWindowObject *win,std::string FileName,std::ifstream *fileReturn))
	char			buffer[255],b[255];
	std::string buffstring;
	#ifdef UNIX_SRC
		sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
		sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif
	fileReturn->open(buffer,std::ios::in);
	if(fileReturn->is_open())
	{
		memset(b,0,255);fileReturn->getline(b,256,'\n');
		buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
		ReadWindowObject(win,fileReturn);
	}
	return buffstring;//RETURN TYPE OF CONTROL
UnGuard
}
void ExManagerObjectWindow::ReadWindowObject(ExCWindowObject *win,std::ifstream *file)
{
Guard(void ExManagerObjectWindow::ReadWindowObject(ExCWindowObject *win,std::ifstream *file))
    char			b[255];
	std::string buffstring;
	try
	{
		//READ WINDOW POSITION
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowPosition>","<#WindowPosition>");
			win->SetPosition(ExCVec2D(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>")));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading WindowPosition:"<<buffstring<<std::endl;}
		//READ WINDOW SIZE
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowSize>","<#WindowSize>");
			win->SetWindowSize(ExCVec2D(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>")));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading WindowSize"<<std::endl;}
		//READ TITLE BAR SIZE
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			win->SetTitleBarSize(ExNihilo::ExtractFloatValueFromSring(b,"<TitleBarSize>","<#TitleBarSize>"));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading TitleBarSize"<<std::endl;}
		//READ WINDOW TITLE
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			win->SetWindowTitle(ExNihilo::ExtracValueFromSring(b,"<WindowTitle>","<#WindowTitle>"));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading WindowTitle"<<std::endl;}
		//READ WINDOW TITLE COLOR
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowTitleColor>","<#WindowTitleColor>");
			win->SetWindowTitleColor(ExCVec3D(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>")));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading WindowTitleColor"<<std::endl;}
		//READ IS BACRGROUND BLENDING AND VALUE
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			if(0!=ExNihilo::ExtractIntValueFromSring(b,"<IsBackroundBlending>","<#IsBackroundBlending>"))
			{
				memset(b,0,255);file->getline(b,256,'\n');
				win->SetBackroundBlending(true,ExNihilo::ExtractFloatValueFromSring(b,"<BackroundBlendingValue>","<#BackroundBlendingValue>"));
			}else 
			{
				memset(b,0,255);file->getline(b,256,'\n');
				win->SetBackroundBlending(false,ExNihilo::ExtractFloatValueFromSring(b,"<BackroundBlendingValue>","<#BackroundBlendingValue>"));
			}
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading IsBackroundBlending"<<std::endl;}
		//READ BACKGROUND COLOR
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<BackroundColor>","<#BackroundColor>");
			win->SetBackroundColor(ExCVec3D(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>")));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading BackroundColor"<<std::endl;}
		//READ IS SHOW BORDER
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			if(0!=ExNihilo::ExtractIntValueFromSring(b,"<ShowBorder>","<#ShowBorder>"))
			{
				win->SetShowBorder(true);
			}else 
			{
				win->SetShowBorder(false);
			}
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading ShowBorder"<<std::endl;}
		//READ BACKGROUND COLOR
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<BorderColor>","<#BorderColor>");
			win->SetBorderColor(ExCVec3D(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>")));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading BorderColor"<<std::endl;}
		//READ IS BACRGROUND TEXTURING AND TEXTURE 1
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			if(0!=ExNihilo::ExtractIntValueFromSring(b,"<BackroundIsTexturing1>","<#BackroundIsTexturing1>"))
			{
				memset(b,0,255);file->getline(b,256,'\n');
				win->SetBackroundTexturing1(true,ExNihilo::ExtracValueFromSring(b,"<BackroundTexture1>","<#BackroundTexture1>"));
			}else 
			{
				memset(b,0,255);file->getline(b,256,'\n');
				win->SetBackroundTexturing1(false,ExNihilo::ExtracValueFromSring(b,"<BackroundTexture1>","<#BackroundTexture1>"));
			}
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading BackroundIsTexturing1 :"<<buffstring<<std::endl;}	
		//READ IS BACRGROUND TEXTURING AND TEXTURE 2
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			if(0!=ExNihilo::ExtractIntValueFromSring(b,"<BackroundIsTexturing2>","<#BackroundIsTexturing2>"))
			{
				memset(b,0,255);file->getline(b,256,'\n');
				win->SetBackroundTexturing2(true,ExNihilo::ExtracValueFromSring(b,"<BackroundTexture2>","<#BackroundTexture2>"));
			}else 
			{
				memset(b,0,255);file->getline(b,256,'\n');
				win->SetBackroundTexturing2(false,ExNihilo::ExtracValueFromSring(b,"<BackroundTexture2>","<#BackroundTexture2>"));
			}
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading BackroundIsTexturing2:"<<buffstring<<std::endl;}	
		//READ TEXTURE IS MOUVING
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			if(0!=ExNihilo::ExtractIntValueFromSring(b,"<TextureIsMouving>","<#TextureIsMouving>"))
			{
				win->SetTextureIsMouving(true);
			}else 
			{
				win->SetTextureIsMouving(false);
			}
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading TextureIsMouving"<<std::endl;}
		//READ TEXTURE MOUVING VEC
		memset(b,0,255);file->getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<TextureMouvingVec>","<#TextureMouvingVec>");
			win->SetTextureMouvingVec(ExCVec2D(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>")));
		}catch(ExCExpStringNotFound){std::cout<<"Error Reading TextureMouvingVec:"<<buffstring<<std::endl;}
	}catch(...){throw ExCExpFileReadError();}
UnGuard
}

