/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerObjectWindow.h									*/
/*																		*/
/* Star Date   :03/14/2003												*/
/*																		*/
/* Last Update :                                                        */

/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGEROBJECTWINDOW_H__
#define __EXMANAGEROBJECTWINDOW_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "Math/ExMath.h"
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ExManagerWindow.h"
#include "Object/Object2D/WindowObject/ExCWindowObject.h"
#include "Object/Object2D/WindowObject/ExCWindow.h"
#include "Object/Object2D/WindowObject/ExCWindowControl.h"
#include "Object/Object2D/WindowObject/ExCWindowButton.h"
#include "Object/Object2D/WindowObject/ExCWindowButtonSwitch.h"
#include "Object/Object2D/WindowObject/ExCWindowLabel.h"
#include "Object/Object2D/WindowObject/ExCWindowEditLabel.h"
#include "Object/Object2D/WindowObject/ExCWindowMessageBox.h"
#include "Object/Object2D/WindowObject/ExCWindowMessageBoxQuestion.h"
#include "Object/Object2D/WindowObject/ExCWindowButtonSwitchOnMouse.h"
//--------------------------------
class ExManagerObjectWindow : public ExManagerObject<ExCWindow>
{
private:
//--------------------------------
// Singleton creation
//--------------------------------
	static bool m_flag; 
	static ExManagerObjectWindow *m_instance;
	ExManagerObjectWindow(void);
	~ExManagerObjectWindow(void);

	bool			m_MoveWindow;
	ExCVec2D		m_MovePointerShift;
	ExCCommand		m_LastCommandReceived;
	float			m_SizeWhenMinimized;
	bool			m_DrawAllWindow;
//--------------------------------
	ExManagerTexture			*ManagerTexture;
	ExManagerWindow				*ManagerWindow;
	ExCWindow					*ModalWindow;
	void OrganizeMinimizedWindow(void);
	void ReadWindowObject(ExCWindowObject *win,std::ifstream *file);
	std::string ReadWindowObject(ExCWindowObject *win,std::string FileName);
	std::string ReadWindowObject(ExCWindowObject *win,std::string FileName,std::ifstream *fileReturn);
	void ReadWindowSubObject(ExCWindow *win,std::string FileName);
	ExCWindowControl * ReadWindowControlObject(ExCWindowObject *win,std::string FileName);
public:
//--------------------------------
// Methode
//--------------------------------
	static ExManagerObjectWindow*  CreateSingleton(void);
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	void Reset(void);
	void Init(void);
	void Draw(void);
	ExCAction InputAction(ExCAction Action);
	ExCAction InputCommand(ExCCommand Command);
	bool SetCurrentObject(ExNihilo::ExId id);
	
	bool Load(std::string FileName);

	inline void SetSizeWhenMinimized(float value){m_SizeWhenMinimized=value;}
	inline float GetSizeWhenMinimized(void){ return m_SizeWhenMinimized;}
};
#endif //__EXMANAGEROBJECTWINDOW_H__
