/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerParticuleSystem.cpp,v 1.17 2002/11/24 11:58:58 data Exp $
 *
 */
#include "ExManagerParticuleSystem.h"

bool ExManagerParticuleSystem::m_flag = false; 
ExManagerParticuleSystem* ExManagerParticuleSystem::m_instance = NULL; 

ExManagerParticuleSystem* ExManagerParticuleSystem::CreateSingleton(void){
Guard(ExManagerParticuleSystem* ExManagerParticuleSystem::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerParticuleSystem; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerParticuleSystem::ExManagerParticuleSystem(void)
{
Guard(ExManagerParticuleSystem::ExManagerParticuleSystem(void))
	
UnGuard
}


ExManagerParticuleSystem::~ExManagerParticuleSystem(void)
{
Guard(ExManagerParticuleSystem::~ExManagerParticuleSystem(void))
UnGuard
}

void ExManagerParticuleSystem::Init(void)
{
Guard(void ExManagerModel::Init(void))
	ExManagerObject<ExCSystemeParticule>::Init();
UnGuard
}

void ExManagerParticuleSystem::Reset(void)
{
	ExManagerObject<ExCSystemeParticule>::Reset();
}

bool ExManagerParticuleSystem::Load(std::string  FileName)
{
Guard(bool ExManagerParticuleSystem::Load(std::string FileName))
    FileName="../Data/ParticuleSystem/"+FileName;
	try
	{
		ExCSystemeParticule	systeme;
		systeme.Consol=Consol;
		systeme.SetManagerTexture(ManagerTexture);
		systeme.SetManagerCollision(ManagerCollision);
		systeme.Load(FileName);
		return ExManagerObject<ExCSystemeParticule>::Add(systeme);
	}	
	catch(ExCExpFileNotFound)
	{
		*Consol<<"ExManagerParticuleSystem::ExCeption =>"<<FileName<<" File not found"<<std::endl;
		return false;
	}
	catch(ExCExpFileReadError)
	{
		*Consol<<"ExManagerParticuleSystem::ExCeption =>"<<FileName<<" Read file error"<<std::endl;
		return false;
	}
	catch(...)
	{
		*Consol<<"ExManagerParticuleSystem::ExCeption =>"<<FileName<<" Unknow exception"<<std::endl;
		return false;
	}
UnGuard
}

int ExManagerParticuleSystem::Start(std::string Name)
{
Guard(int ExManagerParticuleSystem::Start(std::string Name))
	/*for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		if(strcmp(m_ItMap->GetParticuleSystemeName(),param.data())==0)
		{
			m_ItMap->Start();
		}
	}
	 */
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::Stop(std::string Name)
{
Guard(int ExManagerParticuleSystem::Stop(std::string Name))
	/*for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		if(strcmp(m_ItMap->GetParticuleSystemeName(),param.data())==0)
		{
			m_ItMap->Stop();
		}
	}*/
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::Pause(std::string Name)
{
Guard(int ExManagerParticuleSystem::Pause(std::string Name))
	/*for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		if(strcmp(m_ItMap->GetParticuleSystemeName(),param.data())==0)
		{
			m_ItMap->Pause();
		}
	}*/
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::StartAll(void)
{
Guard(int ExManagerParticuleSystem::StartAll(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Start();
	}  
	return GetNumberEnableParticuleSysteme();
UnGuard
}

void ExManagerParticuleSystem::Draw(void)
{
Guard(void ExManagerParticuleSystem::Draw(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Draw();
	}
UnGuard
}

int ExManagerParticuleSystem::StopAll(void)
{
Guard(int ExManagerParticuleSystem::StopAll(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Stop();
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}
	
int ExManagerParticuleSystem::PauseAll(void)
{
Guard(int ExManagerParticuleSystem::PauseAll(void))
	for(m_ItMap=m_Map->begin();m_ItMap!=m_Map->end();m_ItMap++)
	{
		m_ItMap->second.Pause();
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}



ExCAction ExManagerParticuleSystem::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExManagerParticuleSystem::InputCommand(ExCCommand Command))
	return NOTHING;
UnGuard
}

ExCAction ExManagerParticuleSystem::InputAction(ExCAction Action)
{
Guard(ExCAction ExManagerParticuleSystem::InputAction(ExCAction Action))
	switch(Action.m_Action)
	{
	case LOAD_PARTICULESYSTEME:Load(Action.m_Param);break;
    case STAR_PARTICULESYSTEME:GetObject(Action.m_Param)->Start();break;
	case STOP_PARTICULESYSTEME:GetObject(Action.m_Param)->Stop();break;
	case PAUSE_PARTICULESYSTEME:GetObject(Action.m_Param)->Pause();break;
	case STAR_ALL_PARTICULESYSTEME:StartAll();break;
	case STOP_ALL_PARTICULESYSTEME:StopAll();break;
	case PAUSE_ALL_PARTICULESYSTEME:PauseAll();break;
	case LIST_PARTICULESYSTEME:List();break;

	default:
		*Consol<<"Can not file action in PARTICULESYSTEME_ACTION_MAP"<<std::endl;
		break;
	}	
 	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}
UnGuard
}

