/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerParticuleSystem.h								*/
/*																		*/
/* Start Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERPARTICULESYSTEM_H__
#define __EXMANAGERPARTICULESYSTEM_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerObject.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerCollision.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Particule/ExCSystemeParticule.h"
//------------------------------------------------------------------------
class ExManagerParticuleSystem : public ExManagerObject<ExCSystemeParticule> 
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerTexture			*ManagerTexture;
	ExManagerCollision			*ManagerCollision;
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerParticuleSystem *m_instance;
	ExManagerParticuleSystem(void);
	~ExManagerParticuleSystem(void);
public:
	static ExManagerParticuleSystem*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
	
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	inline void SetManagerCollision(ExManagerCollision * Collision){ManagerCollision = Collision;}

	bool Load(std::string FileName);
	void Init(void);
	void Reset(void);

	int Start(std::string Name);
	int Stop(std::string Name);
	int Pause(std::string Name);

	int Start(ExNihilo::ExId id);
	int Stop(ExNihilo::ExId id);
	int Pause(ExNihilo::ExId id);

	int StartAll(void);
	int StopAll(void);
	int PauseAll(void);

	inline int GetNumberEnableParticuleSysteme(void){return m_Map->size();}
			
	void Draw(void);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERPARTICULESYSTEM_H__
