/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerSound.h										*/
/*																		*/
/* Start Date  :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERSOUND_H__
#define __EXMANAGERSOUND_H__
//------------------------------------------------------------------------
//Includes
//-----------------------------------------------------------------------
#include "ExDefine.h"
//-----------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerObject.h"
//-----------------------------------------------------------------------
#include "Object/ExCSound.h"
//-----------------------------------------------------------------------
// Define
//-----------------------------------------------------------------------
#define MAX_SOUND 20
#define MAX_BUFFER 100
#define MAX_SOURCE 16
//-----------------------------------------------------------------------
class ExManagerSound : public ExManagerObject<ExCSound> 
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	bool m_initok;
	ALCcontext *context;
	ALCdevice *device;

	//For buffer
	ALuint      buffer_index;
	ALuint      buffer[MAX_BUFFER];
	ALint       error;


	ALboolean   loop;
	ALuint      source_index;
	ALuint      source_available;
	ALuint      source[64];
//------------------------------------------------------------------------
// Singleton creation 
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerSound *m_instance;
	ExManagerSound(void);
	~ExManagerSound(void);
public:
	static ExManagerSound*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Init (void);
	void Reset (void);
	ExCAction InputCommand(ExCCommand Command);
	ExCAction InputAction(ExCAction Action);
	
	void DisplayAviableInput (void);
	
	bool LoadSound (std::string);
	bool RemoveSound (std::string);
	void PlaySound (std::string);
	void StopSound (std::string);
	void PauseSound (std::string); 
	void SetRepeatSound (std::string);

	int GetSound (std::string);
};
//------------------------------------------------------------------------
#endif //__EXMANAGERSOUND_H__
