/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExManagerTexture.h										*/
/*																		*/
/* Start Date  :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXMANAGERTEXTURE_H__
#define __EXMANAGERTEXTURE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloExecption.h"
#include "ExCAction.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/ExCTexture.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerObject.h"
//------------------------------------------------------------------------
class ExManagerTexture : public ExManagerObject<ExCTexture>
{
	PFNGLMULTITEXCOORD2FARBPROC			glMultiTexCoord2fARB;
	PFNGLACTIVETEXTUREARBPROC			glActiveTextureARB;
	PFNGLCLIENTACTIVETEXTUREARBPROC		glClientActiveTextureARB;
//------------------------------------------------------------------------
	int			m_Anisotropy_level;
	int			m_Multitexturing_level;
	int			m_Anisotropy_max_level;
	int			m_Multitexturing_max_level;

	bool		m_Anisotropy;
	bool		m_SGIS_Mimap;
	bool		m_ARB_Multitexture;
	bool		m_ARB_Texture_Compression;
	bool		m_ARB_texture_env_dot3;
	bool		m_ARB_texture_env_combine;
	bool		m_ARB_texture_cube_map;
private:
//------------------------------------------------------------------------
// Singleton creation
//------------------------------------------------------------------------
	static bool m_flag; 
	static ExManagerTexture *m_instance;
	ExManagerTexture(void);
	~ExManagerTexture(void);
public:
	static ExManagerTexture*  CreateSingleton(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------

	void Reset(void);
	void Init(void);
	void Reload(void);
	bool Init(std::string  FileName);
	bool Load(std::string FileName);
	bool Add(std::string FileName);
    bool Add(ExCTexture object);
	bool CheckExist(std::string name);
	
	bool SetCurrentObject(std::string Name);
	bool SetCurrentObject(ExNihilo::ExId id);
	GLint GetTextureId(std::string Name);
	GLint GetTextureId(ExNihilo::ExId id);
	
	bool SetTexture(int Number,std::string Name);
	void SetTextureCoord(int Number,float CoordU,float CoordV);
	bool ResetMultitexture(void);

	ExCAction InputAction(ExCAction Action);

	bool LoadCubeMap(std::string FileName);
	inline int GetMaxMultitexturingLevel(void){return m_Multitexturing_max_level;}
	inline int GetMaxAnisotropyLevel(void){return m_Anisotropy_max_level;}
};
//------------------------------------------------------------------------
#endif //__EXMANAGERTEXTURE_H__
