/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */
#include "ExManagerVertexArrays.h"

bool ExManagerVertexArrays::m_flag = false; 
ExManagerVertexArrays* ExManagerVertexArrays::m_instance = NULL; 

ExManagerVertexArrays* ExManagerVertexArrays::CreateSingleton(void){
Guard(ExManagerVertexArrays* ExManagerVertexArrays::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerVertexArrays; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerVertexArrays::ExManagerVertexArrays(void)
{
	glLockArraysEXT = NULL;
	glUnlockArraysEXT = NULL;
}

ExManagerVertexArrays::~ExManagerVertexArrays(void)
{
	m_flag =false;
}

void ExManagerVertexArrays::Reset(void)
{
Guard(void ExManagerVertexArrays::Reset(void))
UnGuard
}

void ExManagerVertexArrays::Init(void)
{
Guard(void ExManagerVertexArrays::Init(void))
	glLockArraysEXT = NULL;
	glUnlockArraysEXT = NULL;
	char *extList = (char *) glGetString(GL_EXTENSIONS);
	//checking for compiled vertex array
	if(extList && strstr(extList,"GL_EXT_compiled_vertex_array"))
	{
		#ifdef UNIX_SRC
		#else
			glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC) 
			wglGetProcAddress("glLockArraysEXT");

			glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC)
			wglGetProcAddress("glUnlockArraysEXT");
		#endif
		//glEnableClientState ( GL_VERTEX_ARRAY );
		//glEnableClientState ( GL_TEXTURE_COORD_ARRAY );
	}
	if(glLockArraysEXT = NULL){ *Consol<<"OpenGl glLockArraysEXT extension missing"<<std::endl; return;}
	if(glUnlockArraysEXT = NULL){ *Consol<<"OpenGl glUnlockArraysEXT extension missing"<<std::endl; return;}
	*Consol<<"ExManagerVertexArrays::GL_EXT_compiled_vertex_array found and enable"<<std::endl;
	
UnGuard
}

int ExManagerVertexArrays::RegisterArray(GLfloat *vertex,GLfloat *texture)
{
Guard(void ExManagerVertexArrays::RegisterArray(GLfloat *vertex,GLfloat *texture))
	GLint x=0;
	m_Texture=texture;
	m_Vertex=vertex;
	glVertexPointer(3, GL_FLOAT, 0, m_Vertex);
	//glTexCoordPointer(2, GL_FLOAT, 0, m_Texture);
	std::cout<<x<<std::endl;
	return x;
UnGuard
}

void ExManagerVertexArrays::DrawElements(GLint Start,GLsizei count)
{
Guard(void ExManagerVertexArrays::ExManagerVertexArrays::DrawElements(GLint Start,GLsizei count))

UnGuard
}