/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */

#include "ExManagerVertexProgram.h"

bool ExManagerVertexProgram::m_flag = false; 
ExManagerVertexProgram* ExManagerVertexProgram::m_instance = NULL; 

ExManagerVertexProgram* ExManagerVertexProgram::CreateSingleton(void){
Guard(ExManagerVertexProgram* ExManagerVertexProgram::CreateSingleton(void))
	if(!m_flag)
	{
		m_flag = true; // We are creating the error log now, so set flag to true
		m_instance = new ExManagerVertexProgram; // Create the error log
	}else
	{
		std::cout<<"Error singleton already created"<<std::endl;
	}
	return m_instance; 
UnGuard
}

ExManagerVertexProgram::ExManagerVertexProgram (void) 
{

}

ExManagerVertexProgram::~ExManagerVertexProgram (void)
{
	
}

void ExManagerVertexProgram::Init (void) 
{
Guard (void ExManagerVertexProgram::init (void))
	/*char *ext = (char*)glGetString( GL_EXTENSIONS );

	if( strstr( ext, "GL_NV_vertex_program" ) == NULL )
	{
		std::cout<<"GL_NV_vertex_program extension was not found"<<std::endl;
		return;
	}
	else
	{
		glGenProgramsNV        = (PFNGLGENPROGRAMSNVPROC)wglGetProcAddress("glGenProgramsNV");
		glDeleteProgramsNV     = (PFNGLDELETEPROGRAMSNVPROC)wglGetProcAddress("glDeleteProgramsNV");
		glBindProgramNV        = (PFNGLBINDPROGRAMNVPROC)wglGetProcAddress("glBindProgramNV");
		glLoadProgramNV        = (PFNGLLOADPROGRAMNVPROC)wglGetProcAddress("glLoadProgramNV");
		glProgramParameter4fNV = (PFNGLPROGRAMPARAMETER4FNVPROC)wglGetProcAddress("glProgramParameter4fNV");
		glTrackMatrixNV        = (PFNGLTRACKMATRIXNVPROC)wglGetProcAddress("glTrackMatrixNV");

		if( !glGenProgramsNV || !glDeleteProgramsNV || !glBindProgramNV || 
	        !glLoadProgramNV || !glProgramParameter4fNV || !glTrackMatrixNV )
		{
			std::cout<<"One or more GL_NV_vertex_program functions were not found"<<std::endl;
			return;
		}
	}
	// Create the vertex program
    glGenProgramsNV( 1, &g_vertexProgramID );

    unsigned char *shader_assembly = readShaderFile( "../Data/VertexProgram/fog.nvv" );

    glLoadProgramNV( GL_VERTEX_PROGRAM_NV, g_vertexProgramID, 
                     strlen((char*) shader_assembly), shader_assembly );
    
    delete shader_assembly;*/
UnGuard
}	

void ExManagerVertexProgram::Reset (void)
{
Guard (void ExManagerVertexProgram::Reset (void))
	ExManagerObject<ExCVertexProgram>::Reset();
UnGuard
}

unsigned char *ExManagerVertexProgram::readShaderFile( const char *fileName )
{
Guard(unsigned char *ExManagerVertexProgram::readShaderFile( const char *fileName ))
    FILE *file = fopen( fileName, "r" );

    if( file == NULL )
    {
		std::cout<<"Cannot open shader file!"<<std::endl;
		return 0;
    }

    struct _stat fileStats;

    if( _stat( fileName, &fileStats ) != 0 )
    {
        std::cout<<"Cannot get file stats for shader file!"<<std::endl;
        return 0;
    }

    unsigned char *buffer = new unsigned char[fileStats.st_size];

	int bytes = fread( buffer, 1, fileStats.st_size, file );

    buffer[bytes] = 0;

	fclose( file );

	return buffer;
UnGuard
}

struct Vertex
{
    unsigned char r, g, b, a;
    float x, y, z;
};

Vertex g_quadVertices[] =
{
//     r    g    b    a      x     y     z
    { 255, 255,   0, 255, -1.0f,-1.0f, 0.0f, }, // Bottom-Left,  color = yellow
    { 255,   0,   0, 255,  1.0f,-1.0f, 0.0f, }, // Bottom-Right, color = red
    {   0, 255,   0, 255,  1.0f, 1.0f, 0.0f, }, // Top-Right,    color = green
    {   0,   0, 255, 255, -1.0f, 1.0f, 0.0f  }, // Top-Left,     color = blue
};

void ExManagerVertexProgram::Draw (void)
{
Guard (void ExManagerVertexProgram::Draw (void))
	std::cout<<"Draw"<<std::endl;
	//glMatrixMode( GL_MODELVIEW );
    //glLoadIdentity();
	glTranslatef( 0.0f, 0.0f, -5.0f );
  //  glRotatef( -45, 1.0f, 0.0f, 0.0f );
   // glRotatef( -g_fSpinX, 0.0f, 1.0f, 0.0f );

    // Track the combined model-view-projection matrix in registers c[0]-c[3]
    glTrackMatrixNV( GL_VERTEX_PROGRAM_NV, 0, GL_MODELVIEW_PROJECTION_NV, GL_IDENTITY_NV );
	std::cout<<"glTrackMatrixNV"<<std::endl;ExNihilo::ShowGlError();
    // Load a constant color into register c[4]

    glProgramParameter4fNV( GL_VERTEX_PROGRAM_NV, 4, 0.0f, 1.0f, 0.0f, 0.0f );
	std::cout<<"glProgramParameter4fNV"<<std::endl;ExNihilo::ShowGlError();
	glBindProgramNV( GL_VERTEX_PROGRAM_NV, g_vertexProgramID );
	std::cout<<"glBindProgramNV"<<std::endl;ExNihilo::ShowGlError();
	glEnable( GL_VERTEX_PROGRAM_NV );
	std::cout<<"glEnable"<<std::endl;ExNihilo::ShowGlError();
	glInterleavedArrays( GL_C4UB_V3F, 0, g_quadVertices );
	glDrawArrays( GL_QUADS, 0, 4 );

	glDisable( GL_VERTEX_PROGRAM_NV );
	std::cout<<"glDisable"<<std::endl;ExNihilo::ShowGlError();
	
UnGuard
}


