/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCRandomNumber.cpp,v 1.11 2002/06/21 19:04:10 binny Exp $
 *
 */

#include "ExCRandomNumber.h"

int ExCRandomNumber::is_init = false;

ExCRandomNumber::ExCRandomNumber () {
	if (! is_init) {
		srand (time (NULL));
		is_init = true;
	}
}

uint ExCRandomNumber::getInt (uint min, uint max) {
	uint value;
	uint v_tmp;
	if (max < min) {
		v_tmp = min;
		min = max;
		max = v_tmp;
	}
	
	do {
		value = (rand() % (max - min + 1)) + min;
	} while (value < min || value > max);
	
	return value;
}

float ExCRandomNumber::getFloat (float min, float max) {
	float value;
	float v_tmp;
	if (max < min) {
		v_tmp = min;
		min = max;
		max = v_tmp;
	}

	do {
		value = min + (float) getInt(0, (unsigned) ((max - min) * 1000)) / 1000;
	} while (value < min || value > max);
	
	return value;
}
