/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */

#include "ExCVec2D.h"

// Construction/Destruction

ExCVec2D::ExCVec2D()
{
	m_Vector[0]=0;m_Vector[1]=0;
}

ExCVec2D::ExCVec2D(float x,float y)
{
	m_Vector[0]=x;m_Vector[1]=y;
}

ExCVec2D::~ExCVec2D()
{

}

// Methode

float ExCVec2D::GetVectorLenght(void)
{
	return sqrt((m_Vector[0]*m_Vector[0])+(m_Vector[1]*m_Vector[1]));
}
ExCVec2D ExCVec2D::GetVecNormale(void)
{
	ExCVec2D VecNorm;
	VecNorm=*this;
	VecNorm=*this/this->GetVectorLenght();
	return VecNorm;
}
void ExCVec2D::SetValue(float x,float y)
{
	m_Vector[0]=x;
	m_Vector[1]=y;
	
}


// Operator surcharge
ExCVec2D& ExCVec2D::operator =(const ExCVec2D& Vec)
{
	m_Vector[0]=Vec.m_Vector[0];
	m_Vector[1]=Vec.m_Vector[1];
	return *this;
}
bool  ExCVec2D::operator==(const ExCVec2D& Vec)
{
	if(m_Vector[0]==Vec.m_Vector[0]||m_Vector[1]==Vec.m_Vector[1]) return true;
	else return false;
}

ExCVec2D  ExCVec2D::operator+(const ExCVec2D& Vec)
{
	ExCVec2D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]+Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]+Vec.m_Vector[1];
	return RetVec;
}

ExCVec2D  ExCVec2D::operator-(const ExCVec2D& Vec)
{
	ExCVec2D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]-Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]-Vec.m_Vector[1];
	return RetVec;
}
ExCVec2D  ExCVec2D::operator*(const ExCVec2D& Vec)
{
	ExCVec2D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]*Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]*Vec.m_Vector[1];
	return RetVec;
}
ExCVec2D  ExCVec2D::operator*(float scalar)
{
	ExCVec2D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]*scalar;
	RetVec.m_Vector[1]=m_Vector[1]*scalar;
	return RetVec;
}
ExCVec2D  ExCVec2D::operator/(const ExCVec2D& Vec)
{
	ExCVec2D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]/Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]/Vec.m_Vector[1];
	return RetVec;
}
ExCVec2D  ExCVec2D::operator/(float scalar)
{
	ExCVec2D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]/scalar;
	RetVec.m_Vector[1]=m_Vector[1]/scalar;
	return RetVec;
}

// Friends
std::ostream& operator<<(std::ostream& s,const ExCVec2D &vec)
{
	s<<"X:"<<(float)vec.m_Vector[0]<<" Y:"<<(float)vec.m_Vector[1];
	return s;
}

