/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */


#ifndef __EXCVEC2D_H__
#define __EXCVEC2D_H__

#include "ExDefine.h"
#include <math.h>
#include <cmath>

class ExCVec2D  
{
public:
//--------------------------------
//Variable
//--------------------------------
	float m_Vector[2];
//--------------------------------
//Constructor // Destructor
//--------------------------------
	ExCVec2D();
	ExCVec2D(float x,float y);
	~ExCVec2D();
//--------------------------------
//Methode
//--------------------------------
	float GetVectorLenght(void);
	ExCVec2D GetVecNormale(void);
	void SetValue(float x,float y);
	inline void SetX(double val){m_Vector[0]=val;}
	inline void SetY(double val){m_Vector[1]=val;}
	inline double GetX(void){return m_Vector[0];}
	inline double GetY(void){return m_Vector[1];}
//--------------------------------
// Operator
//--------------------------------
	ExCVec2D& operator=(const ExCVec2D& Vec);
	bool  operator==(const ExCVec2D& Vec);
	ExCVec2D  operator+(const ExCVec2D& Vec);
	ExCVec2D  operator-(const ExCVec2D& Vec);
	ExCVec2D  operator*(const ExCVec2D& Vec);
	ExCVec2D  operator*(float scalar);
	ExCVec2D  operator/(const ExCVec2D& Vec);
	ExCVec2D  operator/(float scalar);
//--------------------------------
// friends
//--------------------------------	
	friend std::ostream& operator<<(std::ostream& s,const ExCVec2D &vec);

};

#endif // __ExCVec2D_H__
