/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCVec3D.cpp,v 1.8 2002/11/09 16:09:42 data Exp $
 *
 */

#include "ExCVec3D.h"

// Construction/Destruction

ExCVec3D::ExCVec3D()
{
	SetValue(0,0,0);
}

ExCVec3D::ExCVec3D(float x,float y,float z)
{
	SetValue(x,y,z);
}

ExCVec3D::ExCVec3D(float x,float y)
{
	SetValue(x,y,0);
}

ExCVec3D::ExCVec3D(float x)
{
	SetValue(x,0,0);
}

ExCVec3D::ExCVec3D(const ExCVec3D &vec)
{
	SetValue(vec.m_Vector[0],vec.m_Vector[1],vec.m_Vector[2]);
}

ExCVec3D::~ExCVec3D()
{

}

// Methode

float ExCVec3D::GetVectorLenght(void)
{
	return sqrt((m_Vector[0]*m_Vector[0])+(m_Vector[1]*m_Vector[1])+(m_Vector[2]*m_Vector[2]));
}
ExCVec3D ExCVec3D::GetVecNormale(void)
{
	ExCVec3D VecNorm;
	VecNorm=*this;
	VecNorm=*this/this->GetVectorLenght();
	return VecNorm;
}
void ExCVec3D::SetValue(float x,float y,float z)
{
	m_Vector[0]=x;
	m_Vector[1]=y;
	m_Vector[2]=z;
}

// Operator surcharge
ExCVec3D& ExCVec3D::operator =(const ExCVec3D& Vec)
{
	SetValue(Vec.m_Vector[0],Vec.m_Vector[1],Vec.m_Vector[2]);
	return *this;
}
bool  ExCVec3D::operator==(const ExCVec3D& Vec)
{
	if(m_Vector[0]==Vec.m_Vector[0]||m_Vector[1]==Vec.m_Vector[1]||m_Vector[2]==Vec.m_Vector[2]) return true;
	else return false;
}

ExCVec3D  ExCVec3D::operator+(const ExCVec3D& Vec)
{
	return ExCVec3D(m_Vector[0]+Vec.m_Vector[0],m_Vector[1]+Vec.m_Vector[1],m_Vector[2]+Vec.m_Vector[2]);
}

ExCVec3D  ExCVec3D::operator+(float scalar)
{
	return ExCVec3D(m_Vector[0]+scalar,m_Vector[1]+scalar,m_Vector[2]+scalar);
}

ExCVec3D  ExCVec3D::operator-(const ExCVec3D& Vec)
{
	return ExCVec3D(m_Vector[0]-Vec.m_Vector[0],m_Vector[1]-Vec.m_Vector[1],m_Vector[2]-Vec.m_Vector[2]);
}

ExCVec3D  ExCVec3D::operator-(float scalar)
{
	return ExCVec3D(m_Vector[0]-scalar,m_Vector[1]-scalar,m_Vector[2]-scalar);
}

ExCVec3D  ExCVec3D::operator*(const ExCVec3D& Vec)
{
	return ExCVec3D(m_Vector[0]*Vec.m_Vector[0],m_Vector[1]*Vec.m_Vector[1],m_Vector[2]*Vec.m_Vector[2]);
}

ExCVec3D  ExCVec3D::operator*(float scalar)
{
	return ExCVec3D(m_Vector[0]*scalar,m_Vector[1]*scalar,m_Vector[2]*scalar);
}

ExCVec3D  ExCVec3D::operator/(const ExCVec3D& Vec)
{
	return ExCVec3D(m_Vector[0]/Vec.m_Vector[0],m_Vector[1]/Vec.m_Vector[1],m_Vector[2]/Vec.m_Vector[2]);
}

ExCVec3D  ExCVec3D::operator/(float scalar)
{
	return ExCVec3D(m_Vector[0]/scalar,m_Vector[1]/scalar,m_Vector[2]/scalar);
}

ExCVec3D  ExCVec3D::operator++()
{
	m_Vector[0]++;m_Vector[1]++;m_Vector[2]++;
	return *this;
}
ExCVec3D  ExCVec3D::operator++(int)
{
	m_Vector[0]++;m_Vector[1]++;m_Vector[2]++;
	return *this;
}
ExCVec3D  ExCVec3D::operator--()
{
	m_Vector[0]--;m_Vector[1]--;m_Vector[2]--;
	return *this;
}
ExCVec3D  ExCVec3D::operator--(int)
{
	m_Vector[0]--;m_Vector[1]--;m_Vector[2]--;
	return *this;
}
/*ExCVec3D  ExCVec3D::operator+=(const ExCVec3D& Vec)
{
	
}*/
// Friends
std::ostream& operator<<(std::ostream& s,const ExCVec3D &vec)
{
	s<<"X:"<<(float)vec.m_Vector[0]<<" Y:"<<(float)vec.m_Vector[1]<<" Z:"<<(float)vec.m_Vector[2];
	return s;
}
std::ostrstream& operator<<(std::ostrstream& s,const ExCVec3D &vec)
{
	s<<"X:"<<(float)vec.m_Vector[0]<<" Y:"<<(float)vec.m_Vector[1]<<" Z:"<<(float)vec.m_Vector[2];
	return s;
}
