// ExMessage.h: interface for the ExCMessage class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __EXCMESSAGE_H__
#define __EXCMESSAGE_H__


#include "ExDefine.h"


class ExCMessage  
{
private:
	int m_Type;
	std::string m_Message;
	
public:

	ExCMessage();
	ExCMessage(ExCMessage& message);
	virtual ~ExCMessage();

	inline void SetMessage(std::string message){m_Message=message;}
	inline void SetType(int type){m_Type=type;}

	inline int GetType(void){return m_Type;}
	inline std::string GetMessage(void){return m_Message;}

	friend std::ostream& operator<<(std::ostream& s,ExCMessage &msg);
	friend std::ostrstream& operator<<(std::ostrstream& s,ExCMessage &msg);

};

//////////////////////////////////////////////////////////////////////
//Messages table
//////////////////////////////////////////////////////////////////////
#define MESSAGE_ACK						1000
#define MESSAGE_LOGIN					1001
#define MESSAGE_QUIT					1002
#define MESSAGE_PING					1003
#define MESSAGE_SAY						1004
#endif // __EXCMESSAGE_H__
