// Socket.cpp: implementation of the ExCSocket class.
//
//////////////////////////////////////////////////////////////////////
#include "ExCSocket.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ExCSocket::ExCSocket(){Guard(ExCSocket::ExCSocket())
#if _WIN32
	WSADATA WSAData;
	WSAStartup(MAKEWORD(2,0), &WSAData);
#endif
	SetSocketPort(5000);
	m_hSocket=socket(AF_INET,SOCK_STREAM,0);
	if(m_hSocket==-1)
	{
		std::cout<<"Socket error"<<std::endl;
	}
UnGuard
}

ExCSocket::ExCSocket(int Handler)
{
Guard(ExCSocket::ExCSocket(int handler))
	SetHandler(Handler);
UnGuard
}

ExCSocket::ExCSocket(int * Handler)
{
Guard(ExCSocket::ExCSocket(int handler))
	SetHandler(*Handler);
UnGuard
}

ExCSocket::ExCSocket(ExCSocket& socket)
{
Guard(ExCSocket::ExCSocket(ExCSocket& socket))
	SetSocketPort(socket.GetSocketPort());
	SetHandler(socket.GetHandler());
	SetIp(socket.GetIp());
UnGuard
}

ExCSocket::ExCSocket(int domaine,int protocole)
{
Guard(ExCSocket::ExCSocket(int domaine,int protocole))
	m_hSocket=socket(domaine,protocole,0);
	if(m_hSocket==-1)
	{
		std::cout<<"Erreur socket"<<std::endl;
	}
UnGuard
}

ExCSocket::~ExCSocket()
{
Guard(ExCSocket::~ExCSocket())
	Close();
UnGuard
}

//////////////////////////////////////////////////////////////////////
// Function
//////////////////////////////////////////////////////////////////////

void ExCSocket::Init(void)
{
Guard(ExCSocket::Init(void))
#if _WIN32
	//m_AdresseSocket.sin_addr.s_addr			= inet_addr("192.168.0.1");
	m_AdresseSocket.sin_addr.s_addr			= inet_addr("80.200.104.109");
#else
	//if((m_pInfosHost=gethostbyname("lore.starfleet.org"))==0)
	if((m_pInfosHost=gethostbyname("hobbes.homelinux.net"))==0)
	{
		Trace("Erreur d'aquisition sur le host");
		EXC
	}
	memcpy(&m_AdresseIP,m_pInfosHost->h_addr,m_pInfosHost->h_length);
	SetIp(inet_ntoa(m_AdresseIP));
	memset(&m_AdresseSocket,0,sizeof(struct sockaddr_in));
	memcpy(&m_AdresseSocket.sin_addr,m_pInfosHost->h_addr,m_pInfosHost->h_length);
#endif
	m_AdresseSocket.sin_family= AF_INET;//le domaine
	m_AdresseSocket.sin_port=htons(m_Port);
UnGuard
}


void ExCSocket::Close(void){Guard(void ExCSocket::Close(void))
#if _WIN32
	closesocket(m_hSocket);
	WSACleanup();
#else
	close(m_hSocket);
#endif
UnGuard
}

void ExCSocket::SendMessage(ExCMessage &OutMessage){Guard(void ExCSocket::SendMessage(ExCMessage OutMessage))
	char *buffer;
	buffer= new char[500];
	sprintf(buffer,"%d#%s%s",OutMessage.GetType(),OutMessage.GetMessage().data(),"\0");
	if(send(m_hSocket,buffer,500,0)==-1) 
	{Trace(Error on send Message)}
UnGuard
}

void ExCSocket::RecvMessage(ExCMessage &InMessage)
{
Guard(void ExCSocket::RecvMessage(ExCMessage InMessage))
	
	char * buffer;
	buffer = new char[500];
	if(recv(m_hSocket,buffer,500,0)==-1)
	{
		Trace(Error on Recv Message)	
	}
	//extract type
	std::string bufftype;
	for(unsigned int i=0;i<4;i++)
	{
		bufftype=bufftype+buffer[i];
	}
	InMessage.SetType(atoi(bufftype.data()));
	//extract msg
	std::string  bufferMsg;
	for(unsigned int j=5;j<500;j++)
	{
		bufferMsg=bufferMsg+buffer[j];
		if(strcmp("\0",&buffer[j])==0)break;
	}
	InMessage.SetMessage(bufferMsg);
UnGuard
}

