/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCSocket.h												*/
/*																		*/
/* Star Date   :22/09/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCSOCKET_H__
#define __EXCSOCKET_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#if _WIN32
	#include <winsock2.h>
#else
	#include <unistd.h>
	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netdb.h>
	#include <netinet/in.h>
	#include <netinet/tcp.h>
	#include <arpa/inet.h>
	#include <errno.h>
#endif
#include "NetWork/ExCMessage.h"
//------------------------------------------------------------------------
class ExCSocket
{
public:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	int m_Port;
	std::string m_pIP;
	int m_hSocket;
	struct hostent *m_pInfosHost;		//info sur le host(gethost by name)
	struct in_addr m_AdresseIP;			//Adress internet format rzo
	struct sockaddr_in m_AdresseSocket; //Structure de type sockaddr 
public:
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCSocket();
	ExCSocket(ExCSocket& socket);
	ExCSocket(int Handler);
	ExCSocket(int * Handler);
	ExCSocket(int domaine,int protocole);
	~ExCSocket();
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Init(void);
	void Close(void);
	 int GetHandler(void){return m_hSocket;}
	 void SetHandler(int handler){m_hSocket=handler;}
	 std::string GetIp(void){return m_pIP;}
	 void SetIp(std::string ip){m_pIP=ip;}
	 int GetSocketPort(void){return m_Port;}
	 void SetSocketPort(int port){m_Port=port;}

	 	
	void SendMessage(ExCMessage &OutMessage);
	void RecvMessage(ExCMessage &InMessage);

};
//------------------------------------------------------------------------
#endif //__EXCSOCKET_H__