// ExCSocketServeur.cpp: implementation of the ExCSocketServer class.
//
//////////////////////////////////////////////////////////////////////
#include "ExCSocketServer.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ExCSocketServer::ExCSocketServer(){Guard(ExCSocketServer::ExCSocketServer())
	ExCSocket();
UnGuard
}

ExCSocketServer::ExCSocketServer(int domaine,int protocole){Guard(ExCSocketServer::ExCSocketServer())
	ExCSocket(domaine,protocole);
UnGuard
}

ExCSocketServer::~ExCSocketServer(){Guard(ExCSocketServer::~ExCSocketServer())
	Close();
UnGuard
}

int ExCSocketServer::Listen(){Guard(ExCSocketServer::Listen())
	int hNewSocket=0;
	#ifdef _WIN32 
		int tailleSockaddr_in;
	#else 
		unsigned int tailleSockaddr_in;
	#endif
	

	tailleSockaddr_in= sizeof(struct sockaddr_in);
	hNewSocket=accept(m_hSocket,(struct sockaddr *)&m_AdresseSocket,&tailleSockaddr_in);
	if(hNewSocket==-1)
	{
		Close();
		Trace(Erreur sur le listen)
		EXC
	}
	return hNewSocket;

UnGuard
}

void ExCSocketServer::Init(void){Guard(CSocket::Init(void))
	ExCSocket::Init();
	#ifndef _WIN32
		if(bind(m_hSocket,(struct sockaddr *)&m_AdresseSocket,sizeof(struct sockaddr_in))==-1)
		{
			Trace(Erreur sur le bind su socket)
			EXC	
		}
		if(listen(m_hSocket,SOMAXCONN)==-1)
		{
			close(m_hSocket);
			EXC
		}
	#endif
UnGuard
}
